

<?php $__env->startSection('title', 'تنظیمات امنیتی'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">تنظیمات امنیتی</h3>
                </div>
                <div class="card-body">
                    <!-- تب‌های گروه‌های تنظیمات -->
                    <ul class="nav nav-tabs" id="securityTabs" role="tablist">
                        <?php $__currentLoopData = $groups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $groupKey => $groupTitle): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link <?php echo e($loop->first ? 'active' : ''); ?>" 
                                        id="<?php echo e($groupKey); ?>-tab" 
                                        data-bs-toggle="tab" 
                                        data-bs-target="#<?php echo e($groupKey); ?>" 
                                        type="button" 
                                        role="tab" 
                                        aria-controls="<?php echo e($groupKey); ?>" 
                                        aria-selected="<?php echo e($loop->first ? 'true' : 'false'); ?>">
                                    <?php echo e($groupTitle); ?>

                                </button>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>

                    <!-- محتوای تب‌ها -->
                    <div class="tab-content mt-4" id="securityTabsContent">
                        <?php $__currentLoopData = $groups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $groupKey => $groupTitle): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="tab-pane fade <?php echo e($loop->first ? 'show active' : ''); ?>" 
                                 id="<?php echo e($groupKey); ?>" 
                                 role="tabpanel" 
                                 aria-labelledby="<?php echo e($groupKey); ?>-tab">
                                <form class="security-settings-form" data-group="<?php echo e($groupKey); ?>">
                                    <?php echo csrf_field(); ?>
                                    <div class="table-responsive">
                                        <table class="table table-bordered">
                                            <thead>
                                                <tr>
                                                    <th>تنظیم</th>
                                                    <th>مقدار</th>
                                                    <th>وضعیت</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php $__currentLoopData = $settings[$groupKey]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $setting): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>
                                                        <td>
                                                            <strong><?php echo e($setting->description); ?></strong>
                                                            <small class="d-block text-muted"><?php echo e($setting->key); ?></small>
                                                        </td>
                                                        <td>
                                                            <?php if($setting->options): ?>
                                                                <select name="settings[<?php echo e($setting->id); ?>][value]" 
                                                                        class="form-control">
                                                                    <?php $__currentLoopData = json_decode($setting->options, true); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <option value="<?php echo e($value); ?>" 
                                                                                <?php echo e($setting->value == $value ? 'selected' : ''); ?>>
                                                                            <?php echo e($label); ?>

                                                                        </option>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </select>
                                                            <?php else: ?>
                                                                <input type="text" 
                                                                       class="form-control"
                                                                       name="settings[<?php echo e($setting->id); ?>][value]"
                                                                       value="<?php echo e($setting->value); ?>">
                                                            <?php endif; ?>
                                                        </td>
                                                        <td>
                                                            <div class="form-check form-switch">
                                                                <input type="checkbox" 
                                                                       class="form-check-input setting-status"
                                                                       id="status_<?php echo e($setting->id); ?>"
                                                                       <?php echo e($setting->is_active ? 'checked' : ''); ?>

                                                                       data-group="<?php echo e($setting->group); ?>"
                                                                       data-key="<?php echo e($setting->key); ?>">
                                                                <label class="form-check-label" 
                                                                       for="status_<?php echo e($setting->id); ?>">
                                                                    <?php echo e($setting->is_active ? 'فعال' : 'غیرفعال'); ?>

                                                                </label>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                    </div>
                                    <div class="text-left mt-3">
                                        <button type="submit" class="btn btn-primary">
                                            ذخیره تنظیمات
                                        </button>
                                    </div>
                                </form>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.nav-tabs .nav-link {
    color: #4e73df;
    background-color: #f8f9fc;
    border: 1px solid #e3e6f0;
    border-bottom: none;
    margin-bottom: -1px;
    padding: 0.75rem 1.25rem;
    font-weight: 500;
}

.nav-tabs .nav-link.active {
    color: #4e73df;
    background-color: #fff;
    border-color: #e3e6f0 #e3e6f0 #fff;
}

.nav-tabs .nav-link:hover {
    border-color: #e3e6f0 #e3e6f0 #e3e6f0;
    isolation: isolate;
}

.tab-content {
    background-color: #fff;
    border: 1px solid #e3e6f0;
    border-top: none;
    padding: 1.25rem;
}

.form-check-input:checked {
    background-color: #4e73df;
    border-color: #4e73df;
}

/* Dark mode styles */
.dark-mode .nav-tabs .nav-link {
    color: #e0e0e0;
    background-color: #2d2d2d;
    border-color: #333;
}

.dark-mode .nav-tabs .nav-link.active {
    color: #4e73df;
    background-color: #1e1e1e;
    border-color: #333 #333 #1e1e1e;
}

.dark-mode .nav-tabs .nav-link:hover {
    border-color: #333 #333 #333;
}

.dark-mode .tab-content {
    background-color: #1e1e1e;
    border-color: #333;
    color: #e0e0e0;
}
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // مدیریت فرم‌های تنظیمات
    document.querySelectorAll('.security-settings-form').forEach(form => {
        form.addEventListener('submit', async function(e) {
            e.preventDefault();
            
            try {
                const response = await fetch('<?php echo e(route("admin.security-settings.update")); ?>', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
                    },
                    body: JSON.stringify(Object.fromEntries(new FormData(form)))
                });
                
                const result = await response.json();
                
                if (response.ok) {
                    Swal.fire({
                        title: 'موفق',
                        text: result.message,
                        icon: 'success',
                        confirmButtonText: 'باشه'
                    });
                } else {
                    Swal.fire({
                        title: 'خطا',
                        text: 'خطا در بروزرسانی تنظیمات',
                        icon: 'error',
                        confirmButtonText: 'باشه'
                    });
                }
            } catch (error) {
                Swal.fire({
                    title: 'خطا',
                    text: 'خطا در برقراری ارتباط با سرور',
                    icon: 'error',
                    confirmButtonText: 'باشه'
                });
            }
        });
    });

    // مدیریت تغییر وضعیت تنظیمات
    document.querySelectorAll('.setting-status').forEach(checkbox => {
        checkbox.addEventListener('change', async function() {
            try {
                const response = await fetch('<?php echo e(route("admin.security-settings.toggle")); ?>', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
                    },
                    body: JSON.stringify({
                        group: this.dataset.group,
                        key: this.dataset.key,
                        is_active: this.checked
                    })
                });
                
                const result = await response.json();
                
                if (response.ok) {
                    Swal.fire({
                        title: 'موفق',
                        text: result.message,
                        icon: 'success',
                        confirmButtonText: 'باشه'
                    });
                    this.closest('label').textContent = this.checked ? 'فعال' : 'غیرفعال';
                } else {
                    Swal.fire({
                        title: 'خطا',
                        text: 'خطا در تغییر وضعیت',
                        icon: 'error',
                        confirmButtonText: 'باشه'
                    });
                    this.checked = !this.checked;
                }
            } catch (error) {
                Swal.fire({
                    title: 'خطا',
                    text: 'خطا در برقراری ارتباط با سرور',
                    icon: 'error',
                    confirmButtonText: 'باشه'
                });
                this.checked = !this.checked;
            }
        });
    });
});
</script>
<?php $__env->stopPush(); ?> 
<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/aluirani/public_html/aludubai.ir/resources/views/admin/security-settings/index.blade.php ENDPATH**/ ?>