<?php $__env->startSection('title', isset($location) ? $location->title . ' | ' . config('app.name') : config('app.name')); ?>

<?php $__env->startPush('head'); ?>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<link rel="stylesheet" href="<?php echo e(asset('css/modern-base-template.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('css/modern-rating-system.css')); ?>">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/leaflet@1.9.3/dist/leaflet.css" />
<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
<meta property="og:title" content="<?php echo e($location->title ?? 'مکان'); ?>">
<meta property="og:description" content="<?php echo e(Str::limit($location->description ?? '', 160)); ?>">
<?php if($location->images): ?>
    <?php
        $locationImages = is_array($location->images) ? $location->images : (is_string($location->images) ? json_decode($location->images, true) : []);
        $firstImage = ($locationImages ?? [])[0] ?? null;
    ?>
    <?php if($firstImage): ?>
        <meta property="og:image" content="<?php echo e(asset('storage/' . (is_string($firstImage) ? $firstImage : ($firstImage['path'] ?? '')))); ?>">
    <?php endif; ?>
<?php endif; ?>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<!-- Modern Professional Breadcrumb Navigation -->
<div class="breadcrumb-container">
    <div class="container">
        <nav aria-label="مسیر صفحه" role="navigation">
            <ol class="breadcrumb modern-breadcrumb" itemscope itemtype="https://schema.org/BreadcrumbList">
                <li class="breadcrumb-item" itemprop="itemListElement" itemscope itemtype="https://schema.org/ListItem">
                    <a href="<?php echo e(url('/')); ?>" itemprop="item" title="بازگشت به صفحه اصلی">
                        <i class="fas fa-home" aria-hidden="true"></i>
                        <span itemprop="name">خانه</span>
                    </a>
                    <meta itemprop="position" content="1" />
                </li>
                <?php if(isset($categoryHierarchy) && count($categoryHierarchy) > 0): ?>
                    <?php $__currentLoopData = $categoryHierarchy; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li class="breadcrumb-item" itemprop="itemListElement" itemscope itemtype="https://schema.org/ListItem">
                            <?php if(isset($category->category_key)): ?>
                                <a href="<?php echo e(url('/' . $category->category_key)); ?>" itemprop="item"
                                   title="مشاهده <?php echo e($category->name_fa ?? $category->category_fa ?? $category->name ?? $category->category_key); ?>">
                                    <i class="fas fa-layer-group" aria-hidden="true"></i>
                                    <span itemprop="name"><?php echo e($category->name_fa ?? $category->category_fa ?? $category->name ?? $category->category_key); ?></span>
                                </a>
                            <?php else: ?>
                                <span itemprop="name">
                                    <i class="fas fa-layer-group" aria-hidden="true"></i>
                                    <?php echo e($category->name_fa ?? $category->category_fa ?? $category->name ?? 'دسته‌بندی'); ?>

                                </span>
                            <?php endif; ?>
                            <meta itemprop="position" content="<?php echo e($index + 2); ?>" />
                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php elseif($location->category_fa): ?>
                    <li class="breadcrumb-item" itemprop="itemListElement" itemscope itemtype="https://schema.org/ListItem">
                        <span itemprop="name">
                            <i class="fas fa-layer-group" aria-hidden="true"></i>
                            <?php echo e($location->category_fa); ?>

                        </span>
                        <meta itemprop="position" content="2" />
                    </li>
                <?php endif; ?>
                <li class="breadcrumb-item active" aria-current="page" itemprop="itemListElement" itemscope itemtype="https://schema.org/ListItem">
                    <span itemprop="name">
                        <i class="fas fa-map-marker-alt" aria-hidden="true"></i>
                        <?php echo e(Str::limit($location->title, 50)); ?>

                    </span>
                    <meta itemprop="position" content="<?php echo e((isset($categoryHierarchy) && count($categoryHierarchy) > 0) ? count($categoryHierarchy) + 2 : ($location->category_fa ? 3 : 2)); ?>" />
                </li>
            </ol>
        </nav>
    </div>
</div>

<?php if(isset($location)): ?>
    <!-- Hero Section -->
    <div class="location-hero">
        <div class="hero-background">
            <?php if($location->images): ?>
                <?php
                    $heroImages = is_array($location->images) ? $location->images : (is_string($location->images) ? json_decode($location->images, true) : []);
                    $firstImage = ($heroImages ?? [])[0] ?? null;
                ?>
                <?php if($firstImage): ?>
                    <img src="<?php echo e(asset('storage/' . (is_string($firstImage) ? $firstImage : ($firstImage['path'] ?? '')))); ?>"
                         alt="<?php echo e($location->title); ?>" class="hero-image">
                <?php endif; ?>
            <?php endif; ?>
            <div class="hero-overlay"></div>
        </div>
        <div class="container">
            <div class="hero-content">
                <div class="hero-top-info">
                    <div class="location-badges">
                        <div class="location-badge primary">
                            <i class="fas fa-map-marker-alt"></i>
                            <?php echo e($location->category_fa ?? 'مکان'); ?>

                        </div>
                        <?php if($location->package_type && $location->package_type !== 'regular'): ?>
                            <div class="location-badge premium <?php echo e($location->package_type); ?>">
                                <i class="fas fa-crown"></i>
                                <?php echo e(ucfirst($location->package_type)); ?>

                            </div>
                        <?php endif; ?>
                        <?php if($location->star_rating): ?>
                            <div class="location-badge rating">
                                <i class="fas fa-star"></i>
                                <?php echo e($location->star_rating); ?>/5
                            </div>
                        <?php endif; ?>
                    </div>
                    <?php if($location->emoji): ?>
                        <div class="location-emoji"><?php echo e($location->emoji); ?></div>
                    <?php endif; ?>
                </div>

                <h1 class="location-title"><?php echo e($location->title); ?></h1>
            </div>
        </div>
    </div>

    <!-- Main Content -->
    <div class="container location-content">
        <div class="row g-4">
            <div class="col-lg-8">
                <!-- Quick Info Cards -->
                <div class="quick-info-grid">
                    <?php if($location->phone): ?>
                        <div class="quick-info-card">
                            <div class="info-icon">
                                <i class="fas fa-phone"></i>
                            </div>
                            <div class="info-content">
                                <span class="info-label">تلفن تماس</span>
                                <a href="tel:<?php echo e($location->phone); ?>" class="info-value"><?php echo e($location->phone); ?></a>
                            </div>
                        </div>
                    <?php endif; ?>

                    <?php if($location->open_hours || $location->closing_hours): ?>
                        <div class="quick-info-card">
                            <div class="info-icon">
                                <i class="fas fa-clock"></i>
                            </div>
                            <div class="info-content">
                                <span class="info-label">ساعات کاری</span>
                                <div class="working-hours-display">
                                    <span class="info-value"><?php echo e($location->open_hours ?? '۹ صبح'); ?> تا <?php echo e($location->closing_hours ?? '۹ شب'); ?></span>
                                    <?php
                                        $locationStatus = \App\Helpers\TimezoneHelper::getLocationStatus($location);
                                        $isOpen = $locationStatus['isOpen'];
                                        $statusText = $locationStatus['statusText'];
                                        $statusClass = $locationStatus['statusClass'];
                                        $timezone = $locationStatus['timezone'];
                                        $now = $locationStatus['currentTime'];
                                    ?>
                                    <span class="status-badge <?php echo e($statusClass); ?>">
                                        <i class="fas fa-circle"></i>
                                        <?php echo e($statusText); ?>

                                    </span>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>

                    <?php if($location->url): ?>
                        <div class="quick-info-card">
                            <div class="info-icon">
                                <i class="fas fa-globe"></i>
                            </div>
                            <div class="info-content">
                                <span class="info-label">وب‌سایت</span>
                                <a href="<?php echo e($location->url); ?>" target="_blank" class="info-value">
                                    مشاهده سایت
                                    <i class="fas fa-external-link-alt ms-1"></i>
                                </a>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>

                <!-- Description Section -->
                <?php if($location->description || $location->Slogan): ?>
                <div class="content-section">
                    <div class="section-header">
                        <h2 class="section-title">
                            <i class="fas fa-info-circle"></i>
                            درباره این مکان
                        </h2>
                    </div>
                    <div class="section-content">
                        <?php if($location->Slogan): ?>
                            <div class="location-slogan-section">
                                <blockquote class="location-slogan-quote">
                                    <i class="fas fa-quote-right slogan-quote-icon"></i>
                                    <p class="slogan-text"><?php echo e($location->Slogan); ?></p>
                                    <i class="fas fa-quote-left slogan-quote-icon"></i>
                                </blockquote>
                            </div>
                        <?php endif; ?>
                        <?php if($location->description): ?>
                            <p class="description-text"><?php echo e($location->description); ?></p>
                        <?php endif; ?>
                    </div>
                </div>
                <?php endif; ?>

                <!-- Image Gallery -->
                <?php if($location->images): ?>
                    <?php
                        $images = is_array($location->images) ? $location->images : (json_decode($location->images, true) ?? []);
                    ?>
                    <?php if(count($images) > 0): ?>
                    <div class="content-section">
                        <div class="section-header">
                            <h2 class="section-title">
                                <i class="fas fa-images"></i>
                                گالری تصاویر
                            </h2>
                            <span class="image-count"><?php echo e(count($images)); ?> تصویر</span>
                        </div>
                        <div class="modern-gallery">
                            <?php if(count($images) > 0): ?>
                                <!-- Main Image -->
                                <div class="gallery-main">
                                    <?php $mainImage = $images[0]; $mainImagePath = is_string($mainImage) ? $mainImage : (is_array($mainImage) && isset($mainImage['path']) ? $mainImage['path'] : ''); ?>
                                    <?php if(!empty($mainImagePath)): ?>
                                    <div class="main-image-container" onclick="openLightbox(0)">
                                        <img src="<?php echo e(asset('storage/' . trim($mainImagePath))); ?>"
                                             alt="<?php echo e($location->title); ?>"
                                             class="main-image">
                                        <div class="main-image-overlay">
                                            <div class="overlay-content">
                                                <i class="fas fa-expand-alt"></i>
                                                <span>مشاهده در اندازه کامل</span>
                                            </div>
                                            <div class="image-counter">
                                                <i class="fas fa-images"></i>
                                                <?php echo e(count($images)); ?> تصویر
                                            </div>
                                        </div>
                                    </div>
                                    <?php endif; ?>
                                </div>

                                <!-- Thumbnail Grid -->
                                <?php if(count($images) > 1): ?>
                                <div class="gallery-thumbnails">
                                    <?php $__currentLoopData = $images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($index > 0 && $index < 5): ?> 
                                            <?php $imagePath = is_string($image) ? $image : (is_array($image) && isset($image['path']) ? $image['path'] : ''); ?>
                                            <?php if(!empty($imagePath)): ?>
                                            <div class="thumbnail-item <?php echo e($index == 4 && count($images) > 5 ? 'more-images' : ''); ?>"
                                                 onclick="openLightbox(<?php echo e($index); ?>)">
                                                <img src="<?php echo e(asset('storage/' . trim($imagePath))); ?>"
                                                     alt="<?php echo e($location->title); ?>"
                                                     class="thumbnail-image">
                                                <?php if($index == 4 && count($images) > 5): ?>
                                                <div class="more-overlay">
                                                    <span>+<?php echo e(count($images) - 4); ?></span>
                                                </div>
                                                <?php endif; ?>
                                            </div>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                                <?php endif; ?>
                            <?php else: ?>
                                <div class="no-images">
                                    <i class="fas fa-image"></i>
                                    <p>تصویری برای این مکان ثبت نشده است</p>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    <?php endif; ?>
                <?php endif; ?>

                <!-- Amenities Section -->
                <?php if($location->amenities && count($location->amenities) > 0): ?>
                <div class="content-section">
                    <div class="section-header">
                        <h2 class="section-title">
                            <i class="fas fa-star"></i>
                            امکانات و ویژگی‌ها
                        </h2>
                        <span class="amenities-count"><?php echo e(count($location->amenities)); ?> مورد</span>
                    </div>
                    <div class="amenities-grid">
                        <?php $__currentLoopData = $location->amenities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $amenity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="amenity-item">
                                <div class="amenity-icon">
                                    <?php if(isset($amenity['icon']) && $amenity['icon']): ?>
                                        <i class="<?php echo e($amenity['icon']); ?>"></i>
                                    <?php else: ?>
                                        <i class="fas fa-check-circle"></i>
                                    <?php endif; ?>
                                </div>
                                <div class="amenity-content">
                                    <span class="amenity-name"><?php echo e($amenity['name'] ?? $amenity); ?></span>
                                    <?php if(isset($amenity['description']) && $amenity['description']): ?>
                                        <span class="amenity-description"><?php echo e($amenity['description']); ?></span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
                <?php endif; ?>

                <!-- Tags Section -->
                <?php if($location->tags): ?>
                <div class="content-section">
                    <div class="section-header">
                        <h2 class="section-title">
                            <i class="fas fa-tags"></i>
                            برچسب‌ها
                        </h2>
                    </div>
                    <div class="tags-container">
                        <?php
                            $tags = is_string($location->tags) ? explode(',', $location->tags) : $location->tags;
                        ?>
                        <?php $__currentLoopData = $tags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if(trim($tag)): ?>
                                <span class="tag-item">
                                    <i class="fas fa-hashtag"></i>
                                    <?php echo e(trim($tag)); ?>

                                </span>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
                <?php endif; ?>

                <!-- Modern Rating & Comment System -->
                <div class="modern-rating-section">
                    <div class="rating-section-header">
                        <h2 class="rating-section-title">
                            <i class="fas fa-star"></i>
                            نظرات و امتیازدهی
                        </h2>

                        <?php if(isset($ratingStats) && $ratingStats): ?>
                        <div class="rating-overview">
                            <div class="rating-summary-card">
                                <div class="rating-average-display"><?php echo e(number_format($ratingStats->average_rating, 1)); ?></div>
                                <div class="rating-stars-display">
                                    <div class="star-rating">
                                        <?php for($i = 1; $i <= 5; $i++): ?>
                                            <i class="fas fa-star star <?php echo e($i <= $ratingStats->average_rating ? 'active' : ''); ?>"></i>
                                        <?php endfor; ?>
                                    </div>
                                </div>
                                <div class="rating-count-display"><?php echo e($ratingStats->total_ratings); ?> نظر</div>
                            </div>

                            <?php if($ratingStats->service_avg): ?>
                            <div class="rating-summary-card">
                                <div class="rating-average-display"><?php echo e(number_format($ratingStats->service_avg, 1)); ?></div>
                                <div class="rating-stars-display">
                                    <div class="star-rating">
                                        <?php for($i = 1; $i <= 5; $i++): ?>
                                            <i class="fas fa-star star <?php echo e($i <= $ratingStats->service_avg ? 'active' : ''); ?>"></i>
                                        <?php endfor; ?>
                                    </div>
                                </div>
                                <div class="rating-count-display">کیفیت خدمات</div>
                            </div>
                            <?php endif; ?>

                            <?php if($ratingStats->location_avg): ?>
                            <div class="rating-summary-card">
                                <div class="rating-average-display"><?php echo e(number_format($ratingStats->location_avg, 1)); ?></div>
                                <div class="rating-stars-display">
                                    <div class="star-rating">
                                        <?php for($i = 1; $i <= 5; $i++): ?>
                                            <i class="fas fa-star star <?php echo e($i <= $ratingStats->location_avg ? 'active' : ''); ?>"></i>
                                        <?php endfor; ?>
                                    </div>
                                </div>
                                <div class="rating-count-display">موقعیت مکانی</div>
                            </div>
                            <?php endif; ?>
                        </div>
                        <?php elseif(isset($ratings) && count($ratings) > 0): ?>
                        <div class="rating-overview">
                            <?php
                                $avgRating = $ratings->avg('rating');
                                $totalRatings = $ratings->count();
                            ?>
                            <div class="rating-summary-card">
                                <div class="rating-average-display"><?php echo e(number_format($avgRating, 1)); ?></div>
                                <div class="rating-stars-display">
                                    <div class="star-rating">
                                        <?php for($i = 1; $i <= 5; $i++): ?>
                                            <i class="fas fa-star star <?php echo e($i <= $avgRating ? 'active' : ''); ?>"></i>
                                        <?php endfor; ?>
                                    </div>
                                </div>
                                <div class="rating-count-display"><?php echo e($totalRatings); ?> نظر</div>
                            </div>
                        </div>
                        <?php endif; ?>
                    </div>

                    <!-- Rating Form -->
                    <div class="modern-rating-form">
                        <h3 class="rating-form-title">
                            <i class="fas fa-edit"></i>
                            نظر خود را ثبت کنید
                        </h3>

                        <form id="modern-rating-form" action="<?php echo e(route('ratings.store')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="title_id" value="<?php echo e($location->title_id); ?>">

                            <!-- User Information -->
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="rating-form-group">
                                        <label class="rating-form-label">نام شما *</label>
                                        <input type="text" name="name" class="rating-form-control" required>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="rating-form-group">
                                        <label class="rating-form-label">ایمیل *</label>
                                        <input type="email" name="email" class="rating-form-control" required>
                                    </div>
                                </div>
                            </div>

                            <!-- Overall Rating -->
                            <div class="rating-form-group">
                                <label class="rating-form-label">امتیاز کلی *</label>
                                <div class="star-rating star-rating-large" data-rating="overall">
                                    <?php for($i = 1; $i <= 5; $i++): ?>
                                        <i class="fas fa-star star" data-value="<?php echo e($i); ?>"></i>
                                    <?php endfor; ?>
                                </div>
                                <input type="hidden" name="rating" required>
                            </div>

                            <!-- Detailed Ratings -->
                            <div class="multi-rating-grid">
                                <div class="rating-category-item">
                                    <div class="rating-category-label">
                                        <i class="fas fa-concierge-bell"></i>
                                        کیفیت خدمات
                                    </div>
                                    <div class="star-rating" data-rating="service">
                                        <?php for($i = 1; $i <= 5; $i++): ?>
                                            <i class="fas fa-star star" data-value="<?php echo e($i); ?>"></i>
                                        <?php endfor; ?>
                                    </div>
                                    <input type="hidden" name="service_rating">
                                </div>

                                <div class="rating-category-item">
                                    <div class="rating-category-label">
                                        <i class="fas fa-gem"></i>
                                        کیفیت کلی
                                    </div>
                                    <div class="star-rating" data-rating="quality">
                                        <?php for($i = 1; $i <= 5; $i++): ?>
                                            <i class="fas fa-star star" data-value="<?php echo e($i); ?>"></i>
                                        <?php endfor; ?>
                                    </div>
                                    <input type="hidden" name="quality_rating">
                                </div>

                                <div class="rating-category-item">
                                    <div class="rating-category-label">
                                        <i class="fas fa-map-marker-alt"></i>
                                        موقعیت مکانی
                                    </div>
                                    <div class="star-rating" data-rating="location">
                                        <?php for($i = 1; $i <= 5; $i++): ?>
                                            <i class="fas fa-star star" data-value="<?php echo e($i); ?>"></i>
                                        <?php endfor; ?>
                                    </div>
                                    <input type="hidden" name="location_rating">
                                </div>

                                <div class="rating-category-item">
                                    <div class="rating-category-label">
                                        <i class="fas fa-dollar-sign"></i>
                                        ارزش در برابر قیمت
                                    </div>
                                    <div class="star-rating" data-rating="price">
                                        <?php for($i = 1; $i <= 5; $i++): ?>
                                            <i class="fas fa-star star" data-value="<?php echo e($i); ?>"></i>
                                        <?php endfor; ?>
                                    </div>
                                    <input type="hidden" name="price_rating">
                                </div>

                                <div class="rating-category-item">
                                    <div class="rating-category-label">
                                        <i class="fas fa-broom"></i>
                                        نظافت
                                    </div>
                                    <div class="star-rating" data-rating="cleanliness">
                                        <?php for($i = 1; $i <= 5; $i++): ?>
                                            <i class="fas fa-star star" data-value="<?php echo e($i); ?>"></i>
                                        <?php endfor; ?>
                                    </div>
                                    <input type="hidden" name="cleanliness_rating">
                                </div>
                            </div>

                            <!-- Comment -->
                            <div class="rating-form-group">
                                <label class="rating-form-label">نظر شما</label>
                                <textarea name="comment" class="rating-form-control rating-form-textarea"
                                         placeholder="تجربه خود را با ما به اشتراک بگذارید..."></textarea>
                            </div>

                            <!-- Positive/Negative Points -->
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="rating-form-group">
                                        <label class="rating-form-label">نکات مثبت</label>
                                        <textarea name="positive_comment" class="rating-form-control" rows="3"
                                                 placeholder="چه چیزهایی را دوست داشتید؟"></textarea>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="rating-form-group">
                                        <label class="rating-form-label">نکات منفی</label>
                                        <textarea name="negative_comment" class="rating-form-control" rows="3"
                                                 placeholder="چه چیزهایی قابل بهبود است؟"></textarea>
                                    </div>
                                </div>
                            </div>

                            <!-- Additional Information -->
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="rating-form-group">
                                        <label class="rating-form-label">تاریخ بازدید</label>
                                        <input type="date" name="visit_date" class="rating-form-control">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="rating-form-group">
                                        <label class="rating-form-label">هدف بازدید</label>
                                        <select name="visit_purpose" class="rating-form-control">
                                            <option value="">انتخاب کنید</option>
                                            <option value="business">کاری</option>
                                            <option value="leisure">تفریحی</option>
                                            <option value="family">خانوادگی</option>
                                            <option value="romantic">عاشقانه</option>
                                            <option value="solo">انفرادی</option>
                                            <option value="group">گروهی</option>
                                        </select>
                                    </div>
                                </div>
                            </div>

                            <!-- Recommendation -->
                            <div class="rating-form-group">
                                <label class="rating-form-label">آیا این مکان را به دیگران توصیه می‌کنید؟</label>
                                <div class="recommendation-options">
                                    <label class="recommendation-option">
                                        <input type="radio" name="recommendation" value="yes">
                                        <span>بله، قطعاً</span>
                                    </label>
                                    <label class="recommendation-option">
                                        <input type="radio" name="recommendation" value="maybe">
                                        <span>شاید</span>
                                    </label>
                                    <label class="recommendation-option">
                                        <input type="radio" name="recommendation" value="no">
                                        <span>خیر</span>
                                    </label>
                                </div>
                            </div>

                            <!-- Submit Button -->
                            <div class="rating-form-group">
                                <button type="submit" class="rating-submit-btn">
                                    <i class="fas fa-paper-plane"></i>
                                    ارسال نظر
                                </button>
                            </div>
                        </form>
                    </div>

                    <!-- Comments Display -->
                    <?php if(isset($ratings) && count($ratings) > 0): ?>
                    <div class="comments-container">
                        <h3 class="comments-title">
                            <i class="fas fa-comments"></i>
                            نظرات کاربران
                        </h3>

                        <?php $__currentLoopData = $ratings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rating): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="comment-item" data-comment-id="<?php echo e($rating->id); ?>">
                            <div class="comment-header">
                                <div class="comment-user">
                                    <div class="comment-avatar">
                                        <?php echo e(substr($rating->name ?? 'ک', 0, 1)); ?>

                                    </div>
                                    <div class="comment-user-info">
                                        <h5><?php echo e($rating->name ?? 'کاربر ناشناس'); ?></h5>
                                        <p class="comment-date" data-original-date="<?php echo e($rating->created_at ?? $rating->timestamp); ?>">
                                            <?php echo e(\Carbon\Carbon::parse($rating->created_at ?? $rating->timestamp)->diffForHumans()); ?>

                                        </p>
                                    </div>
                                </div>
                                <div class="comment-rating-display">
                                    <div class="star-rating star-rating-small">
                                        <?php for($i = 1; $i <= 5; $i++): ?>
                                            <i class="fas fa-star star <?php echo e($i <= $rating->rating ? 'active' : ''); ?>"></i>
                                        <?php endfor; ?>
                                    </div>
                                </div>
                            </div>

                            <?php if($rating->comment): ?>
                            <div class="comment-content">
                                <?php echo e($rating->comment); ?>

                            </div>
                            <?php endif; ?>

                            <?php if($rating->positive_comment || $rating->negative_comment): ?>
                            <div class="comment-points">
                                <?php if($rating->positive_comment): ?>
                                <div class="positive-points">
                                    <strong>
                                        <i class="fas fa-thumbs-up"></i> نکات مثبت:
                                    </strong>
                                    <p><?php echo $rating->positive_comment_html ?? $rating->positive_comment; ?></p>
                                </div>
                                <?php endif; ?>

                                <?php if($rating->negative_comment): ?>
                                <div class="negative-points">
                                    <strong>
                                        <i class="fas fa-thumbs-down"></i> نکات منفی:
                                    </strong>
                                    <p><?php echo $rating->negative_comment_html ?? $rating->negative_comment; ?></p>
                                </div>
                                <?php endif; ?>
                            </div>
                            <?php endif; ?>

                            <!-- Additional Rating Information -->
                            <?php if($rating->trip_type || $rating->travel_method || $rating->stay_date || $rating->visit_date): ?>
                            <div class="rating-details">
                                <div class="rating-details-grid">
                                    <?php if($rating->trip_type): ?>
                                    <div class="rating-detail-item">
                                        <span class="detail-label">نوع سفر:</span>
                                        <span class="detail-value">
                                            <?php switch($rating->trip_type):
                                                case ('business'): ?> سفر کاری <?php break; ?>
                                                <?php case ('family'): ?> سفر خانوادگی <?php break; ?>
                                                <?php case ('couple'): ?> سفر زوج <?php break; ?>
                                                <?php case ('solo'): ?> سفر تنها <?php break; ?>
                                                <?php case ('friends'): ?> سفر با دوستان <?php break; ?>
                                                <?php default: ?> <?php echo e($rating->trip_type); ?>

                                            <?php endswitch; ?>
                                        </span>
                                    </div>
                                    <?php endif; ?>

                                    <?php if($rating->travel_method): ?>
                                    <div class="rating-detail-item">
                                        <span class="detail-label">روش سفر:</span>
                                        <span class="detail-value">
                                            <?php switch($rating->travel_method):
                                                case ('car'): ?> خودرو شخصی <?php break; ?>
                                                <?php case ('bus'): ?> اتوبوس <?php break; ?>
                                                <?php case ('train'): ?> قطار <?php break; ?>
                                                <?php case ('airplane'): ?> هواپیما <?php break; ?>
                                                <?php case ('other'): ?> سایر <?php break; ?>
                                                <?php default: ?> <?php echo e($rating->travel_method); ?>

                                            <?php endswitch; ?>
                                        </span>
                                    </div>
                                    <?php endif; ?>

                                    <?php if($rating->stay_date): ?>
                                    <div class="rating-detail-item">
                                        <span class="detail-label">تاریخ اقامت:</span>
                                        <span class="detail-value">
                                            <?php
                                                // بررسی اینکه آیا تاریخ از قبل شمسی است
                                                $stayDate = $rating->stay_date;
                                                if (preg_match('/^(13|14)\d{2}/', $stayDate)) {
                                                    echo $stayDate; // اگر شمسی است، همان را نمایش بده
                                                } else {
                                                    if(app()->getLocale() == 'fa') {
                                                        echo \Morilog\Jalali\Jalalian::fromCarbon(\Carbon\Carbon::parse($stayDate))->format('Y/m/d');
                                                    } else {
                                                        echo \Carbon\Carbon::parse($stayDate)->format('Y/m/d');
                                                    }
                                                }
                                            ?>
                                        </span>
                                    </div>
                                    <?php endif; ?>

                                    <?php if($rating->visit_date): ?>
                                    <div class="rating-detail-item">
                                        <span class="detail-label">تاریخ بازدید:</span>
                                        <span class="detail-value">
                                            <?php
                                                // بررسی اینکه آیا تاریخ از قبل شمسی است
                                                $visitDate = $rating->visit_date;
                                                if (preg_match('/^(13|14)\d{2}/', $visitDate)) {
                                                    echo $visitDate; // اگر شمسی است، همان را نمایش بده
                                                } else {
                                                    if(app()->getLocale() == 'fa') {
                                                        echo \Morilog\Jalali\Jalalian::fromCarbon(\Carbon\Carbon::parse($visitDate))->format('Y/m/d');
                                                    } else {
                                                        echo \Carbon\Carbon::parse($visitDate)->format('Y/m/d');
                                                    }
                                                }
                                            ?>
                                        </span>
                                    </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <?php endif; ?>

                            <div class="comment-actions">
                                <button class="comment-action-btn comment-like-btn" data-rating-id="<?php echo e($rating->id); ?>">
                                    <i class="fas fa-thumbs-up"></i>
                                    مفید (<span class="count"><?php echo e($rating->helpful_count ?? 0); ?></span>)
                                </button>
                                <button class="comment-action-btn comment-dislike-btn" data-rating-id="<?php echo e($rating->id); ?>">
                                    <i class="fas fa-thumbs-down"></i>
                                    غیرمفید (<span class="count"><?php echo e($rating->not_helpful_count ?? 0); ?></span>)
                                </button>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Sidebar -->
            <div class="col-lg-4">
                <div class="sidebar-content">
                    <!-- Location Map -->
                    <?php if($location->lat && $location->lng): ?>
                    <div class="sidebar-section">
                        <h3 class="sidebar-title">
                            <i class="fas fa-map"></i>
                            موقعیت روی نقشه
                        </h3>
                        <div class="location-map" id="locationMap">
                            <div class="map-placeholder">
                                <i class="fas fa-map-marked-alt"></i>
                                <p>در حال بارگذاری نقشه...</p>
                            </div>
                        </div>
                        <div class="map-actions">
                            <a href="https://maps.google.com/?q=<?php echo e($location->lat); ?>,<?php echo e($location->lng); ?>"
                               target="_blank" class="btn btn-map">
                                <i class="fas fa-external-link-alt"></i>
                                مشاهده در گوگل مپ
                            </a>
                        </div>
                    </div>
                    <?php endif; ?>

                    <!-- Contact Information -->
                    <div class="sidebar-section">
                        <h3 class="sidebar-title">
                            <i class="fas fa-address-card"></i>
                            اطلاعات تماس
                        </h3>
                        <div class="contact-info">
                            <?php if($location->address): ?>
                            <div class="contact-item">
                                <div class="contact-icon">
                                    <i class="fas fa-map-marker-alt"></i>
                                </div>
                                <div class="contact-details">
                                    <span class="contact-label">آدرس</span>
                                    <span class="contact-value"><?php echo e($location->address); ?></span>
                                </div>
                            </div>
                            <?php endif; ?>

                            <?php if($location->phone): ?>
                            <div class="contact-item">
                                <div class="contact-icon">
                                    <i class="fas fa-phone"></i>
                                </div>
                                <div class="contact-details">
                                    <span class="contact-label">تلفن</span>
                                    <a href="tel:<?php echo e($location->phone); ?>" class="contact-value"><?php echo e($location->phone); ?></a>
                                </div>
                            </div>
                            <?php endif; ?>

                            <?php if($location->open_hours || $location->closing_hours): ?>
                            <div class="contact-item">
                                <div class="contact-icon">
                                    <i class="fas fa-clock"></i>
                                </div>
                                <div class="contact-details">
                                    <span class="contact-label">ساعات کاری</span>
                                    <div class="working-hours-info">
                                        <span class="contact-value"><?php echo e($location->open_hours ?? '۹ صبح'); ?> تا <?php echo e($location->closing_hours ?? '۹ شب'); ?></span>
                                        <?php
                                            $sidebarLocationStatus = \App\Helpers\TimezoneHelper::getLocationStatus($location);
                                            $sidebarIsOpen = $sidebarLocationStatus['isOpen'];
                                            $sidebarStatusText = $sidebarLocationStatus['statusText'];
                                            $sidebarStatusClass = $sidebarLocationStatus['statusClass'];
                                        ?>
                                        <span class="status-badge <?php echo e($sidebarStatusClass); ?>">
                                            <i class="fas fa-circle"></i>
                                            <?php echo e($sidebarStatusText); ?>

                                        </span>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>

                            <?php if($location->url): ?>
                            <div class="contact-item">
                                <div class="contact-icon">
                                    <i class="fas fa-globe"></i>
                                </div>
                                <div class="contact-details">
                                    <span class="contact-label">وب‌سایت</span>
                                    <a href="<?php echo e($location->url); ?>" target="_blank" class="contact-value">
                                        مشاهده سایت
                                        <i class="fas fa-external-link-alt ms-1"></i>
                                    </a>
                                </div>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>

                    <!-- Share Section -->
                    <div class="sidebar-section">
                        <h3 class="sidebar-title">
                            <i class="fas fa-share-alt"></i>
                            اشتراک‌گذاری
                        </h3>
                        <div class="share-buttons">
                            <button class="share-btn telegram" onclick="shareToTelegram()">
                                <i class="fab fa-telegram"></i>
                                تلگرام
                            </button>
                            <button class="share-btn whatsapp" onclick="shareToWhatsApp()">
                                <i class="fab fa-whatsapp"></i>
                                واتساپ
                            </button>
                            <button class="share-btn twitter" onclick="shareToTwitter()">
                                <i class="fab fa-twitter"></i>
                                توییتر
                            </button>
                            <button class="share-btn copy" onclick="copyLink()">
                                <i class="fas fa-copy"></i>
                                کپی لینک
                            </button>
                        </div>
                    </div>

                    <!-- Related Locations -->
                    <?php if(isset($relatedLocations) && count($relatedLocations) > 0): ?>
                    <div class="sidebar-section">
                        <h3 class="sidebar-title">
                            <i class="fas fa-map-marked"></i>
                            مکان‌های مشابه
                        </h3>
                        <div class="related-locations">
                            <?php $__currentLoopData = $relatedLocations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $related): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="related-item">
                                <div class="related-image">
                                    <?php if($related->images): ?>
                                        <?php
                                            $relatedImages = is_array($related->images) ? $related->images : (json_decode($related->images, true) ?? []);
                                            $relatedImage = $relatedImages[0] ?? null;
                                        ?>
                                        <?php if($relatedImage): ?>
                                            <img src="<?php echo e(asset('storage/' . (is_string($relatedImage) ? $relatedImage : ($relatedImage['path'] ?? '')))); ?>"
                                                 alt="<?php echo e($related->title); ?>">
                                        <?php else: ?>
                                            <div class="no-image">
                                                <i class="fas fa-image"></i>
                                            </div>
                                        <?php endif; ?>
                                    <?php else: ?>
                                        <div class="no-image">
                                            <i class="fas fa-image"></i>
                                        </div>
                                    <?php endif; ?>
                                </div>
                                <div class="related-content">
                                    <h4 class="related-title"><?php echo e($related->title); ?></h4>
                                    <p class="related-category"><?php echo e($related->category_fa); ?></p>
                                    <a href="<?php echo e(route('locations.showWithCategories', ['categoryPath' => $related->category_path ?? 'location', 'titleId' => $related->title_id])); ?>"
                                       class="related-link">مشاهده</a>
                                </div>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
<?php else: ?>
    <!-- Error Message -->
    <div class="container">
        <div class="error-container">
            <div class="error-content">
                <div class="error-icon">
                    <i class="fas fa-map-marked-alt"></i>
                </div>
                <h2 class="error-title">مکان یافت نشد</h2>
                <p class="error-message">متأسفانه اطلاعات این مکان در دسترس نیست یا ممکن است حذف شده باشد.</p>
                <div class="error-actions">
                    <a href="<?php echo e(url('/')); ?>" class="btn btn-primary">
                        <i class="fas fa-home"></i>
                        بازگشت به صفحه اصلی
                    </a>
                    <a href="<?php echo e(url('/categories')); ?>" class="btn btn-outline-primary">
                        <i class="fas fa-list"></i>
                        مشاهده دسته‌بندی‌ها
                    </a>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>

<!-- Lightbox Modal -->
<div id="lightboxModal" class="lightbox-modal">
    <div class="lightbox-content">
        <span class="lightbox-close" onclick="closeLightbox()">&times;</span>
        <img id="lightboxImage" src="" alt="">
        <div class="lightbox-nav">
            <button class="lightbox-prev" onclick="prevImage()">
                <i class="fas fa-chevron-left"></i>
            </button>
            <button class="lightbox-next" onclick="nextImage()">
                <i class="fas fa-chevron-right"></i>
            </button>
        </div>
        <div class="lightbox-counter">
            <span id="lightboxCounter"></span>
        </div>
    </div>
</div>

<!-- Location Data for JavaScript -->
<script type="application/json" id="location-data">
{
    "title": <?php echo json_encode($location->title ?? '', 15, 512) ?>,
    "lat": <?php echo e($location->lat ?? 0); ?>,
    "lng": <?php echo e($location->lng ?? 0); ?>,
    "address": <?php echo json_encode($location->address ?? '', 15, 512) ?>,
    "phone": <?php echo json_encode($location->phone ?? '', 15, 512) ?>,
    "url": <?php echo json_encode($location->url ?? '', 15, 512) ?>,
    "images": <?php echo json_encode($location->images ? (is_array($location->images) ? $location->images : (is_string($location->images) ? json_decode($location->images, true) : [])) : [], 512) ?>
}
</script>

<!-- JavaScript for Location Template -->
<script src="https://cdn.jsdelivr.net/npm/leaflet@1.9.3/dist/leaflet.js"></script>
<script src="<?php echo e(asset('js/location-template.js')); ?>"></script>
<script src="<?php echo e(asset('js/modern-rating-system.js')); ?>"></script>
<script src="<?php echo e(asset('js/persian-date-picker.js')); ?>"></script>

<script>
// Set title ID for rating system
window.titleId = '<?php echo e($location->title_id ?? ''); ?>';
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/aluirani/public_html/aludubai.ir/resources/views/templates/locations/base.blade.php ENDPATH**/ ?>