<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="row">
        <div class="col-12">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="/categories">دسته‌بندی‌ها</a></li>
                    <li class="breadcrumb-item active" aria-current="page"><?php echo e($category->getTranslatedName(app()->getLocale())); ?></li>
                </ol>
            </nav>

            <div class="d-flex align-items-center mb-4">
                <?php if($category->emoji): ?>
                    <span class="fs-2 me-3"><?php echo e($category->emoji); ?></span>
                <?php elseif($category->font_icon): ?>
                    <i class="fas fa-<?php echo e($category->font_icon); ?> fs-2 me-3"></i>
                <?php endif; ?>
                <h1 class="mb-0"><?php echo e($category->getTranslatedName(app()->getLocale())); ?></h1>
            </div>

            <?php if($category->getTranslatedDescription(app()->getLocale())): ?>
                <p class="lead text-muted mb-4"><?php echo e($category->getTranslatedDescription(app()->getLocale())); ?></p>
            <?php endif; ?>

            
            <?php if (isset($component)) { $__componentOriginal10b01a4c29f95db9b0aaed806a153fe8 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal10b01a4c29f95db9b0aaed806a153fe8 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.geographic-filter','data' => ['countries' => $countries]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('geographic-filter'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['countries' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($countries)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal10b01a4c29f95db9b0aaed806a153fe8)): ?>
<?php $attributes = $__attributesOriginal10b01a4c29f95db9b0aaed806a153fe8; ?>
<?php unset($__attributesOriginal10b01a4c29f95db9b0aaed806a153fe8); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal10b01a4c29f95db9b0aaed806a153fe8)): ?>
<?php $component = $__componentOriginal10b01a4c29f95db9b0aaed806a153fe8; ?>
<?php unset($__componentOriginal10b01a4c29f95db9b0aaed806a153fe8); ?>
<?php endif; ?>

            <?php if($childCategories->count() > 0): ?>
                <div class="row mb-4">
                    <?php $__currentLoopData = $childCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-md-4 mb-3">
                            <div class="card h-100">
                                <div class="card-body">
                                    <h5 class="card-title">
                                        <?php if($child->emoji): ?>
                                            <span class="me-2"><?php echo e($child->emoji); ?></span>
                                        <?php elseif($child->font_icon): ?>
                                            <i class="fas fa-<?php echo e($child->font_icon); ?> me-2"></i>
                                        <?php endif; ?>
                                        <?php echo e($child->getTranslatedName(app()->getLocale())); ?>

                                    </h5>
                                    <?php if($child->getTranslatedDescription(app()->getLocale())): ?>
                                        <p class="card-text text-muted"><?php echo e($child->getTranslatedDescription(app()->getLocale())); ?></p>
                                    <?php endif; ?>
                                    <a href="<?php echo e(route('categories.show', $child->category_key)); ?>" class="btn btn-primary">
                                        مشاهده مکان‌ها
                                    </a>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php endif; ?>

            <div class="row">
                <div class="col-12">
                    <h3 class="mb-3">مکان‌ها</h3>
                    <?php if($locations->count() > 0): ?>
                        <div class="row">
                            <?php $__currentLoopData = $locations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $location): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-md-4 mb-4">
                                    <div class="card h-100">
                                        <?php if($location->image): ?>
                                            <img src="<?php echo e(asset('storage/' . $location->image)); ?>" 
                                                 class="card-img-top" 
                                                 alt="<?php echo e($location->title); ?>">
                                        <?php endif; ?>
                                        <div class="card-body">
                                            <h5 class="card-title"><?php echo e($location->title); ?></h5>
                                            <p class="card-text mb-1"><strong>دسته‌بندی:</strong> <?php echo e($location->category_fa); ?></p>
                                            <?php if($location->address): ?>
                                                <p class="card-text mb-1"><strong>آدرس:</strong> <?php echo e($location->address); ?></p>
                                            <?php endif; ?>
                                            <?php if($location->phone): ?>
                                                <p class="card-text mb-1"><strong>تلفن:</strong> <?php echo e($location->phone); ?></p>
                                            <?php endif; ?>
                                            <?php if($location->open_hours): ?>
                                                <p class="card-text mb-1"><strong>ساعات کاری:</strong> <?php echo e($location->open_hours); ?></p>
                                            <?php endif; ?>
                                            <?php if($location->description): ?>
                                                <p class="card-text text-muted"><?php echo e(Str::limit($location->description, 80)); ?></p>
                                            <?php endif; ?>
                                            <?php
                                                $categoryPath = '';
                                                if ($category->category_key === 'mall') {
                                                    $categoryPath = 'shopping_centers/mall';
                                                } elseif ($category->category_key === 'shopping_centers') {
                                                    $categoryPath = 'shopping_centers';
                                                } else {
                                                    $categoryPath = $category->category_key;
                                                }
                                            ?>
                                            <a href="/<?php echo e($categoryPath); ?>/<?php echo e($location->title_id); ?>" 
                                               class="btn btn-primary mt-2">مشاهده جزئیات</a>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        <div class="d-flex justify-content-center mt-4">
                            <?php if($locations->lastPage() > 1): ?>
                                <nav aria-label="pagination">
                                    <ul class="pagination">
                                        <?php if($locations->onFirstPage()): ?>
                                            <li class="page-item disabled"><span class="page-link">قبلی</span></li>
                                        <?php else: ?>
                                            <li class="page-item"><a class="page-link" href="<?php echo e($locations->previousPageUrl()); ?>">قبلی</a></li>
                                        <?php endif; ?>
                                        <?php for($i = 1; $i <= $locations->lastPage(); $i++): ?>
                                            <li class="page-item <?php echo e($i == $locations->currentPage() ? 'active' : ''); ?>">
                                                <a class="page-link" href="<?php echo e($locations->url($i)); ?>"><?php echo e($i); ?></a>
                                            </li>
                                        <?php endfor; ?>
                                        <?php if($locations->hasMorePages()): ?>
                                            <li class="page-item"><a class="page-link" href="<?php echo e($locations->nextPageUrl()); ?>">بعدی</a></li>
                                        <?php else: ?>
                                            <li class="page-item disabled"><span class="page-link">بعدی</span></li>
                                        <?php endif; ?>
                                    </ul>
                                </nav>
                            <?php endif; ?>
                        </div>
                    <?php else: ?>
                        <div class="alert alert-info">
                            هیچ مکانی در این دسته‌بندی یافت نشد.
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
// تابع به‌روزرسانی نتایج بر اساس فیلترهای جغرافیایی
function updateResults() {
    // ساخت پارامترهای URL بر اساس فیلترهای فعال
    const params = new URLSearchParams();
    
    if (activeGeoFilters.country) params.append('country', activeGeoFilters.country);
    if (activeGeoFilters.province) params.append('province', activeGeoFilters.province);
    if (activeGeoFilters.county) params.append('county', activeGeoFilters.county);
    if (activeGeoFilters.district) params.append('district', activeGeoFilters.district);
    if (activeGeoFilters.city) params.append('city', activeGeoFilters.city);
    if (activeGeoFilters.village) params.append('village', activeGeoFilters.village);
    if (activeGeoFilters.zone) params.append('zone', activeGeoFilters.zone);
    
    // به‌روزرسانی URL بدون بارگذاری مجدد صفحه
    const newUrl = window.location.pathname + (params.toString() ? '?' + params.toString() : '');
    window.history.pushState({}, '', newUrl);
    
    // در اینجا می‌توانید درخواست AJAX برای فیلتر کردن مکان‌ها ارسال کنید
    // یا صفحه را مجدداً بارگذاری کنید
    // window.location.reload();
}
</script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .card {
        transition: transform 0.2s;
        border: none;
        box-shadow: 0 2px 4px rgba(0,0,0,0.1);
    }
    
    .card:hover {
        transform: translateY(-5px);
    }

    .card-img-top {
        height: 200px;
        object-fit: cover;
    }

    .card-title {
        color: #333;
    }

    .breadcrumb {
        background-color: transparent;
        padding: 0;
        margin-bottom: 1rem;
    }

    .breadcrumb-item + .breadcrumb-item::before {
        content: ">";
    }
</style>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/aluirani/public_html/aludubai.ir/resources/views/categories/show.blade.php ENDPATH**/ ?>