

<?php $__env->startSection('title', 'آمار و گزارشات'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-lg-3 col-6">
            <div class="small-box bg-info">
                <div class="inner">
                    <h3><?php echo e($totalUsers); ?></h3>
                    <p>کاربران</p>
                </div>
                <div class="icon">
                    <i class="fa fa-users"></i>
                </div>
                <a href="<?php echo e(route('admin.statistics.users')); ?>" class="small-box-footer">
                    مشاهده جزئیات <i class="fa fa-arrow-left"></i>
                </a>
            </div>
        </div>
        <div class="col-lg-3 col-6">
            <div class="small-box bg-success">
                <div class="inner">
                    <h3><?php echo e($totalLocations); ?></h3>
                    <p>مکان‌ها</p>
                </div>
                <div class="icon">
                    <i class="fa fa-map-marker"></i>
                </div>
                <a href="<?php echo e(route('admin.statistics.locations')); ?>" class="small-box-footer">
                    مشاهده جزئیات <i class="fa fa-arrow-left"></i>
                </a>
            </div>
        </div>
        <div class="col-lg-3 col-6">
            <div class="small-box bg-warning">
                <div class="inner">
                    <h3><?php echo e($totalVisits); ?></h3>
                    <p>بازدیدها</p>
                </div>
                <div class="icon">
                    <i class="fa fa-eye"></i>
                </div>
                <a href="<?php echo e(route('admin.statistics.visits')); ?>" class="small-box-footer">
                    مشاهده جزئیات <i class="fa fa-arrow-left"></i>
                </a>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">آخرین بازدیدها</h3>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>کاربر</th>
                                    <th>مکان</th>
                                    <th>تاریخ</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $recentVisits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $visit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($visit->user->name); ?></td>
                                    <td><?php echo e($visit->location->name); ?></td>
                                    <td><?php echo \App\Helpers\DateHelper::formatDateTimeByLocale($visit->created_at); ?></td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="3" class="text-center">هیچ بازدیدی ثبت نشده است.</td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    // نمودارها و گراف‌های آماری می‌توانند اینجا اضافه شوند
</script>
<?php $__env->stopPush(); ?> 
<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/aluirani/public_html/aludubai.ir/resources/views/admin/statistics/index.blade.php ENDPATH**/ ?>