

<?php $__env->startSection('title', 'Country Details'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="card">
        <div class="card-header">
            <div class="d-flex justify-content-between align-items-center">
                <h4>Country Details</h4>
                <div>
                    <a href="<?php echo e(route('admin.geography.countries.edit', $item->id)); ?>" class="btn btn-primary">
                        <i class="fas fa-edit"></i> Edit
                    </a>
                    <a href="<?php echo e(route('admin.geography.countries.index')); ?>" class="btn btn-secondary">
                        <i class="fas fa-list"></i> Back to List
                    </a>
                </div>
            </div>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <table class="table table-bordered">
                        <tr>
                            <th style="width: 30%">Country ID</th>
                            <td><?php echo e($item->id); ?></td>
                        </tr>
                        <tr>
                            <th>Name (Native)</th>
                            <td><?php echo e($item->name); ?></td>
                        </tr>
                        <tr>
                            <th>Name (English)</th>
                            <td><?php echo e($item->name_en); ?></td>
                        </tr>
                        <tr>
                            <th>ISO Code (2)</th>
                            <td><code><?php echo e($item->iso_code); ?></code></td>
                        </tr>
                        <tr>
                            <th>ISO Code (3)</th>
                            <td><code><?php echo e($item->iso_code3); ?></code></td>
                        </tr>
                        <tr>
                            <th>Numeric Code</th>
                            <td><?php echo e($item->num_code ?? 'N/A'); ?></td>
                        </tr>
                        <tr>
                            <th>Phone Code</th>
                            <td><?php echo e($item->phone_code ? '+'.$item->phone_code : 'N/A'); ?></td>
                        </tr>
                        <tr>
                            <th>Currency Code</th>
                            <td><?php echo e($item->currency_code ?? 'N/A'); ?></td>
                        </tr>
                    </table>
                </div>
                <div class="col-md-6">
                    <table class="table table-bordered">
                        <tr>
                            <th style="width: 30%">Capital</th>
                            <td><?php echo e($item->capital ?? 'N/A'); ?></td>
                        </tr>
                        <tr>
                            <th>Region</th>
                            <td><?php echo e($item->region ?? 'N/A'); ?></td>
                        </tr>
                        <tr>
                            <th>Subregion</th>
                            <td><?php echo e($item->subregion ?? 'N/A'); ?></td>
                        </tr>
                        <tr>
                            <th>Continent</th>
                            <td><?php echo e($item->continent ?? 'N/A'); ?></td>
                        </tr>
                        <tr>
                            <th>Top Level Domain</th>
                            <td><?php echo e($item->tld ?? 'N/A'); ?></td>
                        </tr>
                        <tr>
                            <th>Native Name</th>
                            <td><?php echo e($item->native_name ?? 'N/A'); ?></td>
                        </tr>
                        <tr>
                            <th>Status</th>
                            <td>
                                <span class="badge <?php echo e($item->is_active ? 'bg-success' : 'bg-danger'); ?>">
                                    <?php echo e($item->is_active ? 'Active' : 'Inactive'); ?>

                                </span>
                            </td>
                        </tr>
                        <tr>
                            <th>Created At</th>
                            <td><?php echo e($item->created_at ? $item->created_at->format('Y-m-d H:i:s') : 'N/A'); ?></td>
                        </tr>
                    </table>
                </div>
            </div>

            <?php if(isset($item->area) || isset($item->population)): ?>
            <div class="row mt-4">
                <div class="col-md-12">
                    <h5>Additional Information</h5>
                    <table class="table table-bordered">
                        <?php if(isset($item->area)): ?>
                        <tr>
                            <th style="width: 15%">Area</th>
                            <td><?php echo e(number_format($item->area, 2)); ?> km²</td>
                        </tr>
                        <?php endif; ?>
                        <?php if(isset($item->population)): ?>
                        <tr>
                            <th>Population</th>
                            <td><?php echo e(number_format($item->population)); ?></td>
                        </tr>
                        <?php endif; ?>
                        <?php if(isset($item->timezone)): ?>
                        <tr>
                            <th>Timezone</th>
                            <td><?php echo e($item->timezone); ?></td>
                        </tr>
                        <?php endif; ?>
                    </table>
                </div>
            </div>
            <?php endif; ?>

            
            <?php if(isset($item->boundaries)): ?>
            <div class="row mt-4">
                <div class="col-md-12">
                    <h5>Geographic Boundaries</h5>
                    <div id="countryMap" style="height: 400px; width: 100%;"></div>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </div>

    <div class="card mt-4">
        <div class="card-header">
            <h5>Provinces</h5>
        </div>
        <div class="card-body">
            <?php if(isset($provinces) && $provinces->count() > 0): ?>
                <div class="table-responsive">
                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Name</th>
                                <th>English Name</th>
                                <th>Center</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $provinces; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $province): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($province->id); ?></td>
                                <td><?php echo e($province->name); ?></td>
                                <td><?php echo e($province->name_en); ?></td>
                                <td><?php echo e($province->center_city_name); ?></td>
                                <td>
                                    <span class="badge <?php echo e($province->is_active ? 'bg-success' : 'bg-danger'); ?>">
                                        <?php echo e($province->is_active ? 'Active' : 'Inactive'); ?>

                                    </span>
                                </td>
                                <td>
                                    <a href="<?php echo e(route('admin.geography.provinces.show', $province->id)); ?>" class="btn btn-sm btn-info">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            <?php else: ?>
                <p class="text-muted">No provinces found for this country.</p>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<?php if(isset($item->boundaries)): ?>
<script>
    // Add map display logic here if needed
    $(document).ready(function() {
        // Map initialization would go here if implementing mapping functionality
    });
</script>
<?php endif; ?>
<?php $__env->stopSection(); ?> 
<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/aluirani/public_html/aludubai.ir/resources/views/admin/geography/countries/show.blade.php ENDPATH**/ ?>