

<?php $__env->startSection('title', 'جزئیات مکان'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800"><?php echo e($location->title); ?></h1>
        <div>
            <a href="<?php echo e(route('admin.locations.edit', $location->id)); ?>" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm mr-2">
                <i class="fas fa-edit fa-sm text-white-50 ml-1"></i> ویرایش
            </a>
            <a href="<?php echo e(route('admin.locations.index')); ?>" class="d-none d-sm-inline-block btn btn-sm btn-secondary shadow-sm">
                <i class="fas fa-arrow-right fa-sm text-white-50 ml-1"></i> بازگشت به لیست
            </a>
        </div>
    </div>

    <!-- Content Row -->
    <div class="row">
        <!-- اطلاعات اصلی -->
        <div class="col-xl-8 col-lg-7">
            <div class="card shadow mb-4">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-primary">اطلاعات اصلی</h6>
                    <div class="dropdown no-arrow">
                        <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            <i class="fas fa-ellipsis-v fa-sm fa-fw text-gray-400"></i>
                        </a>
                        <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in" aria-labelledby="dropdownMenuLink">
                            <div class="dropdown-header">عملیات:</div>
                            <a class="dropdown-item" href="<?php echo e(route('admin.locations.edit', $location->id)); ?>">ویرایش</a>
                            <div class="dropdown-divider"></div>
                            <form action="<?php echo e(route('admin.locations.destroy', $location->id)); ?>" method="POST" class="d-inline">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="dropdown-item text-danger" onclick="return confirm('آیا از حذف این مکان اطمینان دارید؟')">حذف</button>
                            </form>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <tbody>
                                <tr>
                                    <th style="width: 200px;">عنوان</th>
                                    <td><?php echo e($location->title); ?></td>
                                </tr>
                                <tr>
                                    <th>شناسه یکتا</th>
                                    <td><?php echo e($location->title_id); ?></td>
                                </tr>
                                <tr>
                                    <th>دسته‌بندی</th>
                                    <td>
                                        <?php if($location->category_id && is_object($location->categoryRelation)): ?>
                                            <?php echo e($location->categoryRelation->category_fa); ?>

                                        <?php elseif($location->category_fa): ?>
                                            <?php echo e($location->category_fa); ?>

                                        <?php else: ?>
                                            <?php echo e(is_string($location->category) ? $location->category : '-'); ?>

                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <tr>
                                    <th>شعار</th>
                                    <td><?php echo e($location->slogan); ?></td>
                                </tr>
                                <tr>
                                    <th>توضیحات</th>
                                    <td><?php echo e($location->description); ?></td>
                                </tr>
                                <tr>
                                    <th>وضعیت</th>
                                    <td>
                                        <?php if($location->is_active): ?>
                                            <span class="badge bg-success text-white">فعال</span>
                                        <?php else: ?>
                                            <span class="badge bg-danger text-white">غیرفعال</span>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <tr>
                                    <th>تاریخ ایجاد</th>
                                    <td><?php echo e(\Morilog\Jalali\Jalalian::fromDateTime($location->created_at)->format('Y/m/d H:i')); ?></td>
                                </tr>
                                <tr>
                                    <th>تاریخ بروزرسانی</th>
                                    <td><?php echo e(\Morilog\Jalali\Jalalian::fromDateTime($location->updated_at)->format('Y/m/d H:i')); ?></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <!-- امکانات -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">امکانات</h6>
                </div>
                <div class="card-body">
                    <?php if($location->amenities): ?>
                        <?php
                            $amenities = $location->amenities_array;
                        ?>
                        <div class="row">
                            <?php $__currentLoopData = $amenities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $amenityId => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-md-4 mb-2">
                                    <div class="d-flex align-items-center">
                                        <i class="fas fa-check-circle text-success mr-2"></i>
                                        <span><?php echo e($amenityId); ?></span>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    <?php else: ?>
                        <p class="text-muted">هیچ امکاناتی ثبت نشده است.</p>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- اطلاعات جانبی -->
        <div class="col-xl-4 col-lg-5">
            <!-- تصاویر -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">تصاویر</h6>
                </div>
                <div class="card-body">
                    <?php if($location->images): ?>
                        <?php
                            $images = $location->images_array;
                        ?>

                        <?php if(!empty($images)): ?>
                            <div class="row">
                                <?php $__currentLoopData = $images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="col-md-4 mb-3">
                                        <div class="card">
                                            <img src="<?php echo e(asset('storage/' . $image)); ?>" alt="<?php echo e($location->title); ?>" class="card-img-top" style="height: 200px; object-fit: cover;">
                                            <div class="card-body p-2">
                                                <small class="text-muted">تصویر <?php echo e($index + 1); ?></small>
                                                <?php if($index === 0): ?>
                                                    <span class="badge badge-primary ml-2">تصویر اصلی</span>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        <?php else: ?>
                            <div class="alert alert-secondary">تصویری وجود ندارد</div>
                        <?php endif; ?>
                    <?php else: ?>
                        <div class="alert alert-secondary">تصویری وجود ندارد</div>
                    <?php endif; ?>
                </div>
            </div>

            <!-- اطلاعات تماس -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">اطلاعات تماس</h6>
                </div>
                <div class="card-body">
                    <ul class="list-group list-group-flush">
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            <span><i class="fas fa-phone ml-2"></i> شماره تماس:</span>
                            <span class="text-primary"><?php echo e($location->phone ?? '-'); ?></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            <span><i class="fas fa-globe ml-2"></i> وب‌سایت:</span>
                            <span class="text-primary"><?php echo e($location->url ?? '-'); ?></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            <span><i class="fas fa-clock ml-2"></i> ساعت کاری:</span>
                            <span class="text-primary">
                                <?php echo e($location->open_hours ?? '-'); ?> تا <?php echo e($location->closing_hours ?? '-'); ?>

                            </span>
                        </li>
                    </ul>
                </div>
            </div>

            <!-- موقعیت جغرافیایی -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">موقعیت جغرافیایی</h6>
                </div>
                <div class="card-body">
                    <ul class="list-group list-group-flush">
                        <li class="list-group-item">
                            <strong><i class="fas fa-map-marker-alt ml-2"></i> آدرس:</strong>
                            <p class="mt-2"><?php echo e($location->address ?? '-'); ?></p>
                        </li>
                        <?php if($location->lat && $location->lng): ?>
                        <li class="list-group-item">
                            <div class="d-flex justify-content-between mb-2">
                                <span>عرض جغرافیایی:</span>
                                <span class="text-primary"><?php echo e($location->lat); ?></span>
                            </div>
                            <div class="d-flex justify-content-between">
                                <span>طول جغرافیایی:</span>
                                <span class="text-primary"><?php echo e($location->lng); ?></span>
                            </div>
                        </li>
                        <li class="list-group-item">
                            <a href="https://www.google.com/maps?q=<?php echo e($location->lat); ?>,<?php echo e($location->lng); ?>" target="_blank" class="btn btn-sm btn-primary w-100">
                                <i class="fas fa-map ml-1"></i> نمایش در نقشه
                            </a>
                        </li>
                        <?php endif; ?>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/aluirani/public_html/aludubai.ir/resources/views/admin/locations/show.blade.php ENDPATH**/ ?>