    function fetchProvincesByCountry(countryId) {
        fetch(`/api/countries/${countryId}/provinces`)
            .then(response => response.json())
            .then(data => {
                const select = document.getElementById('province-select');
                select.innerHTML = `<option value="">{{ __('welcome.filters.select') }}</option>`;
                
                if (data.success && data.data) {
                    data.data.forEach(province => {
                        const option = document.createElement('option');
                        option.value = province.id;
                        option.textContent = `${province.name} (${province.location_count})`;
                        select.appendChild(option);
                    });
                }
            })
            .catch(error => console.error('Error fetching provinces:', error));
    }

    function fetchCountiesByProvince(provinceId) {
        fetch(`/api/provinces/${provinceId}/counties`)
            .then(response => response.json())
            .then(data => {
                const select = document.getElementById('county-select');
                select.innerHTML = `<option value="">{{ __('welcome.filters.select') }}</option>`;
                
                if (data.success && data.data) {
                    data.data.forEach(county => {
                        const option = document.createElement('option');
                        option.value = county.id;
                        option.textContent = `${county.name} (${county.location_count})`;
                        select.appendChild(option);
                    });
                }
            })
            .catch(error => console.error('Error fetching counties:', error));
    }

    function fetchDistrictsByCounty(countyId) {
        fetch(`/api/counties/${countyId}/districts`)
            .then(response => response.json())
            .then(data => {
                const select = document.getElementById('district-select');
                select.innerHTML = `<option value="">{{ __('welcome.filters.select') }}</option>`;
                
                if (data.success && data.data) {
                    data.data.forEach(district => {
                        const option = document.createElement('option');
                        option.value = district.id;
                        option.textContent = `${district.name} (${district.location_count})`;
                        select.appendChild(option);
                    });
                }
            })
            .catch(error => console.error('Error fetching districts:', error));
    }

    function fetchCitiesByDistrict(districtId) {
        fetch(`/api/districts/${districtId}/cities`)
            .then(response => response.json())
            .then(data => {
                const select = document.getElementById('city-select');
                select.innerHTML = `<option value="">{{ __('welcome.filters.select') }}</option>`;
                
                if (data.success && data.data) {
                    data.data.forEach(city => {
                        const option = document.createElement('option');
                        option.value = city.id;
                        option.textContent = `${city.name} (${city.location_count})`;
                        select.appendChild(option);
                    });
                }
            })
            .catch(error => console.error('Error fetching cities:', error));
    }

    function fetchVillagesByDistrict(districtId) {
        fetch(`/api/districts/${districtId}/villages`)
            .then(response => response.json())
            .then(data => {
                const select = document.getElementById('village-select');
                select.innerHTML = `<option value="">{{ __('welcome.filters.select') }}</option>`;
                
                if (data.success && data.data) {
                    data.data.forEach(village => {
                        const option = document.createElement('option');
                        option.value = village.id;
                        option.textContent = `${village.name} (${village.location_count})`;
                        select.appendChild(option);
                    });
                }
            })
            .catch(error => console.error('Error fetching villages:', error));
    }

    function fetchZonesByCountry(countryId) {
        fetch(`/api/countries/${countryId}/zones`)
            .then(response => response.json())
            .then(data => {
                const select = document.getElementById('zone-select');
                select.innerHTML = `<option value="">{{ __('welcome.filters.select') }}</option>`;
                
                if (data.success && data.data) {
                    data.data.forEach(zone => {
                        const option = document.createElement('option');
                        option.value = zone.id;
                        option.textContent = `${zone.name} (${zone.location_count})`;
                        select.appendChild(option);
                    });
                }
            })
            .catch(error => console.error('Error fetching zones:', error));
    } 