@extends('layouts.user')

@section('title', 'ویرایش مکان')

@section('styles')
<link rel="stylesheet" href="https://unpkg.com/leaflet@1.7.1/dist/leaflet.css" />
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" />
<style>
    #mapid {
        height: 300px;
        border-radius: 10px;
        margin-bottom: 15px;
    }
    .form-section {
        border-bottom: 1px solid #eee;
        margin-bottom: 20px;
        padding-bottom: 20px;
    }
    .form-section:last-child {
        border-bottom: none;
    }
    .form-section-title {
        font-weight: 600;
        margin-bottom: 20px;
        color: #344767;
    }
    .select2-container--default .select2-selection--multiple {
        border-color: #d2d6da;
        border-radius: 0.5rem;
        padding: 0.5rem;
    }
    .image-preview {
        margin-top: 10px;
        display: flex;
        flex-wrap: wrap;
        gap: 10px;
    }
    .preview-item {
        position: relative;
        width: 150px;
        height: 150px;
        border-radius: 10px;
        overflow: hidden;
    }
    .preview-item img {
        width: 100%;
        height: 100%;
        object-fit: cover;
    }
    .remove-image {
        position: absolute;
        top: 5px;
        right: 5px;
        background: rgba(255,0,0,0.7);
        color: white;
        border: none;
        border-radius: 50%;
        width: 25px;
        height: 25px;
        font-size: 12px;
        cursor: pointer;
        display: flex;
        align-items: center;
        justify-content: center;
    }
    .upload-info {
        font-size: 12px;
        color: #7b809a;
        margin-top: 5px;
    }
    .coordinates-display {
        margin-top: 10px;
        font-size: 0.875rem;
    }
    .existing-images {
        margin-bottom: 15px;
    }
</style>
@endsection

@section('content')
<div class="container-fluid py-4">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header p-0 position-relative mt-n4 mx-3 z-index-2">
                    <div class="bg-gradient-primary shadow-primary border-radius-lg pt-4 pb-3">
                        <div class="d-flex justify-content-between align-items-center px-3">
                            <h6 class="text-white text-capitalize pe-3">ویرایش مکان: {{ $location->title }}</h6>
                            <a href="{{ route('user.locations.index') }}" class="btn btn-sm btn-light">
                                <i class="material-icons text-sm">arrow_back</i>
                                بازگشت به لیست
                            </a>
                        </div>
                    </div>
                </div>
                
                <div class="card-body px-4 pb-4">
                    @if($errors->any())
                        <div class="alert alert-danger text-white">
                            <ul class="mb-0">
                                @foreach($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    
                    <form action="{{ route('user.locations.update', $location->id) }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        @method('PUT')
                        
                        <!-- Basic Information Section -->
                        <div class="form-section">
                            <h5 class="form-section-title">اطلاعات اصلی</h5>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="input-group input-group-static mb-4">
                                        <label for="title">عنوان مکان <span class="text-danger">*</span></label>
                                        <input type="text" name="title" id="title" class="form-control" value="{{ old('title', $location->title) }}" required>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="input-group input-group-static mb-4">
                                        <label for="category_id">دسته‌بندی <span class="text-danger">*</span></label>
                                        <select name="category_id" id="category_id" class="form-control" required>
                                            <option value="">انتخاب کنید</option>
                                            @foreach($categories as $category)
                                                <option value="{{ $category->id }}" {{ old('category_id', $location->category_id) == $category->id ? 'selected' : '' }}>
                                                    {{ $category->category_fa }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="input-group input-group-static mb-4">
                                        <label for="description">توضیحات مکان <span class="text-danger">*</span></label>
                                        <textarea name="description" id="description" class="form-control" rows="4" required>{{ old('description', $location->description) }}</textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Location Information Section -->
                        <div class="form-section">
                            <h5 class="form-section-title">اطلاعات مکانی</h5>
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="input-group input-group-static mb-4">
                                        <label for="province_id">استان <span class="text-danger">*</span></label>
                                        <select name="province_id" id="province_id" class="form-control" required>
                                            <option value="">انتخاب کنید</option>
                                            @foreach($provinces as $province)
                                                <option value="{{ $province->id }}" {{ old('province_id', $location->province_id) == $province->id ? 'selected' : '' }}>
                                                    {{ $province->name_fa }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="input-group input-group-static mb-4">
                                        <label for="county_id">شهرستان <span class="text-danger">*</span></label>
                                        <select name="county_id" id="county_id" class="form-control" required>
                                            <option value="">انتخاب کنید</option>
                                            @foreach($counties->where('province_id', old('province_id', $location->province_id)) as $county)
                                                <option value="{{ $county->id }}" {{ old('county_id', $location->county_id) == $county->id ? 'selected' : '' }}>
                                                    {{ $county->name_fa }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="input-group input-group-static mb-4">
                                        <label for="city_id">شهر <span class="text-danger">*</span></label>
                                        <select name="city_id" id="city_id" class="form-control" required>
                                            <option value="">انتخاب کنید</option>
                                            @foreach($cities->where('county_id', old('county_id', $location->county_id)) as $city)
                                                <option value="{{ $city->id }}" {{ old('city_id', $location->city_id) == $city->id ? 'selected' : '' }}>
                                                    {{ $city->name_fa }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="input-group input-group-static mb-4">
                                        <label for="address">آدرس دقیق <span class="text-danger">*</span></label>
                                        <textarea name="address" id="address" class="form-control" rows="2" required>{{ old('address', $location->address) }}</textarea>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-12">
                                    <label class="form-label mb-2">موقعیت جغرافیایی <span class="text-danger">*</span></label>
                                    <p class="text-sm text-muted mb-2">روی نقشه کلیک کنید تا موقعیت مکان مشخص شود</p>
                                    <div id="mapid"></div>
                                    
                                    <div class="coordinates-display">
                                        <span>طول جغرافیایی:</span>
                                        <input type="text" name="longitude" id="longitude" class="form-control-sm" value="{{ old('longitude', $location->longitude) }}" readonly>
                                        <span class="ms-2">عرض جغرافیایی:</span>
                                        <input type="text" name="latitude" id="latitude" class="form-control-sm" value="{{ old('latitude', $location->latitude) }}" readonly>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Contact Information Section -->
                        <div class="form-section">
                            <h5 class="form-section-title">اطلاعات تماس</h5>
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="input-group input-group-static mb-4">
                                        <label for="phone">شماره تماس</label>
                                        <input type="text" name="phone" id="phone" class="form-control" value="{{ old('phone', $location->phone) }}">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="input-group input-group-static mb-4">
                                        <label for="website">وب‌سایت</label>
                                        <input type="url" name="website" id="website" class="form-control" value="{{ old('website', $location->website) }}">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="input-group input-group-static mb-4">
                                        <label for="working_hours">ساعات کاری</label>
                                        <input type="text" name="working_hours" id="working_hours" class="form-control" value="{{ old('working_hours', $location->working_hours) }}">
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Additional Information Section -->
                        <div class="form-section">
                            <h5 class="form-section-title">اطلاعات تکمیلی</h5>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="input-group input-group-static mb-4">
                                        <label for="facilities">امکانات</label>
                                        <select name="facilities[]" id="facilities" class="form-control select2-multiple" multiple>
                                            @php $locationFacilities = old('facilities', $location->facilities ?? []); @endphp
                                            <option value="پارکینگ" {{ in_array('پارکینگ', $locationFacilities) ? 'selected' : '' }}>پارکینگ</option>
                                            <option value="رستوران" {{ in_array('رستوران', $locationFacilities) ? 'selected' : '' }}>رستوران</option>
                                            <option value="کافی‌شاپ" {{ in_array('کافی‌شاپ', $locationFacilities) ? 'selected' : '' }}>کافی‌شاپ</option>
                                            <option value="سرویس بهداشتی" {{ in_array('سرویس بهداشتی', $locationFacilities) ? 'selected' : '' }}>سرویس بهداشتی</option>
                                            <option value="دسترسی معلولین" {{ in_array('دسترسی معلولین', $locationFacilities) ? 'selected' : '' }}>دسترسی معلولین</option>
                                            <option value="فروشگاه" {{ in_array('فروشگاه', $locationFacilities) ? 'selected' : '' }}>فروشگاه</option>
                                            <option value="WiFi رایگان" {{ in_array('WiFi رایگان', $locationFacilities) ? 'selected' : '' }}>WiFi رایگان</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="input-group input-group-static mb-4">
                                        <label for="tags">برچسب‌ها</label>
                                        <select name="tags[]" id="tags" class="form-control select2-multiple" multiple>
                                            @foreach($tags as $tag)
                                                <option value="{{ $tag->id }}" {{ in_array($tag->id, old('tags', $location->tags->pluck('id')->toArray())) ? 'selected' : '' }}>
                                                    {{ $tag->title_fa }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="input-group input-group-static mb-4">
                                        <label for="entrance_fee">هزینه ورودی</label>
                                        <input type="text" name="entrance_fee" id="entrance_fee" class="form-control" value="{{ old('entrance_fee', $location->entrance_fee) }}">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="input-group input-group-static mb-4">
                                        <label for="visit_duration">زمان مورد نیاز برای بازدید</label>
                                        <input type="text" name="visit_duration" id="visit_duration" class="form-control" value="{{ old('visit_duration', $location->visit_duration) }}">
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="input-group input-group-static mb-4">
                                        <label for="best_time_to_visit">بهترین زمان بازدید</label>
                                        <input type="text" name="best_time_to_visit" id="best_time_to_visit" class="form-control" value="{{ old('best_time_to_visit', $location->best_time_to_visit) }}">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="input-group input-group-static mb-4">
                                        <label for="features">ویژگی‌ها</label>
                                        <select name="features[]" id="features" class="form-control select2-multiple" multiple>
                                            @foreach($features as $feature)
                                                <option value="{{ $feature->id }}" {{ in_array($feature->id, old('features', $location->features->pluck('id')->toArray())) ? 'selected' : '' }}>
                                                    {{ $feature->title_fa }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="input-group input-group-static mb-4">
                                        <label for="rules">قوانین و مقررات</label>
                                        <textarea name="rules" id="rules" class="form-control" rows="3">{{ old('rules', $location->rules) }}</textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Images Section -->
                        <div class="form-section">
                            <h5 class="form-section-title">تصاویر</h5>
                            
                            @if(count($location->images) > 0)
                                <div class="existing-images">
                                    <label class="form-label">تصاویر فعلی</label>
                                    <div class="row">
                                        @foreach($location->images as $index => $image)
                                            <div class="col-md-3 col-sm-4 col-6 mb-3">
                                                <div class="preview-item">
                                                    <img src="{{ asset('storage/' . $image) }}" alt="تصویر مکان">
                                                    <div class="form-check position-absolute bottom-0 start-0 m-2 bg-white rounded p-2">
                                                        <input class="form-check-input" type="checkbox" name="delete_images[]" value="{{ $index }}" id="delete_image_{{ $index }}">
                                                        <label class="form-check-label text-danger" for="delete_image_{{ $index }}">
                                                            حذف
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            @endif
                            
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="input-group input-group-static mb-2">
                                        <label>افزودن تصاویر جدید</label>
                                        <input type="file" name="new_images[]" id="new_images" class="form-control" multiple accept="image/*">
                                    </div>
                                    <p class="upload-info">می‌توانید تا 5 تصویر جدید آپلود کنید. حجم هر تصویر حداکثر 2 مگابایت.</p>
                                    <div class="image-preview"></div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="d-flex justify-content-end mt-4">
                            <button type="submit" class="btn bg-gradient-primary">بروزرسانی اطلاعات</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script src="https://unpkg.com/leaflet@1.7.1/dist/leaflet.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Initialize map
        var map = L.map('mapid').setView([{{ $location->latitude ?: 32.4279 }}, {{ $location->longitude ?: 53.6880 }}], {{ $location->latitude ? 13 : 5 }});
        
        L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
            attribution: '&copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a> contributors'
        }).addTo(map);
        
        var marker;
        
        // Set marker from existing values
        @if($location->latitude && $location->longitude)
            marker = L.marker([{{ $location->latitude }}, {{ $location->longitude }}]).addTo(map);
        @endif
        
        // Add marker on click
        map.on('click', function(e) {
            if (marker) {
                map.removeLayer(marker);
            }
            
            marker = L.marker(e.latlng).addTo(map);
            
            // Set form values
            document.getElementById('latitude').value = e.latlng.lat.toFixed(6);
            document.getElementById('longitude').value = e.latlng.lng.toFixed(6);
        });
        
        // Initialize Select2 for multiple select
        $('.select2-multiple').select2({
            dir: 'rtl',
            language: 'fa',
            placeholder: 'انتخاب کنید'
        });
        
        // Province, County, City cascading dropdowns
        $('#province_id').on('change', function() {
            var provinceId = $(this).val();
            
            if (provinceId) {
                // Enable county dropdown
                $('#county_id').prop('disabled', false);
                
                // Clear city dropdown
                $('#city_id').html('<option value="">ابتدا شهرستان را انتخاب کنید</option>');
                $('#city_id').prop('disabled', true);
                
                // Get counties via AJAX
                $.ajax({
                    url: '/api/counties/' + provinceId,
                    type: 'GET',
                    success: function(data) {
                        var countyOptions = '<option value="">شهرستان را انتخاب کنید</option>';
                        
                        data.forEach(function(county) {
                            countyOptions += '<option value="' + county.id + '">' + county.name_fa + '</option>';
                        });
                        
                        $('#county_id').html(countyOptions);
                    }
                });
            } else {
                $('#county_id').html('<option value="">ابتدا استان را انتخاب کنید</option>');
                $('#county_id').prop('disabled', true);
                $('#city_id').html('<option value="">ابتدا شهرستان را انتخاب کنید</option>');
                $('#city_id').prop('disabled', true);
            }
        });
        
        $('#county_id').on('change', function() {
            var countyId = $(this).val();
            
            if (countyId) {
                // Enable city dropdown
                $('#city_id').prop('disabled', false);
                
                // Get cities via AJAX
                $.ajax({
                    url: '/api/cities/' + countyId,
                    type: 'GET',
                    success: function(data) {
                        var cityOptions = '<option value="">شهر را انتخاب کنید</option>';
                        
                        data.forEach(function(city) {
                            cityOptions += '<option value="' + city.id + '">' + city.name_fa + '</option>';
                        });
                        
                        $('#city_id').html(cityOptions);
                    }
                });
            } else {
                $('#city_id').html('<option value="">ابتدا شهرستان را انتخاب کنید</option>');
                $('#city_id').prop('disabled', true);
            }
        });
        
        // Image preview for new images
        $('#new_images').on('change', function() {
            const previewContainer = $('.image-preview');
            previewContainer.empty();
            
            if (this.files) {
                const maxFiles = 5;
                const files = Array.from(this.files).slice(0, maxFiles);
                
                files.forEach((file, index) => {
                    const reader = new FileReader();
                    
                    reader.onload = function(e) {
                        const previewItem = document.createElement('div');
                        previewItem.className = 'preview-item';
                        
                        const img = document.createElement('img');
                        img.src = e.target.result;
                        
                        const removeBtn = document.createElement('button');
                        removeBtn.className = 'remove-image';
                        removeBtn.innerHTML = '×';
                        removeBtn.dataset.index = index;
                        
                        previewItem.appendChild(img);
                        previewItem.appendChild(removeBtn);
                        previewContainer.append(previewItem);
                    };
                    
                    reader.readAsDataURL(file);
                });
            }
        });
        
        // Remove image preview
        $(document).on('click', '.remove-image', function() {
            $(this).parent().remove();
            
            // To properly reset file input, we need to create a new one
            // This is done to clear a specific preview, but the file input contains all files
            // We'll need a more complex approach to selectively remove files
            // For now, clicking the × resets the entire input
            document.getElementById('new_images').value = '';
            $('.image-preview').empty();
        });
    });
</script>
@endsection 