@extends('layouts.user')

@section('title', 'داشبورد کاربری')

@section('content')
<!-- Welcome Header -->
<div class="welcome-header mb-4">
    <div class="d-flex justify-content-between align-items-center">
        <div>
            <h1 class="h2 mb-2 text-dark fw-bold">سلام {{ $user->full_name }}! 👋</h1>
            <p class="text-muted mb-0">به پنل کاربری خود خوش آمدید. اینجا می‌توانید مکان‌ها و نظرات خود را مدیریت کنید.</p>
        </div>
        <div class="d-flex gap-2 flex-wrap">
            <a href="{{ route('user.locations.create') }}" class="btn btn-primary btn-lg shadow-sm">
                <i class="fas fa-plus-circle me-2"></i>ثبت مکان جدید
            </a>
            <a href="{{ route('user.ratings.create') }}" class="btn btn-outline-primary btn-lg">
                <i class="fas fa-star me-2"></i>ثبت نظر
            </a>
        </div>
    </div>
</div>

<!-- Statistics Cards -->
<div class="row g-4 mb-4">
    <!-- مکان‌های من -->
    <div class="col-xl-3 col-md-6">
        <div class="stats-card stats-card-primary">
            <div class="stats-card-body">
                <div class="d-flex align-items-center">
                    <div class="stats-icon">
                        <i class="fas fa-map-marker-alt"></i>
                    </div>
                    <div class="stats-content">
                        <div class="stats-number" data-count="{{ $stats['total_locations'] }}">{{ number_format($stats['total_locations']) }}</div>
                        <div class="stats-label">مکان‌های من</div>
                        @if($stats['locations_growth'] > 0)
                            <div class="stats-growth positive">
                                <i class="fas fa-arrow-up"></i>
                                {{ $stats['locations_growth'] }}% رشد
                            </div>
                        @elseif($stats['locations_growth'] < 0)
                            <div class="stats-growth negative">
                                <i class="fas fa-arrow-down"></i>
                                {{ abs($stats['locations_growth']) }}% کاهش
                            </div>
                        @endif
                    </div>
                </div>
                <div class="stats-progress">
                    <div class="progress">
                        <div class="progress-bar bg-primary" style="width: {{ $stats['active_locations'] > 0 ? ($stats['active_locations'] / max($stats['total_locations'], 1)) * 100 : 0 }}%"></div>
                    </div>
                    <small class="text-muted">{{ $stats['active_locations'] }} فعال از {{ $stats['total_locations'] }}</small>
                </div>
            </div>
        </div>
    </div>

    <!-- مکان‌های در انتظار تایید -->
    <div class="col-xl-3 col-md-6">
        <div class="stats-card stats-card-warning">
            <div class="stats-card-body">
                <div class="d-flex align-items-center">
                    <div class="stats-icon">
                        <i class="fas fa-clock"></i>
                    </div>
                    <div class="stats-content">
                        <div class="stats-number" data-count="{{ $stats['pending_locations'] }}">{{ number_format($stats['pending_locations']) }}</div>
                        <div class="stats-label">در انتظار تایید</div>
                        @if($stats['pending_locations'] > 0)
                            <div class="stats-note">
                                <i class="fas fa-info-circle"></i>
                                نیاز به بررسی
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- نظرات من -->
    <div class="col-xl-3 col-md-6">
        <div class="stats-card stats-card-success">
            <div class="stats-card-body">
                <div class="d-flex align-items-center">
                    <div class="stats-icon">
                        <i class="fas fa-comments"></i>
                    </div>
                    <div class="stats-content">
                        <div class="stats-number" data-count="{{ $stats['total_ratings'] }}">{{ number_format($stats['total_ratings']) }}</div>
                        <div class="stats-label">نظرات من</div>
                        @if($stats['avg_rating'] > 0)
                            <div class="stats-rating">
                                <div class="rating-stars">
                                    @for($i = 1; $i <= 5; $i++)
                                        <i class="fas fa-star {{ $i <= round($stats['avg_rating']) ? 'text-warning' : 'text-muted' }}"></i>
                                    @endfor
                                </div>
                                <span class="rating-value">{{ number_format($stats['avg_rating'], 1) }}</span>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- مشاهدات -->
    <div class="col-xl-3 col-md-6">
        <div class="stats-card stats-card-info">
            <div class="stats-card-body">
                <div class="d-flex align-items-center">
                    <div class="stats-icon">
                        <i class="fas fa-eye"></i>
                    </div>
                    <div class="stats-content">
                        <div class="stats-number" data-count="{{ $stats['total_views'] }}">{{ number_format($stats['total_views']) }}</div>
                        <div class="stats-label">مشاهدات کل</div>
                        @if($stats['total_locations'] > 0)
                            <div class="stats-note">
                                <i class="fas fa-chart-line"></i>
                                {{ number_format($stats['total_views'] / $stats['total_locations']) }} میانگین
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Activity Chart -->
<div class="row g-4 mb-4">
    <div class="col-lg-8">
        <div class="modern-card">
            <div class="card-header">
                <h5 class="card-title">
                    <i class="fas fa-chart-line me-2"></i>فعالیت ماهانه
                </h5>
                <p class="card-subtitle">نمودار مکان‌ها و نظرات ثبت شده در ۱۲ ماه گذشته</p>
            </div>
            <div class="card-body">
                <canvas id="activityChart" height="100"></canvas>
            </div>
        </div>
    </div>

    <div class="col-lg-4">
        <div class="modern-card h-100">
            <div class="card-header">
                <h5 class="card-title">
                    <i class="fas fa-rocket me-2"></i>دسترسی سریع
                </h5>
            </div>
            <div class="card-body">
                <div class="quick-actions">
                    <a href="{{ route('user.locations.create') }}" class="quick-action-btn primary">
                        <div class="action-icon">
                            <i class="fas fa-plus-circle"></i>
                        </div>
                        <div class="action-content">
                            <div class="action-title">ثبت مکان جدید</div>
                            <div class="action-subtitle">مکان خود را معرفی کنید</div>
                        </div>
                    </a>

                    <a href="{{ route('user.locations.index') }}" class="quick-action-btn info">
                        <div class="action-icon">
                            <i class="fas fa-list"></i>
                        </div>
                        <div class="action-content">
                            <div class="action-title">مکان‌های من</div>
                            <div class="action-subtitle">مدیریت مکان‌های ثبت شده</div>
                        </div>
                    </a>

                    <a href="{{ route('user.ratings.create') }}" class="quick-action-btn success">
                        <div class="action-icon">
                            <i class="fas fa-star"></i>
                        </div>
                        <div class="action-content">
                            <div class="action-title">ثبت نظر جدید</div>
                            <div class="action-subtitle">تجربه خود را به اشتراک بگذارید</div>
                        </div>
                    </a>

                    <a href="{{ route('user.profile') }}" class="quick-action-btn secondary">
                        <div class="action-icon">
                            <i class="fas fa-user-edit"></i>
                        </div>
                        <div class="action-content">
                            <div class="action-title">ویرایش پروفایل</div>
                            <div class="action-subtitle">به‌روزرسانی اطلاعات شخصی</div>
                        </div>
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Recent Content -->
<div class="row g-4 mb-4">
    <!-- آخرین مکان‌های ثبت شده -->
    <div class="col-lg-6">
        <div class="modern-card">
            <div class="card-header">
                <h5 class="card-title">
                    <i class="fas fa-map-marker-alt me-2"></i>آخرین مکان‌های من
                </h5>
                <a href="{{ route('user.locations.index') }}" class="btn btn-sm btn-outline-primary">مشاهده همه</a>
            </div>
            <div class="card-body">
                @if($recentLocations->count() > 0)
                    <div class="recent-items">
                        @foreach($recentLocations as $location)
                            <div class="recent-item">
                                <div class="item-icon">
                                    <i class="fas fa-map-marker-alt text-primary"></i>
                                </div>
                                <div class="item-content">
                                    <div class="item-title">{{ $location->title }}</div>
                                    <div class="item-meta">
                                        <span class="badge badge-{{ $location->is_active ? 'success' : 'warning' }}">
                                            {{ $location->is_active ? 'فعال' : 'در انتظار تایید' }}
                                        </span>
                                        @if($location->ratings_count > 0)
                                            <span class="rating-info">
                                                <i class="fas fa-star text-warning"></i>
                                                {{ number_format($location->avg_rating, 1) }}
                                                ({{ $location->ratings_count }})
                                            </span>
                                        @endif
                                    </div>
                                    <div class="item-date">{{ $location->created_at->diffForHumans() }}</div>
                                </div>
                                <div class="item-actions">
                                    <a href="{{ route('user.locations.edit', $location->id) }}" class="btn btn-sm btn-outline-primary">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                </div>
                            </div>
                        @endforeach
                    </div>
                @else
                    <div class="empty-state">
                        <div class="empty-icon">
                            <i class="fas fa-map-marker-alt"></i>
                        </div>
                        <div class="empty-title">هنوز مکانی ثبت نکرده‌اید</div>
                        <div class="empty-subtitle">اولین مکان خود را ثبت کنید و با دیگران به اشتراک بگذارید</div>
                        <a href="{{ route('user.locations.create') }}" class="btn btn-primary mt-3">
                            <i class="fas fa-plus-circle me-2"></i>ثبت مکان جدید
                        </a>
                    </div>
                @endif
            </div>
        </div>
    </div>

    <!-- آخرین نظرات من -->
    <div class="col-lg-6">
        <div class="modern-card">
            <div class="card-header">
                <h5 class="card-title">
                    <i class="fas fa-comments me-2"></i>آخرین نظرات من
                </h5>
                <a href="{{ route('user.ratings.index') }}" class="btn btn-sm btn-outline-primary">مشاهده همه</a>
            </div>
            <div class="card-body">
                @if($recentRatings->count() > 0)
                    <div class="recent-items">
                        @foreach($recentRatings as $rating)
                            <div class="recent-item">
                                <div class="item-icon">
                                    <i class="fas fa-star text-warning"></i>
                                </div>
                                <div class="item-content">
                                    <div class="item-title">{{ $rating->location->title ?? 'مکان حذف شده' }}</div>
                                    <div class="item-meta">
                                        <div class="rating-stars">
                                            @for($i = 1; $i <= 5; $i++)
                                                <i class="fas fa-star {{ $i <= $rating->rating ? 'text-warning' : 'text-muted' }}"></i>
                                            @endfor
                                        </div>
                                        <span class="badge badge-{{ $rating->status == 'approved' ? 'success' : 'warning' }}">
                                            {{ $rating->status == 'approved' ? 'تایید شده' : 'در انتظار تایید' }}
                                        </span>
                                    </div>
                                    @if($rating->comment)
                                        <div class="item-comment">{{ Str::limit($rating->comment, 80) }}</div>
                                    @endif
                                    <div class="item-date">{{ $rating->timestamp->diffForHumans() }}</div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                @else
                    <div class="empty-state">
                        <div class="empty-icon">
                            <i class="fas fa-comments"></i>
                        </div>
                        <div class="empty-title">هنوز نظری ثبت نکرده‌اید</div>
                        <div class="empty-subtitle">تجربه خود را با دیگران به اشتراک بگذارید</div>
                        <a href="{{ route('user.ratings.create') }}" class="btn btn-primary mt-3">
                            <i class="fas fa-star me-2"></i>ثبت نظر جدید
                        </a>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>

<!-- Performance Overview -->
@if($locationPerformance->count() > 0)
<div class="row g-4 mb-4">
    <div class="col-12">
        <div class="modern-card">
            <div class="card-header">
                <h5 class="card-title">
                    <i class="fas fa-chart-bar me-2"></i>عملکرد مکان‌های من
                </h5>
                <p class="card-subtitle">آمار مشاهدات و امتیازات مکان‌های ثبت شده</p>
            </div>
            <div class="card-body">
                <div class="performance-grid">
                    @foreach($locationPerformance->take(6) as $location)
                        <div class="performance-item">
                            <div class="performance-header">
                                <h6 class="performance-title">{{ Str::limit($location->title, 30) }}</h6>
                                <span class="badge badge-{{ $location->is_active ? 'success' : 'warning' }}">
                                    {{ $location->is_active ? 'فعال' : 'غیرفعال' }}
                                </span>
                            </div>
                            <div class="performance-stats">
                                <div class="stat-item">
                                    <div class="stat-icon">
                                        <i class="fas fa-eye text-info"></i>
                                    </div>
                                    <div class="stat-content">
                                        <div class="stat-value">{{ number_format($location->views_count) }}</div>
                                        <div class="stat-label">مشاهده</div>
                                    </div>
                                </div>
                                <div class="stat-item">
                                    <div class="stat-icon">
                                        <i class="fas fa-star text-warning"></i>
                                    </div>
                                    <div class="stat-content">
                                        <div class="stat-value">{{ $location->ratings_count }}</div>
                                        <div class="stat-label">نظر</div>
                                    </div>
                                </div>
                                @if($location->avg_rating > 0)
                                    <div class="stat-item">
                                        <div class="stat-icon">
                                            <i class="fas fa-thumbs-up text-success"></i>
                                        </div>
                                        <div class="stat-content">
                                            <div class="stat-value">{{ number_format($location->avg_rating, 1) }}</div>
                                            <div class="stat-label">امتیاز</div>
                                        </div>
                                    </div>
                                @endif
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</div>
@endif

<!-- Help Guide -->
<div class="row g-4">
    <div class="col-12">
        <div class="modern-card guide-card">
            <div class="card-header">
                <h5 class="card-title">
                    <i class="fas fa-lightbulb me-2"></i>راهنمای استفاده
                </h5>
                <p class="card-subtitle">مراحل ثبت مکان و نظر در سایت</p>
            </div>
            <div class="card-body">
                <div class="guide-steps">
                    <div class="guide-step">
                        <div class="step-number">1</div>
                        <div class="step-content">
                            <div class="step-icon">
                                <i class="fas fa-plus-circle"></i>
                            </div>
                            <h6 class="step-title">ثبت مکان</h6>
                            <p class="step-description">اطلاعات مکان خود را به صورت کامل وارد کنید تا کاربران بتوانند آن را پیدا کنند.</p>
                        </div>
                    </div>

                    <div class="guide-step">
                        <div class="step-number">2</div>
                        <div class="step-content">
                            <div class="step-icon">
                                <i class="fas fa-check-circle"></i>
                            </div>
                            <h6 class="step-title">تایید مدیر</h6>
                            <p class="step-description">مکان ثبت شده پس از بررسی توسط مدیران سایت تایید و منتشر می‌شود.</p>
                        </div>
                    </div>

                    <div class="guide-step">
                        <div class="step-number">3</div>
                        <div class="step-content">
                            <div class="step-icon">
                                <i class="fas fa-star"></i>
                            </div>
                            <h6 class="step-title">دریافت نظرات</h6>
                            <p class="step-description">کاربران می‌توانند نظرات و امتیاز خود را برای مکان شما ثبت کنند.</p>
                        </div>
                    </div>

                    <div class="guide-step">
                        <div class="step-number">4</div>
                        <div class="step-content">
                            <div class="step-icon">
                                <i class="fas fa-chart-line"></i>
                            </div>
                            <h6 class="step-title">رشد و بهبود</h6>
                            <p class="step-description">با مشاهده آمار و نظرات، مکان خود را بهبود دهید و محبوبیت آن را افزایش دهید.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('styles')
<style>
    /* Modern Dashboard Styles */
    body {
        font-family: 'IRANSans', 'Tahoma', Arial, sans-serif !important;
    }

    .welcome-header {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        border-radius: 20px;
        padding: 2rem;
        color: white;
        margin-bottom: 2rem;
        position: relative;
        overflow: hidden;
    }

    .welcome-header::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><defs><pattern id="grain" width="100" height="100" patternUnits="userSpaceOnUse"><circle cx="50" cy="50" r="1" fill="white" opacity="0.1"/></pattern></defs><rect width="100" height="100" fill="url(%23grain)"/></svg>');
        pointer-events: none;
    }

    .welcome-header h1, .welcome-header p {
        position: relative;
        z-index: 1;
    }

    /* Stats Cards */
    .stats-card {
        background: white;
        border-radius: 16px;
        padding: 1.5rem;
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
        border: 1px solid rgba(0, 0, 0, 0.05);
        transition: all 0.3s ease;
        height: 100%;
        position: relative;
        overflow: hidden;
    }

    .stats-card::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        width: 4px;
        height: 100%;
        transition: all 0.3s ease;
    }

    .stats-card-primary::before { background: linear-gradient(135deg, #667eea, #764ba2); }
    .stats-card-warning::before { background: linear-gradient(135deg, #f093fb, #f5576c); }
    .stats-card-success::before { background: linear-gradient(135deg, #4facfe, #00f2fe); }
    .stats-card-info::before { background: linear-gradient(135deg, #43e97b, #38f9d7); }

    .stats-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 8px 30px rgba(0, 0, 0, 0.12);
    }

    .stats-card:hover::before {
        width: 8px;
    }

    .stats-icon {
        width: 60px;
        height: 60px;
        border-radius: 16px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 1.5rem;
        margin-left: 1rem;
        position: relative;
    }

    .stats-card-primary .stats-icon {
        background: linear-gradient(135deg, #667eea, #764ba2);
        color: white;
    }

    .stats-card-warning .stats-icon {
        background: linear-gradient(135deg, #f093fb, #f5576c);
        color: white;
    }

    .stats-card-success .stats-icon {
        background: linear-gradient(135deg, #4facfe, #00f2fe);
        color: white;
    }

    .stats-card-info .stats-icon {
        background: linear-gradient(135deg, #43e97b, #38f9d7);
        color: white;
    }

    .stats-number {
        font-size: 2rem;
        font-weight: 700;
        color: #2d3748;
        line-height: 1;
        margin-bottom: 0.25rem;
    }

    .stats-label {
        font-size: 0.875rem;
        color: #718096;
        font-weight: 500;
        margin-bottom: 0.5rem;
    }

    .stats-growth {
        font-size: 0.75rem;
        font-weight: 600;
        display: flex;
        align-items: center;
        gap: 0.25rem;
    }

    .stats-growth.positive { color: #38a169; }
    .stats-growth.negative { color: #e53e3e; }

    .stats-progress {
        margin-top: 1rem;
    }

    .stats-progress .progress {
        height: 6px;
        border-radius: 3px;
        background-color: #f7fafc;
        margin-bottom: 0.5rem;
    }

    .stats-rating {
        display: flex;
        align-items: center;
        gap: 0.5rem;
        margin-top: 0.5rem;
    }

    .rating-stars {
        display: flex;
        gap: 2px;
    }

    .rating-value {
        font-weight: 600;
        color: #2d3748;
    }

    .stats-note {
        font-size: 0.75rem;
        color: #718096;
        display: flex;
        align-items: center;
        gap: 0.25rem;
        margin-top: 0.5rem;
    }

    /* Modern Cards */
    .modern-card {
        background: white;
        border-radius: 20px;
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
        border: 1px solid rgba(0, 0, 0, 0.05);
        overflow: hidden;
        transition: all 0.3s ease;
    }

    .modern-card:hover {
        box-shadow: 0 8px 30px rgba(0, 0, 0, 0.12);
    }

    .modern-card .card-header {
        background: linear-gradient(135deg, #f8fafc, #edf2f7);
        border-bottom: 1px solid rgba(0, 0, 0, 0.05);
        padding: 1.5rem;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .card-title {
        font-size: 1.125rem;
        font-weight: 700;
        color: #2d3748;
        margin: 0;
        display: flex;
        align-items: center;
    }

    .card-subtitle {
        font-size: 0.875rem;
        color: #718096;
        margin: 0.25rem 0 0 0;
    }

    .modern-card .card-body {
        padding: 1.5rem;
    }

    /* Quick Actions */
    .quick-actions {
        display: flex;
        flex-direction: column;
        gap: 1rem;
    }

    .quick-action-btn {
        display: flex;
        align-items: center;
        padding: 1rem;
        border-radius: 12px;
        text-decoration: none;
        transition: all 0.3s ease;
        border: 1px solid rgba(0, 0, 0, 0.05);
    }

    .quick-action-btn:hover {
        transform: translateX(-5px);
        text-decoration: none;
        box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
    }

    .quick-action-btn.primary {
        background: linear-gradient(135deg, #667eea, #764ba2);
        color: white;
    }

    .quick-action-btn.info {
        background: linear-gradient(135deg, #4facfe, #00f2fe);
        color: white;
    }

    .quick-action-btn.success {
        background: linear-gradient(135deg, #43e97b, #38f9d7);
        color: white;
    }

    .quick-action-btn.secondary {
        background: linear-gradient(135deg, #a8edea, #fed6e3);
        color: #2d3748;
    }

    .action-icon {
        width: 40px;
        height: 40px;
        border-radius: 10px;
        background: rgba(255, 255, 255, 0.2);
        display: flex;
        align-items: center;
        justify-content: center;
        margin-left: 1rem;
        font-size: 1.25rem;
    }

    .action-title {
        font-weight: 600;
        font-size: 0.875rem;
        margin-bottom: 0.25rem;
    }

    .action-subtitle {
        font-size: 0.75rem;
        opacity: 0.8;
    }

    /* Recent Items */
    .recent-items {
        display: flex;
        flex-direction: column;
        gap: 1rem;
    }

    .recent-item {
        display: flex;
        align-items: center;
        padding: 1rem;
        border-radius: 12px;
        background: #f8fafc;
        border: 1px solid rgba(0, 0, 0, 0.05);
        transition: all 0.3s ease;
    }

    .recent-item:hover {
        background: white;
        box-shadow: 0 2px 10px rgba(0, 0, 0, 0.08);
    }

    .item-icon {
        width: 40px;
        height: 40px;
        border-radius: 10px;
        background: white;
        display: flex;
        align-items: center;
        justify-content: center;
        margin-left: 1rem;
        font-size: 1.125rem;
    }

    .item-content {
        flex: 1;
    }

    .item-title {
        font-weight: 600;
        color: #2d3748;
        margin-bottom: 0.25rem;
    }

    .item-meta {
        display: flex;
        align-items: center;
        gap: 0.5rem;
        margin-bottom: 0.25rem;
    }

    .item-comment {
        font-size: 0.875rem;
        color: #718096;
        margin-bottom: 0.25rem;
    }

    .item-date {
        font-size: 0.75rem;
        color: #a0aec0;
    }

    .item-actions {
        margin-right: 1rem;
    }

    .rating-info {
        display: flex;
        align-items: center;
        gap: 0.25rem;
        font-size: 0.75rem;
        color: #718096;
    }

    /* Badges */
    .badge {
        padding: 0.25rem 0.5rem;
        border-radius: 6px;
        font-size: 0.75rem;
        font-weight: 500;
    }

    .badge-success {
        background: #c6f6d5;
        color: #22543d;
    }

    .badge-warning {
        background: #fef5e7;
        color: #c05621;
    }

    /* Empty State */
    .empty-state {
        text-align: center;
        padding: 3rem 1rem;
    }

    .empty-icon {
        width: 80px;
        height: 80px;
        border-radius: 50%;
        background: linear-gradient(135deg, #f7fafc, #edf2f7);
        display: flex;
        align-items: center;
        justify-content: center;
        margin: 0 auto 1rem;
        font-size: 2rem;
        color: #a0aec0;
    }

    .empty-title {
        font-size: 1.125rem;
        font-weight: 600;
        color: #2d3748;
        margin-bottom: 0.5rem;
    }

    .empty-subtitle {
        font-size: 0.875rem;
        color: #718096;
        margin-bottom: 1rem;
    }

    /* Performance Grid */
    .performance-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
        gap: 1rem;
    }

    .performance-item {
        background: #f8fafc;
        border-radius: 12px;
        padding: 1rem;
        border: 1px solid rgba(0, 0, 0, 0.05);
    }

    .performance-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 1rem;
    }

    .performance-title {
        font-size: 0.875rem;
        font-weight: 600;
        color: #2d3748;
        margin: 0;
    }

    .performance-stats {
        display: flex;
        gap: 1rem;
    }

    .stat-item {
        display: flex;
        align-items: center;
        gap: 0.5rem;
    }

    .stat-icon {
        width: 32px;
        height: 32px;
        border-radius: 8px;
        background: white;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 0.875rem;
    }

    .stat-value {
        font-weight: 600;
        color: #2d3748;
        font-size: 0.875rem;
    }

    .stat-label {
        font-size: 0.75rem;
        color: #718096;
    }

    /* Guide Steps */
    .guide-card {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
    }

    .guide-card .card-header {
        background: rgba(255, 255, 255, 0.1);
        border-bottom: 1px solid rgba(255, 255, 255, 0.1);
    }

    .guide-card .card-title,
    .guide-card .card-subtitle {
        color: white;
    }

    .guide-steps {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
        gap: 2rem;
    }

    .guide-step {
        text-align: center;
        position: relative;
    }

    .step-number {
        width: 40px;
        height: 40px;
        border-radius: 50%;
        background: rgba(255, 255, 255, 0.2);
        display: flex;
        align-items: center;
        justify-content: center;
        margin: 0 auto 1rem;
        font-weight: 700;
        font-size: 1.125rem;
    }

    .step-icon {
        width: 60px;
        height: 60px;
        border-radius: 50%;
        background: rgba(255, 255, 255, 0.1);
        display: flex;
        align-items: center;
        justify-content: center;
        margin: 0 auto 1rem;
        font-size: 1.5rem;
    }

    .step-title {
        font-size: 1rem;
        font-weight: 600;
        margin-bottom: 0.5rem;
    }

    .step-description {
        font-size: 0.875rem;
        opacity: 0.9;
        line-height: 1.5;
    }

    /* Responsive Design */
    @media (max-width: 768px) {
        .welcome-header {
            padding: 1.5rem;
        }

        .welcome-header .d-flex {
            flex-direction: column;
            gap: 1rem;
            align-items: stretch !important;
        }

        .welcome-header .btn {
            width: 100%;
            justify-content: center;
        }

        .stats-card {
            margin-bottom: 1rem;
        }

        .stats-icon {
            width: 50px;
            height: 50px;
            font-size: 1.25rem;
        }

        .stats-number {
            font-size: 1.5rem;
        }

        .performance-grid {
            grid-template-columns: 1fr;
        }

        .guide-steps {
            grid-template-columns: 1fr;
            gap: 1.5rem;
        }

        .quick-actions {
            gap: 0.75rem;
        }

        .quick-action-btn {
            padding: 0.75rem;
        }

        .modern-card .card-header {
            flex-direction: column;
            align-items: flex-start;
            gap: 0.5rem;
        }

        .recent-item {
            flex-direction: column;
            align-items: flex-start;
            text-align: right;
        }

        .item-icon {
            margin: 0 0 0.5rem 0;
        }

        .item-actions {
            margin: 0.5rem 0 0 0;
            align-self: flex-end;
        }
    }

    @media (max-width: 576px) {
        .welcome-header h1 {
            font-size: 1.5rem;
        }

        .stats-card {
            padding: 1rem;
        }

        .modern-card .card-body {
            padding: 1rem;
        }

        .performance-stats {
            flex-direction: column;
            gap: 0.5rem;
        }
    }

    /* Animation */
    @keyframes fadeInUp {
        from {
            opacity: 0;
            transform: translateY(20px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    .stats-card,
    .modern-card {
        animation: fadeInUp 0.6s ease forwards;
    }

    .stats-card:nth-child(1) { animation-delay: 0.1s; }
    .stats-card:nth-child(2) { animation-delay: 0.2s; }
    .stats-card:nth-child(3) { animation-delay: 0.3s; }
    .stats-card:nth-child(4) { animation-delay: 0.4s; }
</style>
@endsection

@section('scripts')
<script src="{{ asset('js/locale-date-manager.js') }}"></script>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const locale = document.documentElement.lang || 'fa';

    // Activity Chart
    const ctx = document.getElementById('activityChart');
    if (ctx) {
        const monthlyActivity = {
            months: @json($monthlyActivity['months']),
            locations: @json($monthlyActivity['locations']),
            ratings: @json($monthlyActivity['ratings'])
        };

        // فرمت کردن برچسب‌های ماه بر اساس زبان
        const formatMonthLabels = (months) => {
            return months.map(month => {
                if (window.localeDateManager) {
                    return window.localeDateManager.formatMonthForChart(month);
                } else {
                    // Fallback
                    if (locale === 'fa') {
                        const persianMonths = ['فروردین', 'اردیبهشت', 'خرداد', 'تیر', 'مرداد', 'شهریور', 'مهر', 'آبان', 'آذر', 'دی', 'بهمن', 'اسفند'];
                        return persianMonths[month - 1] || month;
                    } else {
                        const date = new Date(2000, month - 1, 1);
                        return date.toLocaleDateString(locale, { month: 'short' });
                    }
                }
            });
        };

        const activityChart = new Chart(ctx, {
            type: 'line',
            data: {
                labels: formatMonthLabels(monthlyActivity.months),
                datasets: [{
                    label: locale === 'fa' ? 'مکان‌ها' : 'Locations',
                    data: monthlyActivity.locations,
                    borderColor: '#667eea',
                    backgroundColor: 'rgba(102, 126, 234, 0.1)',
                    borderWidth: 3,
                    fill: true,
                    tension: 0.4,
                    pointBackgroundColor: '#667eea',
                    pointBorderColor: '#fff',
                    pointBorderWidth: 2,
                    pointRadius: 6,
                    pointHoverRadius: 8
                }, {
                    label: locale === 'fa' ? 'نظرات' : 'Reviews',
                    data: monthlyActivity.ratings,
                    borderColor: '#4facfe',
                    backgroundColor: 'rgba(79, 172, 254, 0.1)',
                    borderWidth: 3,
                    fill: true,
                    tension: 0.4,
                    pointBackgroundColor: '#4facfe',
                    pointBorderColor: '#fff',
                    pointBorderWidth: 2,
                    pointRadius: 6,
                    pointHoverRadius: 8
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        position: 'top',
                        rtl: locale === 'fa',
                        labels: {
                            usePointStyle: true,
                            padding: 20,
                            font: {
                                family: locale === 'fa' ? 'IRANSans' : 'Arial',
                                size: 12
                            }
                        }
                    },
                    tooltip: {
                        backgroundColor: 'rgba(0, 0, 0, 0.8)',
                        titleColor: '#fff',
                        bodyColor: '#fff',
                        borderColor: '#667eea',
                        borderWidth: 1,
                        cornerRadius: 8,
                        displayColors: true,
                        titleFont: {
                            family: locale === 'fa' ? 'IRANSans' : 'Arial'
                        },
                        bodyFont: {
                            family: locale === 'fa' ? 'IRANSans' : 'Arial'
                        },
                        callbacks: {
                            label: function(context) {
                                const value = context.parsed.y;
                                const formattedValue = window.localeDateManager && locale === 'fa' ?
                                    window.localeDateManager.toPersianNumbers(value.toString()) : value;
                                return `${context.dataset.label}: ${formattedValue}`;
                            }
                        }
                    }
                },
                scales: {
                    x: {
                        grid: {
                            display: false
                        },
                        ticks: {
                            font: {
                                family: locale === 'fa' ? 'IRANSans' : 'Arial',
                                size: 11
                            },
                            color: '#718096'
                        }
                    },
                    y: {
                        beginAtZero: true,
                        grid: {
                            color: 'rgba(0, 0, 0, 0.05)',
                            drawBorder: false
                        },
                        ticks: {
                            font: {
                                family: locale === 'fa' ? 'IRANSans' : 'Arial',
                                size: 11
                            },
                            color: '#718096',
                            callback: function(value) {
                                return window.localeDateManager && locale === 'fa' ?
                                    window.localeDateManager.toPersianNumbers(value.toString()) : value;
                            }
                        }
                    }
                },
                interaction: {
                    intersect: false,
                    mode: 'index'
                },
                elements: {
                    point: {
                        hoverBackgroundColor: '#fff'
                    }
                }
            }
        });
    }

    // Counter Animation
    function animateCounter(element, target) {
        let current = 0;
        const increment = target / 100;
        const timer = setInterval(() => {
            current += increment;
            if (current >= target) {
                current = target;
                clearInterval(timer);
            }

            const formattedNumber = Math.floor(current);
            if (window.localeDateManager && locale === 'fa') {
                element.textContent = window.localeDateManager.toPersianNumbers(formattedNumber.toLocaleString('fa-IR'));
            } else {
                element.textContent = formattedNumber.toLocaleString();
            }
        }, 20);
    }

    // Animate stats numbers
    const statsNumbers = document.querySelectorAll('.stats-number');
    const observer = new IntersectionObserver((entries) => {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                const target = parseInt(entry.target.getAttribute('data-count') || '0');
                if (target > 0) {
                    animateCounter(entry.target, target);
                }
                observer.unobserve(entry.target);
            }
        });
    });

    statsNumbers.forEach(number => {
        observer.observe(number);
    });

    // Add hover effects to cards
    const cards = document.querySelectorAll('.stats-card, .modern-card');
    cards.forEach(card => {
        card.addEventListener('mouseenter', function() {
            this.style.transform = 'translateY(-5px)';
        });

        card.addEventListener('mouseleave', function() {
            this.style.transform = 'translateY(0)';
        });
    });
});
</script>
@endsection