<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="robots" content="noindex, nofollow">
    <meta http-equiv="X-Content-Type-Options" content="nosniff">
    <meta http-equiv="X-Frame-Options" content="SAMEORIGIN">
    <meta http-equiv="X-XSS-Protection" content="1; mode=block">
    <meta http-equiv="Referrer-Policy" content="strict-origin-when-cross-origin">
    <title>بازیابی رمز عبور - مکان‌های ایران</title>
    <meta name="description" content="بازیابی رمز عبور حساب کاربری سیستم مکان‌های ایران">

    <!-- Stylesheets -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.rtl.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <link rel="stylesheet" href="{{ asset('css/fonts.css') }}">

    <style>
        :root {
            --primary-gradient: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            --secondary-gradient: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
            --success-gradient: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
            --warning-gradient: linear-gradient(135deg, #43e97b 0%, #38f9d7 100%);
            --glass-bg: rgba(255, 255, 255, 0.25);
            --glass-border: rgba(255, 255, 255, 0.18);
            --shadow-light: 0 8px 32px 0 rgba(31, 38, 135, 0.37);
            --shadow-heavy: 0 15px 35px rgba(0, 0, 0, 0.1);
            --border-radius: 16px;
            --transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'IRANSans', 'Segoe UI', Tahoma, Arial, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 50%, #f093fb 100%);
            min-height: 100vh;
            position: relative;
            overflow-x: hidden;
        }

        /* Animated Background */
        body::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1000 1000"><defs><radialGradient id="a" cx="50%" cy="50%"><stop offset="0%" stop-color="%23ffffff" stop-opacity="0.1"/><stop offset="100%" stop-color="%23ffffff" stop-opacity="0"/></radialGradient></defs><circle cx="200" cy="300" r="150" fill="url(%23a)"/><circle cx="800" cy="200" r="120" fill="url(%23a)"/><circle cx="300" cy="700" r="100" fill="url(%23a)"/><circle cx="700" cy="600" r="80" fill="url(%23a)"/></svg>') no-repeat center center;
            background-size: cover;
            animation: float 30s ease-in-out infinite;
            pointer-events: none;
        }

        @keyframes float {
            0%, 100% { transform: translateY(0px) rotate(0deg); }
            50% { transform: translateY(-20px) rotate(180deg); }
        }

        .main-container {
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            padding: 2rem;
        }

        /* Forgot Password Form Container */
        .forgot-password-container {
            background: var(--glass-bg);
            backdrop-filter: blur(16px);
            -webkit-backdrop-filter: blur(16px);
            border: 1px solid var(--glass-border);
            border-radius: var(--border-radius);
            padding: 2.5rem;
            box-shadow: var(--shadow-light);
            animation: slideInUp 0.8s ease-out;
            width: 100%;
            max-width: 450px;
        }

        @keyframes slideInUp {
            from { opacity: 0; transform: translateY(50px); }
            to { opacity: 1; transform: translateY(0); }
        }

        .form-header {
            text-align: center;
            margin-bottom: 2rem;
            color: white;
        }

        .form-header .icon {
            font-size: 3rem;
            margin-bottom: 1rem;
            color: #fbbf24;
            text-shadow: 0 2px 4px rgba(0,0,0,0.3);
        }

        .form-header h2 {
            font-size: 1.8rem;
            font-weight: 700;
            margin-bottom: 0.5rem;
            text-shadow: 0 2px 4px rgba(0,0,0,0.3);
        }

        .form-header p {
            opacity: 0.9;
            font-size: 1rem;
            line-height: 1.5;
        }

        /* Modern Form Styles */
        .modern-form {
            margin-bottom: 1.5rem;
        }

        .form-group {
            margin-bottom: 1.5rem;
        }

        .form-label {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            color: white;
            font-weight: 600;
            margin-bottom: 0.75rem;
            font-size: 0.95rem;
        }

        .required {
            color: #ef4444;
        }

        .input-wrapper {
            position: relative;
            display: flex;
            align-items: center;
        }

        .form-control {
            background: rgba(255, 255, 255, 0.9);
            border: 1px solid rgba(255, 255, 255, 0.3);
            border-radius: 12px;
            padding: 1rem 1.25rem;
            font-size: 1rem;
            color: #333;
            transition: var(--transition);
            width: 100%;
        }

        .form-control:focus {
            background: rgba(255, 255, 255, 0.95);
            border-color: rgba(102, 126, 234, 0.5);
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
            outline: none;
            transform: scale(1.02);
        }

        .form-control::placeholder {
            color: rgba(0, 0, 0, 0.5);
        }

        .form-control.is-invalid {
            border-color: #ef4444;
            box-shadow: 0 0 0 3px rgba(239, 68, 68, 0.1);
        }

        /* Error Messages */
        .error-message {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            color: #ef4444;
            font-size: 0.85rem;
            margin-top: 0.5rem;
            background: rgba(239, 68, 68, 0.1);
            padding: 0.5rem 0.75rem;
            border-radius: 6px;
            border: 1px solid rgba(239, 68, 68, 0.2);
        }

        /* Alert Styles */
        .alert {
            border-radius: 12px;
            border: none;
            padding: 1rem 1.25rem;
            margin-bottom: 1.5rem;
            backdrop-filter: blur(8px);
            -webkit-backdrop-filter: blur(8px);
            display: flex;
            align-items: center;
            gap: 0.75rem;
            animation: slideInDown 0.5s ease-out;
        }

        @keyframes slideInDown {
            from { opacity: 0; transform: translateY(-20px); }
            to { opacity: 1; transform: translateY(0); }
        }

        .alert-success {
            background: rgba(76, 175, 80, 0.2);
            color: #e8f5e8;
            border: 1px solid rgba(76, 175, 80, 0.3);
        }

        .alert-danger {
            background: rgba(244, 67, 54, 0.2);
            color: #ffebee;
            border: 1px solid rgba(244, 67, 54, 0.3);
        }

        /* Form Actions */
        .form-actions {
            margin-bottom: 1.5rem;
        }

        .btn {
            padding: 1rem 2rem;
            border-radius: 12px;
            font-weight: 600;
            font-size: 1rem;
            border: none;
            cursor: pointer;
            transition: var(--transition);
            position: relative;
            overflow: hidden;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 0.5rem;
            text-decoration: none;
            width: 100%;
        }

        .btn-primary {
            background: var(--primary-gradient);
            color: white;
            box-shadow: 0 4px 15px rgba(102, 126, 234, 0.4);
        }

        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(102, 126, 234, 0.6);
            color: white;
        }

        .btn-primary::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.3), transparent);
            transition: left 0.6s;
        }

        .btn-primary:hover::before {
            left: 100%;
        }

        .btn-loading {
            display: none;
        }

        .btn.loading .btn-text {
            display: none;
        }

        .btn.loading .btn-loading {
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        /* Back Link */
        .back-link {
            text-align: center;
            padding: 1.5rem;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 12px;
            color: rgba(255, 255, 255, 0.9);
            font-size: 0.95rem;
        }

        .back-link a {
            color: #4ade80;
            text-decoration: none;
            font-weight: 600;
            transition: var(--transition);
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
        }

        .back-link a:hover {
            color: #22c55e;
            text-shadow: 0 0 8px rgba(74, 222, 128, 0.5);
        }

        /* Responsive Design */
        @media (max-width: 768px) {
            .main-container {
                padding: 1rem;
            }

            .forgot-password-container {
                padding: 1.5rem;
            }

            .form-header h2 {
                font-size: 1.5rem;
            }
        }

        @media (max-width: 480px) {
            .main-container {
                padding: 0.5rem;
            }

            .forgot-password-container {
                padding: 1rem;
            }

            .btn {
                padding: 0.875rem 1.5rem;
                font-size: 0.9rem;
            }
        }

        /* Enhanced Accessibility */
        @media (prefers-reduced-motion: reduce) {
            * {
                animation-duration: 0.01ms !important;
                animation-iteration-count: 1 !important;
                transition-duration: 0.01ms !important;
            }
        }

        /* Enhanced Focus Management */
        .focus-visible {
            outline: 3px solid #667eea;
            outline-offset: 2px;
            border-radius: 4px;
        }

        /* Loading Animation */
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }

        .fa-spin {
            animation: spin 1s linear infinite;
        }
    </style>
</head>
<body>
    <div class="main-container">
        <!-- Forgot Password Form -->
        <div class="forgot-password-container">
            <div class="form-header">
                <div class="icon">
                    <i class="fas fa-key"></i>
                </div>
                <h2>بازیابی رمز عبور</h2>
                <p>ایمیل خود را وارد کنید تا لینک بازیابی رمز عبور برای شما ارسال شود</p>
            </div>

            @if(session('status'))
                <div class="alert alert-success">
                    <i class="fas fa-check-circle"></i>
                    {{ session('status') }}
                </div>
            @endif

            @if($errors->any())
                <div class="alert alert-danger">
                    <i class="fas fa-exclamation-circle"></i>
                    @foreach($errors->all() as $error)
                        {{ $error }}
                    @endforeach
                </div>
            @endif

            <form action="{{ route('user.password.email') }}" method="POST" id="forgot-password-form" class="modern-form">
                @csrf

                <!-- Email Field -->
                <div class="form-group">
                    <label for="email" class="form-label">
                        <i class="fas fa-envelope"></i>
                        ایمیل
                        <span class="required">*</span>
                    </label>
                    <div class="input-wrapper">
                        <input type="email"
                               name="email"
                               id="email"
                               class="form-control @error('email') is-invalid @enderror"
                               value="{{ old('email') }}"
                               required
                               autocomplete="email"
                               placeholder="ایمیل خود را وارد کنید">
                    </div>
                    @error('email')
                        <div class="error-message">
                            <i class="fas fa-exclamation-triangle"></i>
                            {{ $message }}
                        </div>
                    @enderror
                </div>

                <!-- Submit Button -->
                <div class="form-actions">
                    <button type="submit" class="btn btn-primary" id="submit-btn">
                        <span class="btn-text">
                            <i class="fas fa-paper-plane"></i>
                            ارسال لینک بازیابی
                        </span>
                        <div class="btn-loading">
                            <i class="fas fa-spinner fa-spin"></i>
                            در حال ارسال...
                        </div>
                    </button>
                </div>
            </form>

            <!-- Back Link -->
            <div class="back-link">
                <a href="{{ route('user.login') }}">
                    <i class="fas fa-arrow-right"></i>
                    بازگشت به صفحه ورود
                </a>
            </div>
        </div>
    </div>

    <!-- Scripts -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        class ForgotPasswordForm {
            constructor() {
                this.init();
                this.setupEventListeners();
                this.animatePageLoad();
            }

            init() {
                this.form = document.getElementById('forgot-password-form');
                this.submitBtn = document.getElementById('submit-btn');
                this.emailInput = document.getElementById('email');
                this.isFormValid = false;
            }

            setupEventListeners() {
                // Form validation
                if (this.emailInput) {
                    this.emailInput.addEventListener('input', () => this.validateForm());
                    this.emailInput.addEventListener('blur', () => this.validateEmail());
                }

                // Form submission
                if (this.form) {
                    this.form.addEventListener('submit', (e) => this.handleSubmit(e));
                }

                // Enhanced input interactions
                document.querySelectorAll('.form-control').forEach(input => {
                    input.addEventListener('focus', (e) => this.handleInputFocus(e));
                    input.addEventListener('blur', (e) => this.handleInputBlur(e));
                });
            }

            validateEmail() {
                const email = this.emailInput.value;
                const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;

                if (email && !emailRegex.test(email)) {
                    this.showFieldError(this.emailInput, 'فرمت ایمیل صحیح نیست');
                    return false;
                } else {
                    this.clearFieldError(this.emailInput);
                    return true;
                }
            }

            validateForm() {
                const email = this.emailInput.value;
                const isValid = email.length > 0 && this.validateEmail();

                this.isFormValid = isValid;
                this.submitBtn.disabled = !isValid;

                if (isValid) {
                    this.submitBtn.classList.add('valid');
                } else {
                    this.submitBtn.classList.remove('valid');
                }
            }

            handleInputFocus(e) {
                const wrapper = e.target.closest('.input-wrapper');
                if (wrapper) {
                    wrapper.style.transform = 'scale(1.02)';
                    wrapper.style.transition = 'transform 0.2s ease';
                    wrapper.classList.add('focused');
                }

                e.target.style.boxShadow = '0 0 0 3px rgba(102, 126, 234, 0.2)';
            }

            handleInputBlur(e) {
                const wrapper = e.target.closest('.input-wrapper');
                if (wrapper) {
                    wrapper.style.transform = 'scale(1)';
                    wrapper.classList.remove('focused');
                }

                e.target.style.boxShadow = '';
            }

            handleSubmit(e) {
                if (!this.isFormValid) {
                    e.preventDefault();
                    this.showError('لطفاً ایمیل معتبر وارد کنید');
                    return;
                }

                // Add loading state
                this.submitBtn.classList.add('loading');
                this.submitBtn.disabled = true;

                // Add success animation
                this.addSubmitAnimation();
            }

            showFieldError(input, message) {
                this.clearFieldError(input);

                const errorDiv = document.createElement('div');
                errorDiv.className = 'error-message';
                errorDiv.innerHTML = `<i class="fas fa-exclamation-triangle"></i> ${message}`;

                input.parentElement.parentElement.appendChild(errorDiv);
                input.classList.add('is-invalid');
            }

            clearFieldError(input) {
                const errorDiv = input.parentElement.parentElement.querySelector('.error-message');
                if (errorDiv) {
                    errorDiv.remove();
                }
                input.classList.remove('is-invalid');
            }

            addSubmitAnimation() {
                const ripple = document.createElement('span');
                ripple.style.cssText = `
                    position: absolute;
                    border-radius: 50%;
                    background: rgba(255, 255, 255, 0.6);
                    transform: scale(0);
                    animation: ripple 0.6s linear;
                    pointer-events: none;
                    width: 100px;
                    height: 100px;
                    left: 50%;
                    top: 50%;
                    margin-left: -50px;
                    margin-top: -50px;
                `;

                this.submitBtn.appendChild(ripple);

                setTimeout(() => {
                    ripple.remove();
                }, 600);
            }

            animatePageLoad() {
                const formGroups = document.querySelectorAll('.form-group');
                formGroups.forEach((group, index) => {
                    group.style.opacity = '0';
                    group.style.transform = 'translateY(20px)';

                    setTimeout(() => {
                        group.style.transition = 'all 0.6s cubic-bezier(0.4, 0, 0.2, 1)';
                        group.style.opacity = '1';
                        group.style.transform = 'translateY(0)';
                    }, 200 + (index * 150));
                });
            }

            showError(message) {
                const notification = document.createElement('div');
                notification.className = 'alert alert-danger';
                notification.innerHTML = `<i class="fas fa-exclamation-circle"></i> ${message}`;

                const container = document.querySelector('.forgot-password-container');
                container.insertBefore(notification, container.firstChild);

                setTimeout(() => {
                    notification.remove();
                }, 5000);
            }
        }

        // Initialize when DOM is loaded
        document.addEventListener('DOMContentLoaded', () => {
            new ForgotPasswordForm();
            console.log('🔑 Forgot Password Form initialized');
        });

        // Add CSS animations
        const style = document.createElement('style');
        style.textContent = `
            @keyframes ripple {
                to {
                    transform: scale(4);
                    opacity: 0;
                }
            }
        `;
        document.head.appendChild(style);
    </script>
</body>
</html>
