@props(['locationId', 'limit' => null, 'showFilters' => true, 'showPagination' => true])

@php
$query = \App\Models\Rating::where('title_id', $locationId)
    ->where('status', 'approved')
    ->orderBy('timestamp', 'desc');

// اعمال فیلتر امتیاز
$ratingFilter = request('rating', null);
if ($ratingFilter) {
    $query->where('rating', $ratingFilter);
}

// اعمال فیلتر نوع سفر
$tripTypeFilter = request('trip_type', null);
if ($tripTypeFilter) {
    $query->where('trip_type', $tripTypeFilter);
}

// اعمال محدودیت تعداد
if ($limit) {
    $reviews = $query->take($limit)->get();
    $hasMoreReviews = \App\Models\Rating::where('title_id', $locationId)
        ->where('status', 'approved')
        ->count() > $limit;
} else {
    $reviews = $query->paginate(10);
    $hasMoreReviews = false;
}

// دریافت انواع سفر برای فیلترها
$tripTypes = \App\Models\Rating::where('title_id', $locationId)
    ->where('status', 'approved')
    ->whereNotNull('trip_type')
    ->distinct()
    ->pluck('trip_type')
    ->toArray();
@endphp

<div class="reviews-container">
    @if ($showFilters)
    <div class="review-filters mb-4">
        <div class="card">
            <div class="card-body">
                <form action="{{ request()->url() }}" method="get" class="row g-3">
                    <div class="col-md-4">
                        <label for="rating-filter" class="form-label">{{ __('فیلتر بر اساس امتیاز') }}</label>
                        <select name="rating" id="rating-filter" class="form-select" onchange="this.form.submit()">
                            <option value="">{{ __('همه امتیازات') }}</option>
                            @for ($i = 5; $i >= 1; $i--)
                                <option value="{{ $i }}" {{ request('rating') == $i ? 'selected' : '' }}>
                                    {{ $i }} {{ __('ستاره') }}
                                </option>
                            @endfor
                        </select>
                    </div>
                    
                    @if (!empty($tripTypes))
                    <div class="col-md-4">
                        <label for="trip-type-filter" class="form-label">{{ __('فیلتر بر اساس نوع سفر') }}</label>
                        <select name="trip_type" id="trip-type-filter" class="form-select" onchange="this.form.submit()">
                            <option value="">{{ __('همه انواع سفر') }}</option>
                            @foreach ($tripTypes as $type)
                                <option value="{{ $type }}" {{ request('trip_type') == $type ? 'selected' : '' }}>
                                    {{ __($type) }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    @endif
                    
                    <div class="col-md-4 d-flex align-items-end">
                        @if (request('rating') || request('trip_type'))
                            <a href="{{ request()->url() }}" class="btn btn-outline-secondary">
                                {{ __('حذف فیلترها') }}
                            </a>
                        @endif
                    </div>
                </form>
            </div>
        </div>
    </div>
    @endif
    
    @if ($reviews->count() > 0)
        <div class="reviews-list">
            @foreach ($reviews as $review)
                <div class="review-item card mb-3">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <div>
                            <strong>{{ $review->name }}</strong>
                            @if (!empty($review->trip_type))
                                <span class="badge bg-secondary ms-2">{{ __($review->trip_type) }}</span>
                            @endif
                            <small class="text-muted me-2">
                                {{ $review->timestamp->format('Y/m/d') }}
                            </small>
                        </div>
                        <div class="review-rating">
                            @for ($i = 1; $i <= 5; $i++)
                                @if ($i <= $review->rating)
                                    <i class="fas fa-star text-warning"></i>
                                @else
                                    <i class="far fa-star text-warning"></i>
                                @endif
                            @endfor
                        </div>
                    </div>
                    <div class="card-body">
                        @if (!empty($review->positive_comment))
                            <p class="text-success small mb-2">
                                <i class="fas fa-plus-circle me-1"></i> {{ __('نکات مثبت') }}:
                                {!! $review->positive_comment_html ?? $review->positive_comment !!}
                            </p>
                        @endif
                        
                        @if (!empty($review->negative_comment))
                            <p class="text-danger small mb-0">
                                <i class="fas fa-minus-circle me-1"></i> {{ __('نکات منفی') }}:
                                {!! $review->negative_comment_html ?? $review->negative_comment !!}
                            </p>
                        @endif
                        
                        @if (!empty($review->comment))
                            <p class="mt-3 mb-0">
                                {{ $review->comment }}
                            </p>
                        @endif
                        
                        @if (!empty($review->service_rating) || !empty($review->cleanliness_rating) || !empty($review->location_rating) || !empty($review->value_rating))
                            <div class="detailed-ratings mt-3">
                                <div class="row g-2">
                                    @if (!empty($review->service_rating))
                                        <div class="col-md-3 col-6">
                                            <small>{{ __('خدمات') }}: {{ $review->service_rating }}/5</small>
                                            <div class="progress" style="height: 5px;">
                                                <div class="progress-bar" role="progressbar" style="width: {{ ($review->service_rating/5)*100 }}%" aria-valuenow="{{ $review->service_rating }}" aria-valuemin="0" aria-valuemax="5"></div>
                                            </div>
                                        </div>
                                    @endif
                                    
                                    @if (!empty($review->cleanliness_rating))
                                        <div class="col-md-3 col-6">
                                            <small>{{ __('نظافت') }}: {{ $review->cleanliness_rating }}/5</small>
                                            <div class="progress" style="height: 5px;">
                                                <div class="progress-bar" role="progressbar" style="width: {{ ($review->cleanliness_rating/5)*100 }}%" aria-valuenow="{{ $review->cleanliness_rating }}" aria-valuemin="0" aria-valuemax="5"></div>
                                            </div>
                                        </div>
                                    @endif
                                    
                                    @if (!empty($review->location_rating))
                                        <div class="col-md-3 col-6">
                                            <small>{{ __('موقعیت') }}: {{ $review->location_rating }}/5</small>
                                            <div class="progress" style="height: 5px;">
                                                <div class="progress-bar" role="progressbar" style="width: {{ ($review->location_rating/5)*100 }}%" aria-valuenow="{{ $review->location_rating }}" aria-valuemin="0" aria-valuemax="5"></div>
                                            </div>
                                        </div>
                                    @endif
                                    
                                    @if (!empty($review->value_rating))
                                        <div class="col-md-3 col-6">
                                            <small>{{ __('ارزش') }}: {{ $review->value_rating }}/5</small>
                                            <div class="progress" style="height: 5px;">
                                                <div class="progress-bar" role="progressbar" style="width: {{ ($review->value_rating/5)*100 }}%" aria-valuenow="{{ $review->value_rating }}" aria-valuemin="0" aria-valuemax="5"></div>
                                            </div>
                                        </div>
                                    @endif
                                </div>
                            </div>
                        @endif
                    </div>
                </div>
            @endforeach
        </div>
        
        @if ($limit && $hasMoreReviews)
            <div class="text-center mt-4">
                <a href="{{ route('reviews.index', ['location_id' => $locationId]) }}" class="btn btn-outline-primary">
                    {{ __('مشاهده همه نظرات') }}
                </a>
            </div>
        @elseif ($showPagination && !$limit)
            <div class="d-flex justify-content-center mt-4">
                {{ $reviews->links() }}
            </div>
        @endif
    @else
        <div class="alert alert-info text-center">
            {{ __('هنوز نظری برای این مکان ثبت نشده است.') }}
            <a href="{{ route('reviews.create', ['location_id' => $locationId]) }}" class="alert-link">
                {{ __('اولین نظر را شما ثبت کنید!') }}
            </a>
        </div>
    @endif
</div> 