@props(['locationId', 'size' => 'medium'])

@php
// محاسبه میانگین امتیازات
$avgRating = 0;
$totalRatings = 0;
$ratingStats = [
    5 => 0,
    4 => 0,
    3 => 0,
    2 => 0,
    1 => 0
];

$location = \App\Models\Location::find($locationId);
if ($location) {
    $ratings = \App\Models\Rating::where('title_id', $location->title_id)
        ->where('status', 'approved')
        ->get();

    if ($ratings->count() > 0) {
        $totalRatings = $ratings->count();
        $sumRatings = $ratings->sum('rating');
        $avgRating = $totalRatings > 0 ? round($sumRatings / $totalRatings, 1) : 0;
        
        // محاسبه آمار امتیازات
        foreach ($ratings as $rating) {
            $ratingValue = (int)$rating->rating;
            if (isset($ratingStats[$ratingValue])) {
                $ratingStats[$ratingValue]++;
            }
        }
    }
}

// سایز ویجت
$containerClass = '';
$starsSize = '';
$numberSize = '';

switch ($size) {
    case 'small':
        $containerClass = 'rating-widget-small';
        $starsSize = 'fs-6';
        $numberSize = 'fs-5';
        break;
    case 'large':
        $containerClass = 'rating-widget-large';
        $starsSize = 'fs-4';
        $numberSize = 'fs-2';
        break;
    default: // medium
        $containerClass = 'rating-widget-medium';
        $starsSize = 'fs-5';
        $numberSize = 'fs-4';
}
@endphp

<div class="rating-widget {{ $containerClass }}">
    <div class="rating-header d-flex align-items-center mb-3 justify-content-between">
        <div>
            <div class="rating-number {{ $numberSize }} fw-bold">{{ $avgRating }}</div>
            <div class="rating-stars {{ $starsSize }}">
                <div class="rating-display" data-rating="{{ $avgRating }}">
                    @for ($i = 1; $i <= 5; $i++)
                        @if ($i <= floor($avgRating))
                            <i class="fas fa-star text-warning star-icon"></i>
                        @elseif ($i - 0.5 <= $avgRating)
                            <i class="fas fa-star-half-alt text-warning star-icon"></i>
                        @else
                            <i class="far fa-star text-warning star-icon"></i>
                        @endif
                    @endfor
                </div>
            </div>
        </div>
        <div class="text-end">
            <div class="rating-count fs-6">{{ $totalRatings }} {{ __('نظر') }}</div>
            @if ($totalRatings > 0)
                <div class="rating-footer mt-1">
                    <a href="{{ route('reviews.index', ['location_id' => $locationId]) }}" class="text-decoration-none small">
                        {{ __('مشاهده همه') }} <i class="fas fa-chevron-left fa-xs"></i>
                    </a>
                </div>
            @endif
        </div>
    </div>
    
    @if ($totalRatings > 0)
        <div class="rating-distribution mb-3">
            @foreach (array_reverse($ratingStats) as $stars => $count)
                <div class="rating-bar d-flex align-items-center mb-1">
                    <div class="stars me-2 small" style="width: 45px;">{{ $stars }} {{ __('ستاره') }}</div>
                    <div class="progress flex-grow-1" style="height: 8px;">
                        @php $percentage = $totalRatings > 0 ? ($count / $totalRatings) * 100 : 0; @endphp
                        <div class="progress-bar bg-warning" role="progressbar" style="width: {{ $percentage }}%" 
                            aria-valuenow="{{ $percentage }}" aria-valuemin="0" aria-valuemax="100"></div>
                    </div>
                    <div class="count ms-2 small text-muted">{{ $count }}</div>
                </div>
            @endforeach
        </div>
    @endif
    
    <div class="rating-actions">
        <a href="{{ route('reviews.create', ['location_id' => $locationId]) }}" class="btn btn-sm btn-primary w-100">
            <i class="fas fa-star me-1"></i> {{ __('ثبت نظر جدید') }}
        </a>
    </div>
</div>

@once
    @push('styles')
    <style>
        .rating-widget {
            background-color: #fff;
            border-radius: 8px;
            padding: 15px;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
        }
        
        .rating-widget-small {
            padding: 10px;
        }
        
        .rating-widget-large {
            padding: 20px;
        }
        
        .rating-stars {
            display: flex;
            align-items: center;
            direction: ltr;
        }
        
        .rating-bar .progress {
            border-radius: 4px;
            background-color: rgba(0, 0, 0, 0.05);
        }
        
        .rating-bar .stars {
            font-size: 0.8rem;
            color: #6c757d;
        }
        
        .rating-actions .btn {
            border-radius: 6px;
            padding: 8px 12px;
            transition: all 0.3s ease;
        }
        
        .rating-actions .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }
    </style>
    @endpush
@endonce 