{{-- کامپوننت فیلتر جغرافیایی قابل استفاده مجدد --}}
@props(['countries' => collect(), 'showTitle' => true])

<div class="card shadow mb-4">
    <div class="card-body">
        @if($showTitle)
            <h6 class="fw-bold mb-3">فیلتر بر اساس موقعیت جغرافیایی</h6>
        @endif
        
        <form id="geographic-filter-form">
            <div class="row">
                <div class="col-6 col-lg-2 mb-3">
                    @php
                        $countryCount = $countries->count();
                        $locale = app()->getLocale();
                        $labels = [
                            'fa' => 'کشور',
                            'en' => 'Country',
                            'ar' => 'البلد',
                            'tr' => 'Ülke',
                            'de' => 'Land',
                            'fr' => 'Pays',
                            'es' => 'País',
                            'it' => 'Paese',
                            'ru' => 'Страна',
                            'zh' => '国家',
                            'ja' => '国',
                            'ko' => '국가',
                            'hi' => 'देश',
                            'pt' => 'País',
                            'nl' => 'Land',
                            'sv' => 'Land',
                            'no' => 'Land',
                            'da' => 'Land',
                            'fi' => 'Maa',
                            'pl' => 'Kraj',
                            'cs' => 'Země',
                            'sk' => 'Krajina',
                            'hu' => 'Ország',
                            'ro' => 'Țară',
                            'bg' => 'Страна',
                            'hr' => 'Zemlja',
                            'sr' => 'Земља',
                            'sl' => 'Država',
                            'et' => 'Riik',
                            'lv' => 'Valsts',
                            'lt' => 'Šalis',
                            'mt' => 'Pajjiż',
                            'cy' => 'Gwlad',
                            'ga' => 'Tír',
                            'gd' => 'Dùthaich',
                            'br' => 'Bro',
                            'eu' => 'Herrialdea',
                            'ca' => 'País',
                            'gl' => 'País',
                            'oc' => 'País',
                            'co' => 'Paese',
                            'sc' => 'Paesi',
                            'rm' => 'Pajais',
                            'fur' => 'Paîs',
                            'lij' => 'Paize',
                            'vec' => 'Paexe',
                            'pms' => 'Pais',
                            'lmo' => 'Paes',
                            'eml' => 'Paes',
                            'rgn' => 'Paes',
                            'nap' => 'Paese',
                            'scn' => 'Paisi',
                            'sdc' => 'Paesi',
                            'roa-tara' => 'Paese',
                            'lld' => 'Paes',
                            'frp' => 'Payis',
                            'wa' => 'Payis',
                            'pcd' => 'Payis',
                            'nrm' => 'Payis',
                            'ksh' => 'Land',
                            'li' => 'Land',
                            'vls' => 'Land',
                            'zea' => 'Land',
                            'fy' => 'Lân',
                            'stq' => 'Lound',
                            'nds' => 'Land',
                            'bar' => 'Land',
                            'als' => 'Land',
                            'gsw' => 'Land',
                            'wym' => 'Land',
                            'hsb' => 'Kraj',
                            'dsb' => 'Kraj',
                            'csb' => 'Kraj',
                            'szl' => 'Kraj'
                        ];
                        $label = $labels[$locale] ?? $labels['fa'];
                    @endphp
                    <label for="country-select" class="form-label">
                        {{ __('messages.country') }} ({{ $countryCount }})
                    </label>
                    <select class="form-select geo-select country-flag-select" id="country-select" name="country">
                        <option value="">{{ __('messages.all_countries') }}</option>
                        @foreach($countries as $country)
                            <option value="{{ $country->id }}"
                                data-flag-url="https://flagcdn.com/24x18/{{ strtolower($country->iso_code) }}.png"
                                data-name="{{ $country->name }}"
                                data-count="{{ $country->location_count }}">
                                {{ $country->name }} ({{ number_format($country->location_count, 0, '.', ',') }})
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-6 col-lg-2 mb-3 geo-step" id="province-container" style="display: none;">
                    <label for="province-select" class="form-label">{{ __('messages.province') }}</label>
                    <select class="form-select geo-select" id="province-select" name="province">
                        <option value="">{{ __('messages.all_provinces') }}</option>
                    </select>
                </div>
                <div class="col-6 col-lg-2 mb-3 geo-step" id="county-container" style="display: none;">
                    <label for="county-select" class="form-label">{{ __('messages.county') }}</label>
                    <select class="form-select geo-select" id="county-select" name="county">
                        <option value="">{{ __('messages.all_counties') }}</option>
                    </select>
                </div>
                <div class="col-6 col-lg-2 mb-3 geo-step" id="district-container" style="display: none;">
                    <label for="district-select" class="form-label">{{ __('messages.district') }}</label>
                    <select class="form-select geo-select" id="district-select" name="district">
                        <option value="">{{ __('messages.all_districts') }}</option>
                    </select>
                </div>
                <div class="col-6 col-lg-2 mb-3 geo-step" id="city-container" style="display: none;">
                    <label for="city-select" class="form-label">{{ __('messages.city') }}</label>
                    <select class="form-select geo-select" id="city-select" name="city">
                        <option value="">{{ __('messages.all_cities') }}</option>
                    </select>
                </div>
                <div class="col-6 col-lg-2 mb-3 geo-step" id="village-container" style="display: none;">
                    <label for="village-select" class="form-label">{{ __('messages.village') }}</label>
                    <select class="form-select geo-select" id="village-select" name="village">
                        <option value="">{{ __('messages.all_villages') }}</option>
                    </select>
                </div>
                <div class="col-6 col-lg-2 mb-3 geo-step" id="zone-container" style="display: none;">
                    <label for="zone-select" class="form-label">{{ __('messages.zone') }}</label>
                    <select class="form-select geo-select" id="zone-select" name="zone">
                        <option value="">{{ __('messages.all_zones') }}</option>
                    </select>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12 mt-3">
                    <button type="button" id="reset-geographic-filters" class="btn btn-secondary">
                        <i class="fas fa-redo me-1"></i>
                        {{ __('messages.reset_filters') }}
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>

@push('scripts')
<script>
// متغیرهای سراسری برای فیلترهای جغرافیایی
let activeGeoFilters = {
    country: '',
    province: '',
    county: '',
    district: '',
    city: '',
    village: '',
    zone: ''
};

// تابع ریست کردن کانتینرهای جغرافیایی
function resetGeoContainers() {
    const containers = ['province-container', 'county-container', 'district-container', 'city-container', 'village-container', 'zone-container'];
    containers.forEach(containerId => {
        const container = document.getElementById(containerId);
        if (container) {
            container.style.display = 'none';
            const select = container.querySelector('select');
            if (select) {
                select.innerHTML = `<option value="">${select.querySelector('option').textContent}</option>`;
            }
        }
    });
}

// تابع ریست کردن یک select
function resetSelect(selectId) {
    const select = document.getElementById(selectId);
    if (select) {
        const firstOption = select.querySelector('option');
        select.innerHTML = firstOption ? firstOption.outerHTML : '<option value="">انتخاب کنید</option>';
    }
}

// تابع دریافت استان‌ها بر اساس کشور
function fetchProvincesByCountry(countryId) {
    fetch(`/api/countries/${countryId}/provinces`)
        .then(response => response.json())
        .then(data => {
            const select = document.getElementById('province-select');
            select.innerHTML = `<option value="">{{ __('messages.all_provinces') }}</option>`;
            
            if (data.success && data.data) {
                data.data.forEach(province => {
                    const option = document.createElement('option');
                    option.value = province.id;
                    option.textContent = `${province.name} (${province.location_count || 0})`;
                    select.appendChild(option);
                });
            }
        })
        .catch(error => {
            console.error('خطا در دریافت استان‌ها:', error);
        });
}

// تابع دریافت شهرستان‌ها بر اساس استان
function fetchCountiesByProvince(provinceId) {
    fetch(`/api/provinces/${provinceId}/counties`)
        .then(response => response.json())
        .then(data => {
            const select = document.getElementById('county-select');
            select.innerHTML = `<option value="">{{ __('messages.all_counties') }}</option>`;
            
            if (data.success && data.data) {
                data.data.forEach(county => {
                    const option = document.createElement('option');
                    option.value = county.id;
                    option.textContent = `${county.name} (${county.location_count || 0})`;
                    select.appendChild(option);
                });
            }
        })
        .catch(error => {
            console.error('خطا در دریافت شهرستان‌ها:', error);
        });
}

// تابع دریافت بخش‌ها بر اساس شهرستان
function fetchDistrictsByCounty(countyId) {
    fetch(`/api/counties/${countyId}/districts`)
        .then(response => response.json())
        .then(data => {
            const select = document.getElementById('district-select');
            select.innerHTML = `<option value="">{{ __('messages.all_districts') }}</option>`;
            
            if (data.success && data.data) {
                data.data.forEach(district => {
                    const option = document.createElement('option');
                    option.value = district.id;
                    option.textContent = `${district.name} (${district.location_count || 0})`;
                    select.appendChild(option);
                });
            }
        })
        .catch(error => {
            console.error('خطا در دریافت بخش‌ها:', error);
        });
}

// تابع دریافت شهرها بر اساس بخش
function fetchCitiesByDistrict(districtId) {
    fetch(`/api/districts/${districtId}/cities`)
        .then(response => response.json())
        .then(data => {
            const select = document.getElementById('city-select');
            select.innerHTML = `<option value="">{{ __('messages.all_cities') }}</option>`;
            
            if (data.success && data.data) {
                data.data.forEach(city => {
                    const option = document.createElement('option');
                    option.value = city.id;
                    option.textContent = `${city.name} (${city.location_count || 0})`;
                    select.appendChild(option);
                });
            }
        })
        .catch(error => {
            console.error('خطا در دریافت شهرها:', error);
        });
}

// تابع دریافت روستاها بر اساس شهر
function fetchVillagesByCity(cityId) {
    fetch(`/api/cities/${cityId}/villages`)
        .then(response => response.json())
        .then(data => {
            const select = document.getElementById('village-select');
            select.innerHTML = `<option value="">{{ __('messages.all_villages') }}</option>`;
            
            if (data.success && data.data) {
                data.data.forEach(village => {
                    const option = document.createElement('option');
                    option.value = village.id;
                    option.textContent = `${village.name} (${village.location_count || 0})`;
                    select.appendChild(option);
                });
            }
        })
        .catch(error => {
            console.error('خطا در دریافت روستاها:', error);
        });
}

// تابع دریافت مناطق بر اساس کشور
function fetchZonesByCountry(countryId) {
    fetch(`/api/countries/${countryId}/zones`)
        .then(response => response.json())
        .then(data => {
            const select = document.getElementById('zone-select');
            select.innerHTML = `<option value="">{{ __('messages.all_zones') }}</option>`;
            
            if (data.success && data.data) {
                data.data.forEach(zone => {
                    const option = document.createElement('option');
                    option.value = zone.id;
                    option.textContent = `${zone.name} (${zone.location_count || 0})`;
                    select.appendChild(option);
                });
            }
        })
        .catch(error => {
            console.error('خطا در دریافت مناطق:', error);
        });
}

// رویدادهای فیلتر جغرافیایی
document.addEventListener('DOMContentLoaded', function() {
    // رویداد کشور
    const countrySelect = document.getElementById('country-select');
    if (countrySelect) {
        countrySelect.addEventListener('change', function() {
            const countryId = this.value;
            activeGeoFilters.country = countryId;
            
            // ریست کردن فیلترهای وابسته
            activeGeoFilters.province = '';
            activeGeoFilters.county = '';
            activeGeoFilters.district = '';
            activeGeoFilters.city = '';
            activeGeoFilters.village = '';
            activeGeoFilters.zone = '';
            
            resetGeoContainers();
            
            if (countryId) {
                document.getElementById('province-container').style.display = 'block';
                document.getElementById('zone-container').style.display = 'block';
                fetchProvincesByCountry(countryId);
                fetchZonesByCountry(countryId);
            }
            
            // فراخوانی تابع به‌روزرسانی نتایج (باید در صفحه والد تعریف شود)
            if (typeof updateResults === 'function') {
                updateResults();
            }
        });
    }
    
    // رویداد استان
    const provinceSelect = document.getElementById('province-select');
    if (provinceSelect) {
        provinceSelect.addEventListener('change', function() {
            const provinceId = this.value;
            activeGeoFilters.province = provinceId;
            
            // ریست کردن فیلترهای وابسته
            activeGeoFilters.county = '';
            activeGeoFilters.district = '';
            activeGeoFilters.city = '';
            activeGeoFilters.village = '';
            
            // مخفی کردن کانتینرهای وابسته
            ['county-container', 'district-container', 'city-container', 'village-container'].forEach(id => {
                document.getElementById(id).style.display = 'none';
            });
            
            if (provinceId) {
                document.getElementById('county-container').style.display = 'block';
                fetchCountiesByProvince(provinceId);
            }
            
            if (typeof updateResults === 'function') {
                updateResults();
            }
        });
    }
    
    // رویداد شهرستان
    const countySelect = document.getElementById('county-select');
    if (countySelect) {
        countySelect.addEventListener('change', function() {
            const countyId = this.value;
            activeGeoFilters.county = countyId;
            
            // ریست کردن فیلترهای وابسته
            activeGeoFilters.district = '';
            activeGeoFilters.city = '';
            activeGeoFilters.village = '';
            
            // مخفی کردن کانتینرهای وابسته
            ['district-container', 'city-container', 'village-container'].forEach(id => {
                document.getElementById(id).style.display = 'none';
            });
            
            if (countyId) {
                document.getElementById('district-container').style.display = 'block';
                fetchDistrictsByCounty(countyId);
            }
            
            if (typeof updateResults === 'function') {
                updateResults();
            }
        });
    }
    
    // رویداد بخش
    const districtSelect = document.getElementById('district-select');
    if (districtSelect) {
        districtSelect.addEventListener('change', function() {
            const districtId = this.value;
            activeGeoFilters.district = districtId;
            
            // ریست کردن فیلترهای وابسته
            activeGeoFilters.city = '';
            activeGeoFilters.village = '';
            
            // مخفی کردن کانتینرهای وابسته
            ['city-container', 'village-container'].forEach(id => {
                document.getElementById(id).style.display = 'none';
            });
            
            if (districtId) {
                document.getElementById('city-container').style.display = 'block';
                fetchCitiesByDistrict(districtId);
            }
            
            if (typeof updateResults === 'function') {
                updateResults();
            }
        });
    }
    
    // رویداد شهر
    const citySelect = document.getElementById('city-select');
    if (citySelect) {
        citySelect.addEventListener('change', function() {
            const cityId = this.value;
            activeGeoFilters.city = cityId;
            
            // ریست کردن فیلترهای وابسته
            activeGeoFilters.village = '';
            
            // مخفی کردن کانتینرهای وابسته
            document.getElementById('village-container').style.display = 'none';
            
            if (cityId) {
                document.getElementById('village-container').style.display = 'block';
                fetchVillagesByCity(cityId);
            }
            
            if (typeof updateResults === 'function') {
                updateResults();
            }
        });
    }
    
    // رویداد روستا
    const villageSelect = document.getElementById('village-select');
    if (villageSelect) {
        villageSelect.addEventListener('change', function() {
            const villageId = this.value;
            activeGeoFilters.village = villageId;
            
            if (typeof updateResults === 'function') {
                updateResults();
            }
        });
    }
    
    // رویداد منطقه
    const zoneSelect = document.getElementById('zone-select');
    if (zoneSelect) {
        zoneSelect.addEventListener('change', function() {
            const zoneId = this.value;
            activeGeoFilters.zone = zoneId;
            
            if (typeof updateResults === 'function') {
                updateResults();
            }
        });
    }
    
    // رویداد ریست فیلترها
    const resetButton = document.getElementById('reset-geographic-filters');
    if (resetButton) {
        resetButton.addEventListener('click', function() {
            // ریست کردن همه فیلترها
            Object.keys(activeGeoFilters).forEach(key => {
                activeGeoFilters[key] = '';
            });
            
            // ریست کردن select کشور
            document.getElementById('country-select').value = '';
            
            // مخفی کردن و ریست کردن همه کانتینرها
            resetGeoContainers();
            
            if (typeof updateResults === 'function') {
                updateResults();
            }
        });
    }
});
</script>
@endpush

@push('styles')
<style>
.geo-select {
    transition: all 0.3s ease;
}

.geo-step {
    opacity: 0.7;
    transition: opacity 0.3s ease;
}

.geo-step:not([style*="display: none"]) {
    opacity: 1;
}

.country-flag-select option {
    padding-left: 30px;
    background-repeat: no-repeat;
    background-position: 8px center;
    background-size: 20px 15px;
}
</style>
@endpush