@props(['position', 'limit' => 1, 'class' => ''])

@php
$ads = isset($adsByPosition[$position]) ? $adsByPosition[$position]->take($limit) : collect([]);
@endphp

@if($ads->count() > 0)
    <div class="advertisement-container {{ $class }}">
        @foreach($ads as $ad)
            <div class="advertisement-item mb-3" data-ad-id="{{ $ad->id }}">
                @if($ad->ad_type == 'banner' && $ad->image_path)
                    <a href="{{ route('ad.click', $ad->id) }}" target="_blank" onclick="trackAdView({{ $ad->id }})">
                        <img src="{{ asset('storage/' . $ad->image_path) }}" 
                            alt="{{ $ad->title }}" 
                            class="img-fluid ad-image"
                            @if($ad->size)
                                style="width: {{ explode('x', $ad->size)[0] }}px; height: {{ explode('x', $ad->size)[1] }}px;"
                            @endif
                        >
                    </a>
                @elseif($ad->ad_type == 'html' && $ad->html_content)
                    <div class="ad-html-content" onclick="trackAdView({{ $ad->id }})">
                        {!! $ad->html_content !!}
                    </div>
                @elseif($ad->ad_type == 'text')
                    <div class="ad-text-content">
                        <a href="{{ route('ad.click', $ad->id) }}" target="_blank" onclick="trackAdView({{ $ad->id }})">
                            <h4>{{ $ad->title }}</h4>
                            <p>{{ $ad->html_content }}</p>
                        </a>
                    </div>
                @elseif($ad->ad_type == 'video' && $ad->html_content)
                    <div class="ad-video-content" onclick="trackAdView({{ $ad->id }})">
                        <div class="text-center">
                            <h5 class="mb-2">{{ $ad->title }}</h5>
                            <div class="embed-responsive embed-responsive-16by9">
                                {!! $ad->html_content !!}
                            </div>
                            @if($ad->target_url)
                                <div class="mt-2">
                                    <a href="{{ route('ad.click', $ad->id) }}" target="_blank" class="btn btn-sm btn-primary">
                                        مشاهده بیشتر
                                    </a>
                                </div>
                            @endif
                        </div>
                    </div>
                @elseif($ad->ad_type == 'slider' && $ad->image_path)
                    <div class="ad-slider-content" onclick="trackAdView({{ $ad->id }})">
                        <div id="ad-slider-{{ $ad->id }}" class="carousel slide" data-ride="carousel">
                            <div class="carousel-inner">
                                <div class="carousel-item active">
                                    <img src="{{ asset('storage/' . $ad->image_path) }}" class="d-block w-100" alt="{{ $ad->title }}">
                                    <div class="carousel-caption d-none d-md-block">
                                        <h5>{{ $ad->title }}</h5>
                                    </div>
                                </div>
                                @if($ad->html_content)
                                    @php
                                        $extraImages = json_decode($ad->html_content, true);
                                    @endphp
                                    @if(is_array($extraImages))
                                        @foreach($extraImages as $index => $image)
                                            <div class="carousel-item">
                                                <img src="{{ asset('storage/' . $image['path']) }}" class="d-block w-100" alt="{{ $image['title'] ?? $ad->title }}">
                                                <div class="carousel-caption d-none d-md-block">
                                                    <h5>{{ $image['title'] ?? $ad->title }}</h5>
                                                </div>
                                            </div>
                                        @endforeach
                                    @endif
                                @endif
                            </div>
                            <a class="carousel-control-prev" href="#ad-slider-{{ $ad->id }}" role="button" data-slide="prev">
                                <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                                <span class="sr-only">قبلی</span>
                            </a>
                            <a class="carousel-control-next" href="#ad-slider-{{ $ad->id }}" role="button" data-slide="next">
                                <span class="carousel-control-next-icon" aria-hidden="true"></span>
                                <span class="sr-only">بعدی</span>
                            </a>
                        </div>
                    </div>
                @elseif($ad->ad_type == 'featured')
                    <div class="ad-featured-content p-3 bg-light border rounded">
                        <div class="text-center">
                            @if($ad->image_path)
                                <img src="{{ asset('storage/' . $ad->image_path) }}" 
                                    alt="{{ $ad->title }}" 
                                    class="img-fluid mb-2"
                                    style="max-height: 150px;"
                                >
                            @endif
                            <h4 class="text-primary">{{ $ad->title }}</h4>
                            @if($ad->html_content)
                                <div class="my-2">{!! $ad->html_content !!}</div>
                            @endif
                            @if($ad->target_url)
                                <a href="{{ route('ad.click', $ad->id) }}" class="btn btn-primary mt-2" target="_blank" onclick="trackAdView({{ $ad->id }})">
                                    مشاهده بیشتر
                                </a>
                            @endif
                        </div>
                    </div>
                @elseif($ad->ad_type == 'popup')
                    <script>
                        document.addEventListener('DOMContentLoaded', function() {
                            setTimeout(function() {
                                showPopupAdInline({{ $ad->id }}, '{{ $ad->title }}', '{{ asset('storage/' . $ad->image_path) }}', '{!! addslashes($ad->html_content) !!}', '{{ $ad->target_url }}', '{{ $ad->ad_type }}');
                            }, 3000);
                        });

                        function showPopupAdInline(id, title, imagePath, htmlContent, targetUrl, adType) {
                            const container = document.createElement('div');
                            container.className = 'popup-ad-overlay';
                            container.setAttribute('data-ad-id', id);

                            let content = `
                                <div class="popup-ad-container">
                                    <div class="popup-ad-header">
                                        <h5>${title}</h5>
                                        <button class="popup-ad-close">&times;</button>
                                    </div>
                                    <div class="popup-ad-body">`;
                            
                            if (adType === 'banner' && imagePath) {
                                content += `
                                    <a href="{{ url('/ad/click') }}/${id}" target="_blank">
                                        <img src="${imagePath}" alt="${title}" class="img-fluid">
                                    </a>`;
                            } else if (htmlContent) {
                                content += htmlContent;
                            }
                            
                            content += `
                                    </div>
                                </div>
                            `;

                            container.innerHTML = content;
                            document.body.appendChild(container);

                            // Track view
                            trackAdView(id);

                            // Add event listener to close button
                            container.querySelector('.popup-ad-close').addEventListener('click', function() {
                                document.body.removeChild(container);
                            });
                        }
                    </script>
                    <style>
                        .popup-ad-overlay {
                            position: fixed;
                            top: 0;
                            left: 0;
                            width: 100%;
                            height: 100%;
                            background-color: rgba(0, 0, 0, 0.7);
                            display: flex;
                            justify-content: center;
                            align-items: center;
                            z-index: 9999;
                        }
                        .popup-ad-container {
                            background-color: white;
                            border-radius: 5px;
                            max-width: 90%;
                            max-height: 90%;
                            overflow: auto;
                            box-shadow: 0 0 20px rgba(0, 0, 0, 0.5);
                        }
                        .popup-ad-header {
                            display: flex;
                            justify-content: space-between;
                            align-items: center;
                            padding: 10px 15px;
                            background-color: #f8f9fa;
                            border-bottom: 1px solid #dee2e6;
                        }
                        .popup-ad-close {
                            background: none;
                            border: none;
                            font-size: 24px;
                            cursor: pointer;
                            color: #6c757d;
                        }
                        .popup-ad-body {
                            padding: 15px;
                        }
                    </style>
                @endif
            </div>
        @endforeach
    </div>
    
    <script>
        function trackAdView(adId) {
            fetch('/ad/view/' + adId, {
                method: 'GET',
                headers: {
                    'X-Requested-With': 'XMLHttpRequest',
                    'Accept': 'application/json'
                }
            });
        }
        
        document.addEventListener('DOMContentLoaded', function() {
            // Track views for displayed ads
            document.querySelectorAll('.advertisement-item').forEach(function(item) {
                const adId = item.getAttribute('data-ad-id');
                if (adId) {
                    trackAdView(adId);
                }
            });
        });
    </script>
@endif 