@extends('admin.layouts.app')

@section('title', 'آمار بازدیدها')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">آمار بازدیدها</h3>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">بازدیدها در 30 روز گذشته</h3>
                                </div>
                                <div class="card-body">
                                    <canvas id="visitsByDayChart"></canvas>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">توزیع بازدیدها بر اساس ساعت</h3>
                                </div>
                                <div class="card-body">
                                    <canvas id="visitsByHourChart"></canvas>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script src="{{ asset('js/locale-date-manager.js') }}"></script>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // نمودار بازدیدها بر اساس روز
    const visitsByDayCtx = document.getElementById('visitsByDayChart').getContext('2d');
    const visitsByDayData = @json($visitsByDay);
    const locale = document.documentElement.lang || 'fa';

    // فرمت کردن برچسب‌ها بر اساس زبان
    const formatLabels = (data) => {
        return data.map(item => {
            if (window.localeDateManager) {
                return window.localeDateManager.formatDateForChart(item.date);
            } else {
                // Fallback
                const date = new Date(item.date);
                if (locale === 'fa') {
                    return jdate(date).format('Y/m/d');
                } else {
                    return date.toLocaleDateString(locale);
                }
            }
        });
    };

    // فرمت کردن اعداد بر اساس زبان
    const formatNumbers = (data) => {
        return data.map(item => {
            if (window.localeDateManager && locale === 'fa') {
                return parseInt(window.localeDateManager.toPersianNumbers(item.count.toString()));
            }
            return item.count;
        });
    };

    new Chart(visitsByDayCtx, {
        type: 'line',
        data: {
            labels: formatLabels(visitsByDayData),
            datasets: [{
                label: locale === 'fa' ? 'تعداد بازدید' : 'Visits Count',
                data: visitsByDayData.map(item => item.count),
                borderColor: 'rgb(75, 192, 192)',
                backgroundColor: 'rgba(75, 192, 192, 0.1)',
                tension: 0.1,
                fill: true
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: {
                    position: 'top',
                    rtl: locale === 'fa'
                },
                title: {
                    display: true,
                    text: locale === 'fa' ? 'نمودار بازدیدها در ۳۰ روز گذشته' : 'Visits Chart - Last 30 Days'
                },
                tooltip: {
                    callbacks: {
                        label: function(context) {
                            const value = context.parsed.y;
                            const formattedValue = window.localeDateManager && locale === 'fa' ?
                                window.localeDateManager.toPersianNumbers(value.toString()) : value;
                            return `${context.dataset.label}: ${formattedValue}`;
                        }
                    }
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        callback: function(value) {
                            return window.localeDateManager && locale === 'fa' ?
                                window.localeDateManager.toPersianNumbers(value.toString()) : value;
                        }
                    }
                }
            }
        }
    });
});

    // نمودار بازدیدها بر اساس ساعت
    const visitsByHourCtx = document.getElementById('visitsByHourChart').getContext('2d');
    const visitsByHourData = @json($visitsByHour);

    new Chart(visitsByHourCtx, {
        type: 'bar',
        data: {
            labels: visitsByHourData.map(item => {
                const hour = window.localeDateManager && locale === 'fa' ?
                    window.localeDateManager.toPersianNumbers(item.hour.toString()) : item.hour;
                return hour + ':00';
            }),
            datasets: [{
                label: locale === 'fa' ? 'تعداد بازدید' : 'Visits Count',
                data: visitsByHourData.map(item => item.count),
                backgroundColor: 'rgba(54, 162, 235, 0.7)',
                borderColor: 'rgba(54, 162, 235, 1)',
                borderWidth: 1
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: {
                    position: 'top',
                    rtl: locale === 'fa'
                },
                title: {
                    display: true,
                    text: locale === 'fa' ? 'توزیع بازدیدها بر اساس ساعت' : 'Visits Distribution by Hour'
                },
                tooltip: {
                    callbacks: {
                        label: function(context) {
                            const value = context.parsed.y;
                            const formattedValue = window.localeDateManager && locale === 'fa' ?
                                window.localeDateManager.toPersianNumbers(value.toString()) : value;
                            return `${context.dataset.label}: ${formattedValue}`;
                        }
                    }
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        callback: function(value) {
                            return window.localeDateManager && locale === 'fa' ?
                                window.localeDateManager.toPersianNumbers(value.toString()) : value;
                        }
                    }
                }
            }
        }
    });
</script>
@endpush 