@extends('admin.layouts.app')

@section('title', 'جزئیات پیام')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">جزئیات پیام</h3>
                    <div class="card-tools">
                        <a href="{{ route('admin.messages.index') }}" class="btn btn-default">
                            <i class="fa fa-arrow-right"></i>
                            بازگشت به لیست
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-8">
                            <div class="mailbox-read-info">
                                <h3>{{ $message->subject }}</h3>
                                <h5>
                                    از: {{ $message->sender_name }}
                                    <span class="mailbox-read-time float-left">{{ jdate($message->created_at)->format('Y/m/d H:i') }}</span>
                                </h5>
                            </div>
                            <div class="mailbox-read-message">
                                {!! nl2br(e($message->content)) !!}
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">اطلاعات پیام</h3>
                                </div>
                                <div class="card-body">
                                    <ul class="list-group list-group-unbordered">
                                        <li class="list-group-item">
                                            <b>وضعیت</b>
                                            @if($message->read_at)
                                                <span class="badge badge-success float-left">خوانده شده</span>
                                            @else
                                                <span class="badge badge-warning float-left">خوانده نشده</span>
                                            @endif
                                        </li>
                                        <li class="list-group-item">
                                            <b>ایمیل فرستنده</b>
                                            <span class="float-left">{{ $message->sender_email }}</span>
                                        </li>
                                        <li class="list-group-item">
                                            <b>تلفن فرستنده</b>
                                            <span class="float-left">{{ $message->sender_phone }}</span>
                                        </li>
                                    </ul>
                                </div>
                                <div class="card-footer">
                                    <form action="{{ route('admin.messages.destroy', $message) }}" method="POST">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-danger btn-block" onclick="return confirm('آیا از حذف این پیام اطمینان دارید؟')">
                                            <i class="fa fa-trash"></i>
                                            حذف پیام
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection 