<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>گزارش مکان‌ها - {{ date('Y/m/d') }}</title>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Vazirmatn:wght@300;400;500;600;700&display=swap');
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Vazirmatn', 'Tahoma', sans-serif;
            font-size: 12px;
            line-height: 1.6;
            color: #333;
            direction: rtl;
            text-align: right;
        }
        
        .header {
            text-align: center;
            margin-bottom: 30px;
            padding: 20px;
            border-bottom: 3px solid #4e73df;
        }
        
        .header h1 {
            font-size: 24px;
            font-weight: 700;
            color: #4e73df;
            margin-bottom: 10px;
        }
        
        .header .date {
            font-size: 14px;
            color: #666;
            margin-bottom: 5px;
        }
        
        .header .count {
            font-size: 16px;
            font-weight: 600;
            color: #1cc88a;
        }
        
        .summary {
            display: flex;
            justify-content: space-around;
            margin-bottom: 30px;
            padding: 20px;
            background: #f8f9fc;
            border-radius: 8px;
        }
        
        .summary-item {
            text-align: center;
        }
        
        .summary-item .number {
            font-size: 20px;
            font-weight: 700;
            color: #4e73df;
            display: block;
        }
        
        .summary-item .label {
            font-size: 12px;
            color: #666;
            margin-top: 5px;
        }
        
        .table-container {
            margin-top: 20px;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
            font-size: 11px;
        }
        
        th, td {
            border: 1px solid #e3e6f0;
            padding: 8px;
            text-align: center;
        }
        
        th {
            background: #4e73df;
            color: white;
            font-weight: 600;
            font-size: 12px;
        }
        
        tr:nth-child(even) {
            background: #f8f9fc;
        }
        
        tr:hover {
            background: #e3e6f0;
        }
        
        .status-active {
            color: #1cc88a;
            font-weight: 600;
        }
        
        .status-inactive {
            color: #e74a3b;
            font-weight: 600;
        }
        
        .rating {
            color: #f6c23e;
            font-weight: 600;
        }
        
        .no-data {
            color: #999;
            font-style: italic;
        }
        
        .footer {
            margin-top: 40px;
            padding-top: 20px;
            border-top: 2px solid #e3e6f0;
            text-align: center;
            color: #666;
            font-size: 11px;
        }
        
        .page-break {
            page-break-before: always;
        }
        
        @media print {
            body {
                font-size: 10px;
            }
            
            .header h1 {
                font-size: 18px;
            }
            
            .summary {
                margin-bottom: 20px;
            }
            
            table {
                font-size: 9px;
            }
            
            th, td {
                padding: 4px;
            }
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>گزارش کامل مکان‌ها</h1>
        <div class="date">تاریخ تولید گزارش: {{ \Morilog\Jalali\Jalalian::now()->format('Y/m/d H:i') }}</div>
        <div class="count">تعداد کل مکان‌ها: {{ number_format($locations->count()) }} مورد</div>
    </div>

    <div class="summary">
        <div class="summary-item">
            <span class="number">{{ number_format($locations->where('is_active', 1)->count()) }}</span>
            <div class="label">مکان‌های فعال</div>
        </div>
        <div class="summary-item">
            <span class="number">{{ number_format($locations->where('is_active', 0)->count()) }}</span>
            <div class="label">مکان‌های غیرفعال</div>
        </div>
        <div class="summary-item">
            <span class="number">{{ number_format($locations->whereNotNull('lat')->whereNotNull('lng')->count()) }}</span>
            <div class="label">دارای مختصات</div>
        </div>
        <div class="summary-item">
            <span class="number">{{ number_format($locations->whereNotNull('star_rating')->count()) }}</span>
            <div class="label">دارای امتیاز</div>
        </div>
    </div>

    <div class="table-container">
        <table>
            <thead>
                <tr>
                    <th style="width: 5%">ردیف</th>
                    <th style="width: 8%">شناسه</th>
                    <th style="width: 25%">عنوان</th>
                    <th style="width: 15%">دسته‌بندی</th>
                    <th style="width: 12%">استان</th>
                    <th style="width: 12%">شهر</th>
                    <th style="width: 8%">وضعیت</th>
                    <th style="width: 8%">امتیاز</th>
                    <th style="width: 12%">تاریخ ایجاد</th>
                </tr>
            </thead>
            <tbody>
                @forelse($locations as $index => $location)
                    @if($index > 0 && $index % 30 == 0)
                        </tbody>
                        </table>
                        <div class="page-break"></div>
                        <table>
                            <thead>
                                <tr>
                                    <th style="width: 5%">ردیف</th>
                                    <th style="width: 8%">شناسه</th>
                                    <th style="width: 25%">عنوان</th>
                                    <th style="width: 15%">دسته‌بندی</th>
                                    <th style="width: 12%">استان</th>
                                    <th style="width: 12%">شهر</th>
                                    <th style="width: 8%">وضعیت</th>
                                    <th style="width: 8%">امتیاز</th>
                                    <th style="width: 12%">تاریخ ایجاد</th>
                                </tr>
                            </thead>
                            <tbody>
                    @endif
                    <tr>
                        <td>{{ $index + 1 }}</td>
                        <td>#{{ $location->id }}</td>
                        <td style="text-align: right;">{{ $location->title }}</td>
                        <td>
                            @if($location->categoryRelation)
                                {{ $location->categoryRelation->getTranslatedName(app()->getLocale()) }}
                            @else
                                <span class="no-data">بدون دسته‌بندی</span>
                            @endif
                        </td>
                        <td>
                            @if($location->province)
                                {{ $location->province->name }}
                            @else
                                <span class="no-data">نامشخص</span>
                            @endif
                        </td>
                        <td>
                            @if($location->city)
                                {{ $location->city->name }}
                            @else
                                <span class="no-data">نامشخص</span>
                            @endif
                        </td>
                        <td>
                            @if($location->is_active)
                                <span class="status-active">فعال</span>
                            @else
                                <span class="status-inactive">غیرفعال</span>
                            @endif
                        </td>
                        <td>
                            @if($location->star_rating)
                                <span class="rating">{{ $location->star_rating }}/5</span>
                            @else
                                <span class="no-data">ندارد</span>
                            @endif
                        </td>
                        <td>{{ \Morilog\Jalali\Jalalian::fromDateTime($location->created_at)->format('Y/m/d') }}</td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="9" style="text-align: center; padding: 20px;">
                            <span class="no-data">هیچ مکانی یافت نشد</span>
                        </td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    <div class="footer">
        <p>این گزارش به صورت خودکار تولید شده است | سیستم مدیریت مکان‌ها</p>
        <p>تاریخ و زمان تولید: {{ \Morilog\Jalali\Jalalian::now()->format('Y/m/d H:i:s') }}</p>
    </div>
</body>
</html>
