@extends('admin.layouts.app')

@section('title', 'ویرایش بخش')

@section('content')
    <div class="container-fluid">
        <div class="card">
            <div class="card-header">
                <div class="d-flex justify-content-between align-items-center">
                    <h4>ویرایش بخش</h4>
                    <a href="{{ route('admin.geography.districts.index') }}" class="btn btn-primary">
                        <i class="fa fa-arrow-left"></i>
                        بازگشت
                    </a>
                </div>
            </div>
            <div class="card-body">
                @if(session('success'))
                    <div class="alert alert-success">
                        {{ session('success') }}
                    </div>
                @endif

                @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul class="mb-0">
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif

                <form action="{{ route('admin.geography.districts.update', $district->id) }}" method="POST">
                    @csrf
                    @method('PUT')
                    
                    <div class="form-group row mb-4">
                        <label for="county_id" class="col-form-label text-md-right col-12 col-md-3 col-lg-3">شهرستان</label>
                        <div class="col-sm-12 col-md-7">
                            <select name="county_id" id="county_id" class="form-control select2 @error('county_id') is-invalid @enderror">
                                <option value="">انتخاب کنید</option>
                                @foreach($counties as $id => $name)
                                    <option value="{{ $id }}" {{ old('county_id', $district->county_id) == $id ? 'selected' : '' }}>
                                        {{ $name }}
                                    </option>
                                @endforeach
                            </select>
                            @error('county_id')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                    </div>

                    <div class="form-group row mb-4">
                        <label for="name" class="col-form-label text-md-right col-12 col-md-3 col-lg-3">نام بخش</label>
                        <div class="col-sm-12 col-md-7">
                            <input type="text" id="name" name="name" class="form-control @error('name') is-invalid @enderror" value="{{ old('name', $district->name) }}">
                            @error('name')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                    </div>

                    <div class="form-group row mb-4">
                        <label for="name_en" class="col-form-label text-md-right col-12 col-md-3 col-lg-3">نام انگلیسی</label>
                        <div class="col-sm-12 col-md-7">
                            <input type="text" id="name_en" name="name_en" class="form-control @error('name_en') is-invalid @enderror" value="{{ old('name_en', $district->name_en) }}">
                            @error('name_en')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                    </div>

                    <div class="form-group row mb-4">
                        <label for="slug" class="col-form-label text-md-right col-12 col-md-3 col-lg-3">اسلاگ</label>
                        <div class="col-sm-12 col-md-7">
                            <input type="text" id="slug" name="slug" class="form-control @error('slug') is-invalid @enderror" value="{{ old('slug', $district->slug) }}">
                            @error('slug')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                    </div>

                    <div class="form-group row mb-4">
                        <label for="center_city_name" class="col-form-label text-md-right col-12 col-md-3 col-lg-3">نام شهر مرکزی</label>
                        <div class="col-sm-12 col-md-7">
                            <input type="text" id="center_city_name" name="center_city_name" class="form-control @error('center_city_name') is-invalid @enderror" value="{{ old('center_city_name', $district->center_city_name) }}">
                            @error('center_city_name')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                    </div>

                    <div class="form-group row mb-4">
                        <label for="code" class="col-form-label text-md-right col-12 col-md-3 col-lg-3">کد بخش</label>
                        <div class="col-sm-12 col-md-7">
                            <input type="text" id="code" name="code" class="form-control @error('code') is-invalid @enderror" value="{{ old('code', $district->code) }}">
                            @error('code')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                    </div>

                    <div class="form-group row mb-4">
                        <label class="col-form-label text-md-right col-12 col-md-3 col-lg-3">وضعیت</label>
                        <div class="col-sm-12 col-md-7">
                            <div class="selectgroup w-100">
                                <label class="selectgroup-item">
                                    <input type="radio" name="is_active" value="1" class="selectgroup-input" {{ old('is_active', $district->is_active) == 1 ? 'checked' : '' }}>
                                    <span class="selectgroup-button">فعال</span>
                                </label>
                                <label class="selectgroup-item">
                                    <input type="radio" name="is_active" value="0" class="selectgroup-input" {{ old('is_active', $district->is_active) == 0 ? 'checked' : '' }}>
                                    <span class="selectgroup-button">غیرفعال</span>
                                </label>
                            </div>
                        </div>
                    </div>

                    <div class="form-group row mb-4">
                        <label class="col-form-label text-md-right col-12 col-md-3 col-lg-3"></label>
                        <div class="col-sm-12 col-md-7">
                            <button type="submit" class="btn btn-primary">ذخیره تغییرات</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
    <script>
        $(document).ready(function() {
            // تولید خودکار اسلاگ از روی نام بخش
            $('#name').on('keyup', function() {
                var name = $(this).val();
                name = name.replace(/\s+/g, '-').toLowerCase();
                // حذف کاراکترهای غیرمجاز
                name = name.replace(/[^a-z0-9-]/g, '');
                // حذف - های اضافی
                name = name.replace(/-+/g, '-');
                $('#slug').val(name);
            });
            
            // Initialize Select2 for dropdown
            $('.select2').select2();
        });
    </script>
@endsection 