@extends('admin.layouts.app')

@section('title', 'Country Details')

@section('content')
<div class="container-fluid">
    <div class="card">
        <div class="card-header">
            <div class="d-flex justify-content-between align-items-center">
                <h4>Country Details</h4>
                <div>
                    <a href="{{ route('admin.geography.countries.edit', $item->id) }}" class="btn btn-primary">
                        <i class="fas fa-edit"></i> Edit
                    </a>
                    <a href="{{ route('admin.geography.countries.index') }}" class="btn btn-secondary">
                        <i class="fas fa-list"></i> Back to List
                    </a>
                </div>
            </div>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <table class="table table-bordered">
                        <tr>
                            <th style="width: 30%">Country ID</th>
                            <td>{{ $item->id }}</td>
                        </tr>
                        <tr>
                            <th>Name (Native)</th>
                            <td>{{ $item->name }}</td>
                        </tr>
                        <tr>
                            <th>Name (English)</th>
                            <td>{{ $item->name_en }}</td>
                        </tr>
                        <tr>
                            <th>ISO Code (2)</th>
                            <td><code>{{ $item->iso_code }}</code></td>
                        </tr>
                        <tr>
                            <th>ISO Code (3)</th>
                            <td><code>{{ $item->iso_code3 }}</code></td>
                        </tr>
                        <tr>
                            <th>Numeric Code</th>
                            <td>{{ $item->num_code ?? 'N/A' }}</td>
                        </tr>
                        <tr>
                            <th>Phone Code</th>
                            <td>{{ $item->phone_code ? '+'.$item->phone_code : 'N/A' }}</td>
                        </tr>
                        <tr>
                            <th>Currency Code</th>
                            <td>{{ $item->currency_code ?? 'N/A' }}</td>
                        </tr>
                    </table>
                </div>
                <div class="col-md-6">
                    <table class="table table-bordered">
                        <tr>
                            <th style="width: 30%">Capital</th>
                            <td>{{ $item->capital ?? 'N/A' }}</td>
                        </tr>
                        <tr>
                            <th>Region</th>
                            <td>{{ $item->region ?? 'N/A' }}</td>
                        </tr>
                        <tr>
                            <th>Subregion</th>
                            <td>{{ $item->subregion ?? 'N/A' }}</td>
                        </tr>
                        <tr>
                            <th>Continent</th>
                            <td>{{ $item->continent ?? 'N/A' }}</td>
                        </tr>
                        <tr>
                            <th>Top Level Domain</th>
                            <td>{{ $item->tld ?? 'N/A' }}</td>
                        </tr>
                        <tr>
                            <th>Native Name</th>
                            <td>{{ $item->native_name ?? 'N/A' }}</td>
                        </tr>
                        <tr>
                            <th>Status</th>
                            <td>
                                <span class="badge {{ $item->is_active ? 'bg-success' : 'bg-danger' }}">
                                    {{ $item->is_active ? 'Active' : 'Inactive' }}
                                </span>
                            </td>
                        </tr>
                        <tr>
                            <th>Created At</th>
                            <td>{{ $item->created_at ? $item->created_at->format('Y-m-d H:i:s') : 'N/A' }}</td>
                        </tr>
                    </table>
                </div>
            </div>

            @if(isset($item->area) || isset($item->population))
            <div class="row mt-4">
                <div class="col-md-12">
                    <h5>Additional Information</h5>
                    <table class="table table-bordered">
                        @if(isset($item->area))
                        <tr>
                            <th style="width: 15%">Area</th>
                            <td>{{ number_format($item->area, 2) }} km²</td>
                        </tr>
                        @endif
                        @if(isset($item->population))
                        <tr>
                            <th>Population</th>
                            <td>{{ number_format($item->population) }}</td>
                        </tr>
                        @endif
                        @if(isset($item->timezone))
                        <tr>
                            <th>Timezone</th>
                            <td>{{ $item->timezone }}</td>
                        </tr>
                        @endif
                    </table>
                </div>
            </div>
            @endif

            {{-- Map section if boundaries data exists --}}
            @if(isset($item->boundaries))
            <div class="row mt-4">
                <div class="col-md-12">
                    <h5>Geographic Boundaries</h5>
                    <div id="countryMap" style="height: 400px; width: 100%;"></div>
                </div>
            </div>
            @endif
        </div>
    </div>

    <div class="card mt-4">
        <div class="card-header">
            <h5>Provinces</h5>
        </div>
        <div class="card-body">
            @if(isset($provinces) && $provinces->count() > 0)
                <div class="table-responsive">
                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Name</th>
                                <th>English Name</th>
                                <th>Center</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($provinces as $province)
                            <tr>
                                <td>{{ $province->id }}</td>
                                <td>{{ $province->name }}</td>
                                <td>{{ $province->name_en }}</td>
                                <td>{{ $province->center_city_name }}</td>
                                <td>
                                    <span class="badge {{ $province->is_active ? 'bg-success' : 'bg-danger' }}">
                                        {{ $province->is_active ? 'Active' : 'Inactive' }}
                                    </span>
                                </td>
                                <td>
                                    <a href="{{ route('admin.geography.provinces.show', $province->id) }}" class="btn btn-sm btn-info">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @else
                <p class="text-muted">No provinces found for this country.</p>
            @endif
        </div>
    </div>
</div>
@endsection

@section('scripts')
@if(isset($item->boundaries))
<script>
    // Add map display logic here if needed
    $(document).ready(function() {
        // Map initialization would go here if implementing mapping functionality
    });
</script>
@endif
@endsection 