@extends('admin.layouts.app')

@section('title', 'مدیریت شهرها')

@section('content')
<div class="container-fluid">
    <div class="card">
        <div class="card-header">
            <div class="d-flex justify-content-between align-items-center">
                <h4>مدیریت شهرها</h4>
                <a href="{{ route('admin.geography.cities.create') }}" class="btn btn-primary">
                    <i class="fas fa-plus"></i> افزودن شهر جدید
                </a>
            </div>
        </div>
        <div class="card-body">
            @if(session('success'))
                <div class="alert alert-success">
                    {{ session('success') }}
                </div>
            @endif

            <div class="table-responsive">
                <table class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th>شناسه</th>
                            <th>نام</th>
                            <th>نام انگلیسی</th>
                            <th>بخش</th>
                            <th>شهرستان</th>
                            <th>کد</th>
                            <th>وضعیت</th>
                            <th>عملیات</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($items as $city)
                            <tr>
                                <td>{{ $city->id }}</td>
                                <td>{{ $city->name }}</td>
                                <td>{{ $city->name_en ?? 'ندارد' }}</td>
                                <td>
                                    @if($city->district)
                                        {{ $city->district->name }}
                                    @else
                                        ندارد
                                    @endif
                                </td>
                                <td>
                                    @if($city->county)
                                        <a href="{{ route('admin.geography.counties.show', $city->county_id) }}">
                                            {{ $city->county->name }}
                                        </a>
                                    @else
                                        ندارد
                                    @endif
                                </td>
                                <td>{{ $city->code ?? 'ندارد' }}</td>
                                <td>
                                    <span class="badge {{ $city->is_active ? 'bg-success' : 'bg-danger' }}">
                                        {{ $city->is_active ? 'فعال' : 'غیرفعال' }}
                                    </span>
                                </td>
                                <td>
                                    <div class="btn-group btn-group-sm">
                                        <a href="{{ route('admin.geography.cities.show', $city->id) }}" class="btn btn-info">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <a href="{{ route('admin.geography.cities.edit', $city->id) }}" class="btn btn-primary">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <button type="button" class="btn btn-danger delete-item" 
                                                data-id="{{ $city->id }}" 
                                                data-url="{{ route('admin.geography.cities.destroy', $city->id) }}">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="8" class="text-center">هیچ شهری یافت نشد</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            
            @if($items->hasPages())
                <div class="d-flex justify-content-center mt-4">
                    {{ $items->links() }}
                </div>
            @endif
        </div>
    </div>
</div>

<!-- مودال تأیید حذف -->
<div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="deleteModalLabel">تأیید حذف</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                آیا از حذف این شهر اطمینان دارید؟ این عملیات قابل بازگشت نیست.
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">انصراف</button>
                <button type="button" class="btn btn-danger" id="confirmDelete">حذف</button>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    $(document).ready(function() {
        let deleteUrl = '';
        let deleteId = '';
        
        $('.delete-item').on('click', function() {
            deleteUrl = $(this).data('url');
            deleteId = $(this).data('id');
            $('#deleteModal').modal('show');
        });
        
        $('#confirmDelete').on('click', function() {
            $.ajax({
                url: deleteUrl,
                type: 'DELETE',
                data: {
                    "_token": "{{ csrf_token() }}",
                },
                success: function(response) {
                    if(response.success) {
                        $('#deleteModal').modal('hide');
                        $('tr[data-id="' + deleteId + '"]').remove();
                        // نمایش پیام موفقیت‌آمیز
                        let alertHtml = '<div class="alert alert-success">' + response.message + '</div>';
                        $('.card-body').prepend(alertHtml);
                        // بارگذاری مجدد صفحه بعد از مدت کوتاهی
                        setTimeout(function() {
                            location.reload();
                        }, 1500);
                    } else {
                        // نمایش پیام خطا در مودال
                        $('.modal-body').html('<div class="alert alert-danger">' + response.message + '</div>');
                    }
                },
                error: function(xhr) {
                    // نمایش پیام خطا در مودال
                    $('.modal-body').html('<div class="alert alert-danger">خطایی در پردازش درخواست شما رخ داد.</div>');
                }
            });
        });
    });
</script>
@endsection 