@extends('admin.layouts.app')

@section('title', 'ویرایش قالب دسته‌بندی')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">ویرایش قالب دسته‌بندی</h3>
                </div>
                <div class="card-body">
                    <form action="{{ route('admin.category-templates.update', $template) }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        @method('PUT')

                        <div class="form-group">
                            <label for="category_id">دسته‌بندی</label>
                            <select name="category_id" id="category_id" class="form-control @error('category_id') is-invalid @enderror" required>
                                <option value="">انتخاب کنید</option>
                                @foreach($categories as $category)
                                    <option value="{{ $category->id }}" {{ $template->category_id == $category->id ? 'selected' : '' }}>
                                        {{ $category->name }}
                                    </option>
                                @endforeach
                            </select>
                            @error('category_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label for="template_name">نام قالب</label>
                            <input type="text" name="template_name" id="template_name" 
                                   class="form-control @error('template_name') is-invalid @enderror" 
                                   value="{{ old('template_name', $template->template_name) }}" required>
                            @error('template_name')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label for="template_type">نوع قالب</label>
                            <select name="template_type" id="template_type" 
                                    class="form-control @error('template_type') is-invalid @enderror" required>
                                <option value="">انتخاب کنید</option>
                                @foreach(config('templates.types') as $key => $value)
                                    <option value="{{ $key }}" {{ $template->template_type == $key ? 'selected' : '' }}>
                                        {{ $value }}
                                    </option>
                                @endforeach
                            </select>
                            @error('template_type')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label for="parent_template_id">قالب والد</label>
                            <select name="parent_template_id" id="parent_template_id" 
                                    class="form-control @error('parent_template_id') is-invalid @enderror">
                                <option value="">بدون والد</option>
                                @foreach($templates as $parentTemplate)
                                    @if($parentTemplate->id != $template->id)
                                        <option value="{{ $parentTemplate->id }}" 
                                                {{ $template->parent_template_id == $parentTemplate->id ? 'selected' : '' }}>
                                            {{ $parentTemplate->template_name }}
                                        </option>
                                    @endif
                                @endforeach
                            </select>
                            @error('parent_template_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label for="header_style">استایل هدر</label>
                            <select name="header_style" id="header_style" 
                                    class="form-control @error('header_style') is-invalid @enderror" required>
                                <option value="">انتخاب کنید</option>
                                @foreach(config('templates.header_styles') as $key => $value)
                                    <option value="{{ $key }}" {{ $template->header_style == $key ? 'selected' : '' }}>
                                        {{ $value }}
                                    </option>
                                @endforeach
                            </select>
                            @error('header_style')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label for="content_layout">چیدمان محتوا</label>
                            <select name="content_layout" id="content_layout" 
                                    class="form-control @error('content_layout') is-invalid @enderror" required>
                                <option value="">انتخاب کنید</option>
                                @foreach(config('templates.content_layouts') as $key => $value)
                                    <option value="{{ $key }}" {{ $template->content_layout == $key ? 'selected' : '' }}>
                                        {{ $value }}
                                    </option>
                                @endforeach
                            </select>
                            @error('content_layout')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label for="primary_color">رنگ اصلی</label>
                            <input type="color" name="primary_color" id="primary_color" 
                                   class="form-control @error('primary_color') is-invalid @enderror" 
                                   value="{{ old('primary_color', $template->primary_color) }}" required>
                            @error('primary_color')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label for="secondary_color">رنگ فرعی</label>
                            <input type="color" name="secondary_color" id="secondary_color" 
                                   class="form-control @error('secondary_color') is-invalid @enderror" 
                                   value="{{ old('secondary_color', $template->secondary_color) }}" required>
                            @error('secondary_color')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label for="icon_set">مجموعه آیکون</label>
                            <select name="icon_set" id="icon_set" 
                                    class="form-control @error('icon_set') is-invalid @enderror" required>
                                <option value="">انتخاب کنید</option>
                                @foreach(config('templates.icon_sets') as $key => $value)
                                    <option value="{{ $key }}" {{ $template->icon_set == $key ? 'selected' : '' }}>
                                        {{ $value }}
                                    </option>
                                @endforeach
                            </select>
                            @error('icon_set')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label for="background_image">تصویر پس‌زمینه</label>
                            <div class="custom-file">
                                <input type="file" name="background_image" id="background_image" 
                                       class="custom-file-input @error('background_image') is-invalid @enderror">
                                <label class="custom-file-label" for="background_image">انتخاب فایل</label>
                            </div>
                            @error('background_image')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            @if($template->background_image)
                                <div class="mt-2">
                                    <img src="{{ asset('storage/' . $template->background_image) }}" 
                                         alt="تصویر پس‌زمینه" class="img-thumbnail" style="max-height: 200px;">
                                </div>
                            @endif
                        </div>

                        <div class="form-group">
                            <label>ویژگی‌های فعال</label>
                            <div class="row">
                                @foreach(config('templates.features') as $key => $feature)
                                    <div class="col-md-4">
                                        <div class="custom-control custom-checkbox">
                                            <input type="checkbox" name="features[]" 
                                                   id="feature-{{ $key }}" 
                                                   class="custom-control-input" 
                                                   value="{{ $key }}"
                                                   {{ in_array($key, $template->getEnabledFeatures()) ? 'checked' : '' }}>
                                            <label class="custom-control-label" for="feature-{{ $key }}">
                                                {{ $feature['name'] }}
                                            </label>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="custom_css">CSS سفارشی</label>
                            <textarea name="custom_css" id="custom_css" 
                                      class="form-control @error('custom_css') is-invalid @enderror" 
                                      rows="5">{{ old('custom_css', $template->custom_css) }}</textarea>
                            @error('custom_css')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label for="custom_js">JavaScript سفارشی</label>
                            <textarea name="custom_js" id="custom_js" 
                                      class="form-control @error('custom_js') is-invalid @enderror" 
                                      rows="5">{{ old('custom_js', $template->custom_js) }}</textarea>
                            @error('custom_js')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="form-group">
                            <button type="submit" class="btn btn-primary">ذخیره تغییرات</button>
                            <a href="{{ route('admin.category-templates.index') }}" class="btn btn-secondary">بازگشت</a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script src="{{ asset('js/admin/templates.js') }}"></script>
@endpush