@extends('admin.layouts.app')

@section('title', 'مدیریت امکانات')

@section('content')
<div class="container-fluid">
    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">مدیریت امکانات</h1>
        <div>
            <a href="{{ route('admin.amenity-types.index') }}" class="d-none d-sm-inline-block btn btn-sm btn-info shadow-sm">
                <i class="fas fa-list fa-sm text-white-50"></i> مدیریت انواع امکانات
            </a>
            <a href="{{ route('admin.amenities.create') }}" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm mr-2">
                <i class="fas fa-plus fa-sm text-white-50"></i> افزودن امکان جدید
            </a>
        </div>
    </div>

    <!-- Content Row -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">لیست امکانات</h6>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th>شناسه</th>
                            <th>نوع</th>
                            <th>عنوان</th>
                            <th>آیکون</th>
                            <th>وضعیت</th>
                            <th>عملیات</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse ($amenities as $amenity)
                        <tr>
                            <td>{{ $amenity->id }}</td>
                            <td>{{ $amenity->type->type_name ?? 'بدون نوع' }}</td>
                            <td>{{ $amenity->title }}</td>
                            <td>
                                @if($amenity->icon)
                                    <i class="{{ $amenity->icon }}"></i> {{ $amenity->icon }}
                                @else
                                    -
                                @endif
                            </td>
                            <td>
                                @if($amenity->is_active)
                                    <span class="badge" style="background-color: #d1e7dd; color: #0f5132;">فعال</span>
                                @else
                                    <span class="badge" style="background-color: #f8d7da; color: #842029;">غیرفعال</span>
                                @endif
                            </td>
                            <td>
                                <a href="{{ route('admin.amenities.edit', $amenity->id) }}" class="btn btn-sm btn-primary">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <form action="{{ route('admin.amenities.destroy', $amenity->id) }}" method="POST" class="d-inline-block">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('آیا مطمئن هستید؟')">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </form>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="6" class="text-center">هیچ امکانی ثبت نشده است</td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            <div class="d-flex justify-content-center mt-3">
                {{ $amenities->links() }}
            </div>
        </div>
    </div>
</div>
@endsection 