<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Security Configuration
    |--------------------------------------------------------------------------
    |
    | This file contains security settings for the application including
    | rate limiting, password policies, session security, and more.
    |
    */

    /*
    |--------------------------------------------------------------------------
    | Rate Limiting
    |--------------------------------------------------------------------------
    */
    'rate_limiting' => [
        'login_attempts' => [
            'max_attempts' => env('LOGIN_MAX_ATTEMPTS', 5),
            'decay_minutes' => env('LOGIN_DECAY_MINUTES', 30),
        ],
        'registration_attempts' => [
            'max_attempts' => env('REGISTRATION_MAX_ATTEMPTS', 3),
            'decay_minutes' => env('REGISTRATION_DECAY_MINUTES', 15),
        ],
        'password_reset_attempts' => [
            'max_attempts' => env('PASSWORD_RESET_MAX_ATTEMPTS', 3),
            'decay_minutes' => env('PASSWORD_RESET_DECAY_MINUTES', 60),
        ],
        'api_requests' => [
            'max_attempts' => env('API_MAX_ATTEMPTS', 60),
            'decay_minutes' => env('API_DECAY_MINUTES', 1),
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Password Policy
    |--------------------------------------------------------------------------
    */
    'password_policy' => [
        'min_length' => env('PASSWORD_MIN_LENGTH', 8),
        'max_length' => env('PASSWORD_MAX_LENGTH', 128),
        'require_uppercase' => env('PASSWORD_REQUIRE_UPPERCASE', true),
        'require_lowercase' => env('PASSWORD_REQUIRE_LOWERCASE', true),
        'require_numbers' => env('PASSWORD_REQUIRE_NUMBERS', true),
        'require_special_chars' => env('PASSWORD_REQUIRE_SPECIAL_CHARS', true),
        'prevent_common_passwords' => env('PASSWORD_PREVENT_COMMON', true),
        'prevent_personal_info' => env('PASSWORD_PREVENT_PERSONAL_INFO', true),
        'history_check' => env('PASSWORD_HISTORY_CHECK', 5),
        'expiry_days' => env('PASSWORD_EXPIRY_DAYS', 90),
    ],

    /*
    |--------------------------------------------------------------------------
    | Session Security
    |--------------------------------------------------------------------------
    */
    'session' => [
        'regenerate_on_login' => env('SESSION_REGENERATE_ON_LOGIN', true),
        'regenerate_interval' => env('SESSION_REGENERATE_INTERVAL', 15), // minutes
        'max_concurrent_sessions' => env('SESSION_MAX_CONCURRENT', 3),
        'track_ip_changes' => env('SESSION_TRACK_IP_CHANGES', true),
        'track_user_agent_changes' => env('SESSION_TRACK_USER_AGENT_CHANGES', true),
        'timeout_warning' => env('SESSION_TIMEOUT_WARNING', 5), // minutes before timeout
    ],

    /*
    |--------------------------------------------------------------------------
    | CSRF Protection
    |--------------------------------------------------------------------------
    */
    'csrf' => [
        'token_lifetime' => env('CSRF_TOKEN_LIFETIME', 3600), // seconds
        'max_invalid_attempts' => env('CSRF_MAX_INVALID_ATTEMPTS', 5),
        'lockout_time' => env('CSRF_LOCKOUT_TIME', 900), // seconds
        'regenerate_on_mismatch' => env('CSRF_REGENERATE_ON_MISMATCH', true),
    ],

    /*
    |--------------------------------------------------------------------------
    | XSS Protection
    |--------------------------------------------------------------------------
    */
    'xss' => [
        'enabled' => env('XSS_PROTECTION_ENABLED', true),
        'strict_mode' => env('XSS_STRICT_MODE', true),
        'log_attempts' => env('XSS_LOG_ATTEMPTS', true),
        'block_suspicious_patterns' => env('XSS_BLOCK_SUSPICIOUS_PATTERNS', true),
    ],

    /*
    |--------------------------------------------------------------------------
    | SQL Injection Protection
    |--------------------------------------------------------------------------
    */
    'sql_injection' => [
        'enabled' => env('SQL_INJECTION_PROTECTION_ENABLED', true),
        'strict_mode' => env('SQL_INJECTION_STRICT_MODE', true),
        'log_attempts' => env('SQL_INJECTION_LOG_ATTEMPTS', true),
        'block_suspicious_patterns' => env('SQL_INJECTION_BLOCK_SUSPICIOUS_PATTERNS', true),
    ],

    /*
    |--------------------------------------------------------------------------
    | Path Traversal Protection
    |--------------------------------------------------------------------------
    */
    'path_traversal' => [
        'enabled' => env('PATH_TRAVERSAL_PROTECTION_ENABLED', true),
        'strict_mode' => env('PATH_TRAVERSAL_STRICT_MODE', true),
        'log_attempts' => env('PATH_TRAVERSAL_LOG_ATTEMPTS', true),
        'check_file_uploads' => env('PATH_TRAVERSAL_CHECK_FILE_UPLOADS', true),
    ],

    /*
    |--------------------------------------------------------------------------
    | Command Injection Protection
    |--------------------------------------------------------------------------
    */
    'command_injection' => [
        'enabled' => env('COMMAND_INJECTION_PROTECTION_ENABLED', true),
        'strict_mode' => env('COMMAND_INJECTION_STRICT_MODE', true),
        'log_attempts' => env('COMMAND_INJECTION_LOG_ATTEMPTS', true),
        'check_headers' => env('COMMAND_INJECTION_CHECK_HEADERS', true),
    ],

    /*
    |--------------------------------------------------------------------------
    | File Upload Security
    |--------------------------------------------------------------------------
    */
    'file_upload' => [
        'max_file_size' => env('FILE_UPLOAD_MAX_SIZE', 10485760), // 10MB
        'allowed_mime_types' => [
            'image/jpeg',
            'image/png',
            'image/gif',
            'image/webp',
            'application/pdf',
            'text/plain',
            'application/msword',
            'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
        ],
        'blocked_extensions' => [
            'php', 'php3', 'php4', 'php5', 'phtml', 'phps',
            'asp', 'aspx', 'jsp', 'jspx',
            'pl', 'py', 'rb', 'sh', 'bash',
            'exe', 'bat', 'cmd', 'com', 'scr',
            'vbs', 'vbe', 'js', 'jar',
            'htaccess', 'htpasswd'
        ],
        'scan_for_malware' => env('FILE_UPLOAD_SCAN_MALWARE', false),
        'quarantine_suspicious_files' => env('FILE_UPLOAD_QUARANTINE_SUSPICIOUS', true),
    ],

    /*
    |--------------------------------------------------------------------------
    | Security Headers
    |--------------------------------------------------------------------------
    */
    'headers' => [
        'x_frame_options' => env('SECURITY_X_FRAME_OPTIONS', 'SAMEORIGIN'),
        'x_content_type_options' => env('SECURITY_X_CONTENT_TYPE_OPTIONS', 'nosniff'),
        'x_xss_protection' => env('SECURITY_X_XSS_PROTECTION', '1; mode=block'),
        'referrer_policy' => env('SECURITY_REFERRER_POLICY', 'strict-origin-when-cross-origin'),
        'permissions_policy' => env('SECURITY_PERMISSIONS_POLICY', 'geolocation=(), microphone=(), camera=()'),
        'strict_transport_security' => [
            'max_age' => env('HSTS_MAX_AGE', 31536000),
            'include_subdomains' => env('HSTS_INCLUDE_SUBDOMAINS', true),
            'preload' => env('HSTS_PRELOAD', true),
        ],
        'content_security_policy' => [
            'default_src' => "'self'",
            'script_src' => "'self' 'unsafe-inline' 'unsafe-eval' https://cdn.jsdelivr.net https://cdnjs.cloudflare.com",
            'style_src' => "'self' 'unsafe-inline' https://cdn.jsdelivr.net https://cdnjs.cloudflare.com https://fonts.googleapis.com",
            'font_src' => "'self' https://fonts.gstatic.com https://cdnjs.cloudflare.com",
            'img_src' => "'self' data: https: blob:",
            'connect_src' => "'self' https:",
            'media_src' => "'self'",
            'object_src' => "'none'",
            'base_uri' => "'self'",
            'form_action' => "'self'",
            'frame_ancestors' => "'self'",
            'upgrade_insecure_requests' => true,
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Brute Force Protection
    |--------------------------------------------------------------------------
    */
    'brute_force' => [
        'enabled' => env('BRUTE_FORCE_PROTECTION_ENABLED', true),
        'max_attempts' => env('BRUTE_FORCE_MAX_ATTEMPTS', 5),
        'lockout_time' => env('BRUTE_FORCE_LOCKOUT_TIME', 1800), // 30 minutes
        'progressive_delays' => env('BRUTE_FORCE_PROGRESSIVE_DELAYS', true),
        'ip_whitelist' => env('BRUTE_FORCE_IP_WHITELIST', ''),
        'notify_admin' => env('BRUTE_FORCE_NOTIFY_ADMIN', true),
    ],

    /*
    |--------------------------------------------------------------------------
    | Logging and Monitoring
    |--------------------------------------------------------------------------
    */
    'logging' => [
        'log_security_events' => env('SECURITY_LOG_EVENTS', true),
        'log_failed_logins' => env('SECURITY_LOG_FAILED_LOGINS', true),
        'log_suspicious_activity' => env('SECURITY_LOG_SUSPICIOUS_ACTIVITY', true),
        'alert_threshold' => env('SECURITY_ALERT_THRESHOLD', 10), // events per hour
        'retention_days' => env('SECURITY_LOG_RETENTION_DAYS', 90),
    ],

    /*
    |--------------------------------------------------------------------------
    | IP Filtering
    |--------------------------------------------------------------------------
    */
    'ip_filtering' => [
        'enabled' => env('IP_FILTERING_ENABLED', false),
        'whitelist' => env('IP_WHITELIST', ''),
        'blacklist' => env('IP_BLACKLIST', ''),
        'auto_block_suspicious_ips' => env('IP_AUTO_BLOCK_SUSPICIOUS', true),
        'block_duration' => env('IP_BLOCK_DURATION', 86400), // 24 hours
    ],

    /*
    |--------------------------------------------------------------------------
    | Two-Factor Authentication
    |--------------------------------------------------------------------------
    */
    'two_factor' => [
        'enabled' => env('TWO_FACTOR_ENABLED', false),
        'required_for_admin' => env('TWO_FACTOR_REQUIRED_ADMIN', true),
        'backup_codes_count' => env('TWO_FACTOR_BACKUP_CODES', 8),
        'window' => env('TWO_FACTOR_WINDOW', 1),
    ],
];
