<?php
// فایل تنظیمات ویژگی‌ها و امکانات قالب‌ها
return [
    'available' => [
        'booking' => [
            'title' => 'رزرو آنلاین',
            'icon' => 'fas fa-calendar-check',
            'settings' => [
                'enable_calendar' => [
                    'title' => 'نمایش تقویم',
                    'type' => 'boolean',
                    'description' => 'فعال‌سازی تقویم رزرو',
                    'help' => 'در صورت فعال بودن، کاربران می‌توانند تاریخ رزرو را انتخاب کنند.'
                ],
                'max_days' => [
                    'title' => 'حداکثر روز رزرو',
                    'type' => 'number',
                    'description' => 'تعداد روز مجاز برای رزرو',
                    'help' => 'مثلاً 30 روز'
                ]
            ]
        ],
        'payment' => [
            'title' => 'پرداخت آنلاین',
            'icon' => 'fas fa-credit-card',
            'settings' => [
                'gateway' => [
                    'title' => 'درگاه پرداخت',
                    'type' => 'select',
                    'options' => [
                        'zarinpal' => 'زرین‌پال',
                        'idpay' => 'آیدی‌پی',
                        'paypal' => 'پی‌پال'
                    ],
                    'description' => 'انتخاب درگاه پرداخت'
                ]
            ]
        ],
        'gallery' => [
            'title' => 'گالری تصاویر',
            'icon' => 'fas fa-images',
            'settings' => []
        ],
        'comments' => [
            'title' => 'نظرات کاربران',
            'icon' => 'fas fa-comments',
            'settings' => [
                'moderation' => [
                    'title' => 'نیاز به تایید',
                    'type' => 'boolean',
                    'description' => 'فعال‌سازی تایید دستی نظرات',
                    'help' => 'در صورت فعال بودن، نظرات قبل از نمایش باید تایید شوند.'
                ]
            ]
        ],
        'map' => [
            'title' => 'نمایش نقشه',
            'icon' => 'fas fa-map-marked-alt',
            'settings' => [
                'provider' => [
                    'title' => 'ارائه‌دهنده نقشه',
                    'type' => 'select',
                    'options' => [
                        'leaflet' => 'Leaflet (پیشنهادی)',
                        'google' => 'Google Maps'
                    ],
                    'description' => 'انتخاب نوع نقشه'
                ]
            ]
        ],
        'opening_hours' => [
            'title' => 'ساعات کاری',
            'icon' => 'fas fa-clock',
            'settings' => []
        ],
        'social_media' => [
            'title' => 'شبکه‌های اجتماعی',
            'icon' => 'fas fa-share-alt',
            'settings' => [
                'show_links' => [
                    'title' => 'نمایش آیکون شبکه‌ها',
                    'type' => 'boolean',
                    'description' => 'نمایش آیکون شبکه‌های اجتماعی در صفحه',
                    'help' => 'در صورت فعال بودن، آیکون شبکه‌های اجتماعی نمایش داده می‌شود.'
                ]
            ]
        ],
        'contact_form' => [
            'title' => 'فرم تماس',
            'icon' => 'fas fa-envelope',
            'settings' => [
                'enable_captcha' => [
                    'title' => 'فعال‌سازی کپچا',
                    'type' => 'boolean',
                    'description' => 'افزودن کپچا به فرم تماس',
                    'help' => 'برای جلوگیری از اسپم کپچا فعال شود.'
                ]
            ]
        ],
        'reviews' => [
            'title' => 'امتیازدهی کاربران',
            'icon' => 'fas fa-star',
            'settings' => [
                'show_average' => [
                    'title' => 'نمایش میانگین امتیاز',
                    'type' => 'boolean',
                    'description' => 'نمایش میانگین امتیاز کاربران',
                    'help' => 'در صورت فعال بودن، میانگین امتیاز نمایش داده می‌شود.'
                ]
            ]
        ],
        'related_items' => [
            'title' => 'موارد مرتبط',
            'icon' => 'fas fa-link',
            'settings' => [
                'count' => [
                    'title' => 'تعداد نمایش',
                    'type' => 'number',
                    'description' => 'تعداد موارد مرتبط قابل نمایش',
                    'help' => 'مثلاً 4 مورد'
                ]
            ]
        ],
        'custom_fields' => [
            'title' => 'فیلدهای سفارشی',
            'icon' => 'fas fa-sliders-h',
            'settings' => [
                'fields' => [
                    'title' => 'تعریف فیلدها',
                    'type' => 'text',
                    'description' => 'نام فیلدهای سفارشی (با کاما جدا کنید)',
                    'help' => 'مثلاً: ظرفیت، نوع خدمات، ...'
                ]
            ]
        ]
    ]
]; 