<?php

// تابع t و وابستگی به TranslationService حذف شود. فقط از __('key') استفاده کنید.

if (!function_exists('getSiteSetting')) {
    /**
     * دریافت مقدار یک تنظیم خاص
     * 
     * @param string $key کلید تنظیم
     * @param mixed $default مقدار پیش‌فرض
     * @param string $language_code کد زبان (اختیاری)
     * @return mixed مقدار تنظیم
     */
    function getSiteSetting($key, $default = null, $language_code = null) {
        return \App\Helpers\SiteSettings::getSetting($key, $default, $language_code);
    }
}

if (!function_exists('getActiveSiteSettings')) {
    /**
     * دریافت تنظیمات فعال سایت برای زبان فعلی
     * 
     * @param string $language_code کد زبان (اختیاری)
     * @return array تنظیمات فعال سایت
     */
    function getActiveSiteSettings($language_code = null) {
        return \App\Helpers\SiteSettings::getActiveSettings($language_code);
    }
}
