<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class NotificationSetting extends Model
{
    protected $fillable = [
        'admin_id',
        'email_notifications',
        'sms_notifications',
        'push_notifications',
        'notification_types'
    ];

    protected $casts = [
        'email_notifications' => 'boolean',
        'sms_notifications' => 'boolean',
        'push_notifications' => 'boolean',
        'notification_types' => 'array'
    ];

    public function admin()
    {
        return $this->belongsTo(AdminUser::class, 'admin_id');
    }
} 