<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Notification extends Model
{
    protected $fillable = [
        'type',
        'notifiable_type',
        'notifiable_id',
        'title',
        'content',
        'data',
        'read_at'
    ];

    protected $casts = [
        'data' => 'array',
        'read_at' => 'datetime'
    ];

    /**
     * بررسی خوانده شدن اعلان
     */
    public function isRead()
    {
        return !is_null($this->read_at);
    }

    /**
     * علامت‌گذاری اعلان به عنوان خوانده شده
     */
    public function markAsRead()
    {
        if (!$this->isRead()) {
            $this->update(['read_at' => now()]);
        }
    }

    /**
     * دریافت رنگ مربوط به نوع اعلان
     */
    public function getTypeColorAttribute()
    {
        return match($this->type) {
            'success' => 'success',
            'warning' => 'warning',
            'error' => 'danger',
            'info' => 'info',
            default => 'secondary'
        };
    }

    /**
     * دریافت متن فارسی نوع اعلان
     */
    public function getTypeTextAttribute()
    {
        return match($this->type) {
            'success' => 'موفقیت',
            'warning' => 'هشدار',
            'error' => 'خطا',
            'info' => 'اطلاعات',
            default => 'سایر'
        };
    }
} 