<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class AdPackage extends Model
{
    protected $table = 'ad_packages';

    protected $fillable = [
        'package_key', 'name', 'description', 'price', 'duration_days',
        'badge_text', 'badge_color', 'card_design', 'card_border_color',
        'card_background_color', 'card_text_color', 'priority', 'is_active',
    ];

    public function cardDesign()
    {
        return $this->belongsTo(AdCardDesign::class, 'card_design', 'design_key');
    }

    public function locationPackages()
    {
        return $this->hasMany(LocationAdPackage::class, 'package_id');
    }
}
