<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Notification;
use Illuminate\Http\Request;
use App\Models\NotificationSetting;
use Illuminate\Support\Facades\Auth;

class NotificationController extends Controller
{
    /**
     * نمایش لیست اعلان‌ها
     */
    public function index()
    {
        $notifications = Notification::latest()->paginate(20);
        return view('admin.notifications.index', compact('notifications'));
    }

    /**
     * نمایش جزئیات یک اعلان
     */
    public function show(Notification $notification)
    {
        $notification->markAsRead();
        return view('admin.notifications.show', compact('notification'));
    }

    /**
     * حذف اعلان
     */
    public function destroy(Notification $notification)
    {
        $notification->delete();
        return redirect()->route('admin.notifications.index')
            ->with('success', 'اعلان با موفقیت حذف شد.');
    }

    /**
     * علامت‌گذاری همه اعلان‌ها به عنوان خوانده شده
     */
    public function markAllAsRead()
    {
        Notification::where('read_at', null)->update(['read_at' => now()]);
        return redirect()->route('admin.notifications.index')
            ->with('success', 'همه اعلان‌ها به عنوان خوانده شده علامت‌گذاری شدند.');
    }

    /**
     * نمایش صفحه تنظیمات اعلان‌ها
     */
    public function settings()
    {
        $settings = NotificationSetting::where('admin_id', Auth::guard('admin')->id())->first();
        return view('admin.notifications.settings', compact('settings'));
    }

    /**
     * بروزرسانی تنظیمات اعلان‌ها
     */
    public function updateSettings(Request $request)
    {
        $validated = $request->validate([
            'email_notifications' => 'boolean',
            'sms_notifications' => 'boolean',
            'push_notifications' => 'boolean',
            'notification_types' => 'array',
            'notification_types.*' => 'string'
        ]);

        $settings = NotificationSetting::updateOrCreate(
            ['admin_id' => Auth::guard('admin')->id()],
            $validated
        );

        return redirect()->route('admin.notifications.settings')
            ->with('success', 'تنظیمات اعلان‌ها با موفقیت بروزرسانی شد.');
    }

    /**
     * تغییر وضعیت یک تنظیم خاص
     */
    public function toggleSetting(Request $request)
    {
        $validated = $request->validate([
            'setting' => 'required|string',
            'value' => 'required|boolean'
        ]);

        $settings = NotificationSetting::updateOrCreate(
            ['admin_id' => Auth::guard('admin')->id()],
            [$validated['setting'] => $validated['value']]
        );

        return response()->json([
            'success' => true,
            'message' => 'تنظیم با موفقیت بروزرسانی شد.'
        ]);
    }
} 