-- داده‌های مدیریت منوهای سایت برای زبان‌های انگلیسی و عربی
-- جداول: menus, menu_items

-- 1. نمایش وضعیت فعلی
SELECT '=== وضعیت فعلی منوهای سایت ===' as status;

SELECT 'منوهای موجود:' as type;
SELECT language, COUNT(*) as count 
FROM menus 
GROUP BY language 
ORDER BY language;

SELECT 'آیتم‌های منو موجود:' as type;
SELECT m.language, COUNT(mi.id) as items_count
FROM menus m 
LEFT JOIN menu_items mi ON m.id = mi.menu_id
GROUP BY m.language 
ORDER BY m.language;

-- 2. ایجاد پشتیبان
SELECT '=== ایجاد پشتیبان ===' as backup;

CREATE TABLE IF NOT EXISTS menus_backup_multilingual AS 
SELECT * FROM menus WHERE language IN ('en', 'ar');

CREATE TABLE IF NOT EXISTS menu_items_backup_multilingual AS 
SELECT mi.* FROM menu_items mi 
JOIN menus m ON mi.menu_id = m.id 
WHERE m.language IN ('en', 'ar');

-- 3. حذف داده‌های موجود (انگلیسی و عربی)
SELECT '=== پاک‌سازی داده‌های موجود ===' as cleanup;

DELETE mi FROM menu_items mi 
JOIN menus m ON mi.menu_id = m.id 
WHERE m.language IN ('en', 'ar');

DELETE FROM menus WHERE language IN ('en', 'ar');

SELECT 'داده‌های انگلیسی و عربی پاک شدند.' as cleanup_result;

-- 4. منوهای اصلی - زبان انگلیسی
SELECT '=== منوهای انگلیسی ===' as en_menus;

INSERT INTO menus (name, slug, language, position, is_active, created_at, updated_at) VALUES
('Main Navigation', 'main-navigation', 'en', 'header', 1, NOW(), NOW()),
('Footer Menu', 'footer-menu', 'en', 'footer', 1, NOW(), NOW()),
('User Account Menu', 'user-account-menu', 'en', 'user-dropdown', 1, NOW(), NOW()),
('Mobile Menu', 'mobile-menu', 'en', 'mobile', 1, NOW(), NOW()),
('Quick Links', 'quick-links', 'en', 'sidebar', 1, NOW(), NOW());

-- 5. آیتم‌های منوی اصلی - انگلیسی
SELECT '=== آیتم‌های منوی اصلی انگلیسی ===' as en_main_items;

SET @main_menu_en = (SELECT id FROM menus WHERE slug = 'main-navigation' AND language = 'en');

INSERT INTO menu_items (menu_id, title, url, icon, target, sort_order, parent_id, is_active, created_at, updated_at) VALUES
-- منوی اصلی
(@main_menu_en, 'Home', '/', 'fas fa-home', '_self', 1, NULL, 1, NOW(), NOW()),
(@main_menu_en, 'Locations', '/locations', 'fas fa-map-marker-alt', '_self', 2, NULL, 1, NOW(), NOW()),
(@main_menu_en, 'Categories', '/categories', 'fas fa-th-large', '_self', 3, NULL, 1, NOW(), NOW()),
(@main_menu_en, 'About Us', '/about', 'fas fa-info-circle', '_self', 4, NULL, 1, NOW(), NOW()),
(@main_menu_en, 'Contact', '/contact', 'fas fa-envelope', '_self', 5, NULL, 1, NOW(), NOW()),
(@main_menu_en, 'Blog', '/blog', 'fas fa-blog', '_self', 6, NULL, 1, NOW(), NOW());

-- زیرمنوی مکان‌ها
SET @locations_parent_en = (SELECT id FROM menu_items WHERE title = 'Locations' AND menu_id = @main_menu_en);

INSERT INTO menu_items (menu_id, title, url, icon, target, sort_order, parent_id, is_active, created_at, updated_at) VALUES
(@main_menu_en, 'All Locations', '/locations', 'fas fa-list', '_self', 1, @locations_parent_en, 1, NOW(), NOW()),
(@main_menu_en, 'Popular Places', '/locations/popular', 'fas fa-star', '_self', 2, @locations_parent_en, 1, NOW(), NOW()),
(@main_menu_en, 'Recent Additions', '/locations/recent', 'fas fa-clock', '_self', 3, @locations_parent_en, 1, NOW(), NOW()),
(@main_menu_en, 'Top Rated', '/locations/top-rated', 'fas fa-trophy', '_self', 4, @locations_parent_en, 1, NOW(), NOW()),
(@main_menu_en, 'Add Location', '/user/locations/create', 'fas fa-plus-circle', '_self', 5, @locations_parent_en, 1, NOW(), NOW());

-- 6. آیتم‌های منوی فوتر - انگلیسی
SELECT '=== آیتم‌های منوی فوتر انگلیسی ===' as en_footer_items;

SET @footer_menu_en = (SELECT id FROM menus WHERE slug = 'footer-menu' AND language = 'en');

INSERT INTO menu_items (menu_id, title, url, icon, target, sort_order, parent_id, is_active, created_at, updated_at) VALUES
-- ستون اول
(@footer_menu_en, 'About', '/about', 'fas fa-info', '_self', 1, NULL, 1, NOW(), NOW()),
(@footer_menu_en, 'Privacy Policy', '/privacy', 'fas fa-shield-alt', '_self', 2, NULL, 1, NOW(), NOW()),
(@footer_menu_en, 'Terms of Service', '/terms', 'fas fa-file-contract', '_self', 3, NULL, 1, NOW(), NOW()),
(@footer_menu_en, 'FAQ', '/faq', 'fas fa-question-circle', '_self', 4, NULL, 1, NOW(), NOW()),

-- ستون دوم
(@footer_menu_en, 'Contact Us', '/contact', 'fas fa-phone', '_self', 5, NULL, 1, NOW(), NOW()),
(@footer_menu_en, 'Support', '/support', 'fas fa-life-ring', '_self', 6, NULL, 1, NOW(), NOW()),
(@footer_menu_en, 'Feedback', '/feedback', 'fas fa-comment', '_self', 7, NULL, 1, NOW(), NOW()),
(@footer_menu_en, 'Report Issue', '/report', 'fas fa-exclamation-triangle', '_self', 8, NULL, 1, NOW(), NOW());

-- 7. آیتم‌های منوی کاربری - انگلیسی
SELECT '=== آیتم‌های منوی کاربری انگلیسی ===' as en_user_items;

SET @user_menu_en = (SELECT id FROM menus WHERE slug = 'user-account-menu' AND language = 'en');

INSERT INTO menu_items (menu_id, title, url, icon, target, sort_order, parent_id, is_active, created_at, updated_at) VALUES
(@user_menu_en, 'Dashboard', '/user/dashboard', 'fas fa-tachometer-alt', '_self', 1, NULL, 1, NOW(), NOW()),
(@user_menu_en, 'My Profile', '/user/profile', 'fas fa-user-edit', '_self', 2, NULL, 1, NOW(), NOW()),
(@user_menu_en, 'My Locations', '/user/locations', 'fas fa-map-marker-alt', '_self', 3, NULL, 1, NOW(), NOW()),
(@user_menu_en, 'Favorites', '/user/favorites', 'fas fa-heart', '_self', 4, NULL, 1, NOW(), NOW()),
(@user_menu_en, 'Messages', '/user/messages', 'fas fa-envelope', '_self', 5, NULL, 1, NOW(), NOW()),
(@user_menu_en, 'Settings', '/user/settings', 'fas fa-cog', '_self', 6, NULL, 1, NOW(), NOW()),
(@user_menu_en, 'Logout', '/logout', 'fas fa-sign-out-alt', '_self', 7, NULL, 1, NOW(), NOW());

-- 8. آیتم‌های منوی موبایل - انگلیسی
SELECT '=== آیتم‌های منوی موبایل انگلیسی ===' as en_mobile_items;

SET @mobile_menu_en = (SELECT id FROM menus WHERE slug = 'mobile-menu' AND language = 'en');

INSERT INTO menu_items (menu_id, title, url, icon, target, sort_order, parent_id, is_active, created_at, updated_at) VALUES
(@mobile_menu_en, 'Home', '/', 'fas fa-home', '_self', 1, NULL, 1, NOW(), NOW()),
(@mobile_menu_en, 'Browse Locations', '/locations', 'fas fa-search', '_self', 2, NULL, 1, NOW(), NOW()),
(@mobile_menu_en, 'Categories', '/categories', 'fas fa-th-large', '_self', 3, NULL, 1, NOW(), NOW()),
(@mobile_menu_en, 'Add Location', '/user/locations/create', 'fas fa-plus', '_self', 4, NULL, 1, NOW(), NOW()),
(@mobile_menu_en, 'My Account', '/user/dashboard', 'fas fa-user', '_self', 5, NULL, 1, NOW(), NOW()),
(@mobile_menu_en, 'Contact', '/contact', 'fas fa-phone', '_self', 6, NULL, 1, NOW(), NOW());

-- 9. آیتم‌های لینک‌های سریع - انگلیسی
SELECT '=== لینک‌های سریع انگلیسی ===' as en_quick_items;

SET @quick_menu_en = (SELECT id FROM menus WHERE slug = 'quick-links' AND language = 'en');

INSERT INTO menu_items (menu_id, title, url, icon, target, sort_order, parent_id, is_active, created_at, updated_at) VALUES
(@quick_menu_en, 'Popular Cities', '/cities/popular', 'fas fa-city', '_self', 1, NULL, 1, NOW(), NOW()),
(@quick_menu_en, 'Tourist Attractions', '/categories/tourist-attractions', 'fas fa-camera', '_self', 2, NULL, 1, NOW(), NOW()),
(@quick_menu_en, 'Restaurants', '/categories/restaurants', 'fas fa-utensils', '_self', 3, NULL, 1, NOW(), NOW()),
(@quick_menu_en, 'Hotels', '/categories/hotels', 'fas fa-bed', '_self', 4, NULL, 1, NOW(), NOW()),
(@quick_menu_en, 'Shopping', '/categories/shopping', 'fas fa-shopping-bag', '_self', 5, NULL, 1, NOW(), NOW());

-- 10. منوهای اصلی - زبان عربی
SELECT '=== منوهای عربی ===' as ar_menus;

INSERT INTO menus (name, slug, language, position, is_active, created_at, updated_at) VALUES
('التنقل الرئيسي', 'main-navigation', 'ar', 'header', 1, NOW(), NOW()),
('قائمة التذييل', 'footer-menu', 'ar', 'footer', 1, NOW(), NOW()),
('قائمة حساب المستخدم', 'user-account-menu', 'ar', 'user-dropdown', 1, NOW(), NOW()),
('القائمة المحمولة', 'mobile-menu', 'ar', 'mobile', 1, NOW(), NOW()),
('الروابط السريعة', 'quick-links', 'ar', 'sidebar', 1, NOW(), NOW());

-- 11. آیتم‌های منوی اصلی - عربی
SELECT '=== آیتم‌های منوی اصلی عربی ===' as ar_main_items;

SET @main_menu_ar = (SELECT id FROM menus WHERE slug = 'main-navigation' AND language = 'ar');

INSERT INTO menu_items (menu_id, title, url, icon, target, sort_order, parent_id, is_active, created_at, updated_at) VALUES
-- منوی اصلی
(@main_menu_ar, 'الرئيسية', '/', 'fas fa-home', '_self', 1, NULL, 1, NOW(), NOW()),
(@main_menu_ar, 'المواقع', '/locations', 'fas fa-map-marker-alt', '_self', 2, NULL, 1, NOW(), NOW()),
(@main_menu_ar, 'الفئات', '/categories', 'fas fa-th-large', '_self', 3, NULL, 1, NOW(), NOW()),
(@main_menu_ar, 'من نحن', '/about', 'fas fa-info-circle', '_self', 4, NULL, 1, NOW(), NOW()),
(@main_menu_ar, 'اتصل بنا', '/contact', 'fas fa-envelope', '_self', 5, NULL, 1, NOW(), NOW()),
(@main_menu_ar, 'المدونة', '/blog', 'fas fa-blog', '_self', 6, NULL, 1, NOW(), NOW());

-- زیرمنوی مکان‌ها
SET @locations_parent_ar = (SELECT id FROM menu_items WHERE title = 'المواقع' AND menu_id = @main_menu_ar);

INSERT INTO menu_items (menu_id, title, url, icon, target, sort_order, parent_id, is_active, created_at, updated_at) VALUES
(@main_menu_ar, 'جميع المواقع', '/locations', 'fas fa-list', '_self', 1, @locations_parent_ar, 1, NOW(), NOW()),
(@main_menu_ar, 'الأماكن الشعبية', '/locations/popular', 'fas fa-star', '_self', 2, @locations_parent_ar, 1, NOW(), NOW()),
(@main_menu_ar, 'الإضافات الحديثة', '/locations/recent', 'fas fa-clock', '_self', 3, @locations_parent_ar, 1, NOW(), NOW()),
(@main_menu_ar, 'الأعلى تقييماً', '/locations/top-rated', 'fas fa-trophy', '_self', 4, @locations_parent_ar, 1, NOW(), NOW()),
(@main_menu_ar, 'إضافة موقع', '/user/locations/create', 'fas fa-plus-circle', '_self', 5, @locations_parent_ar, 1, NOW(), NOW());

-- 12. آیتم‌های منوی فوتر - عربی
SELECT '=== آیتم‌های منوی فوتر عربی ===' as ar_footer_items;

SET @footer_menu_ar = (SELECT id FROM menus WHERE slug = 'footer-menu' AND language = 'ar');

INSERT INTO menu_items (menu_id, title, url, icon, target, sort_order, parent_id, is_active, created_at, updated_at) VALUES
-- ستون اول
(@footer_menu_ar, 'حول الموقع', '/about', 'fas fa-info', '_self', 1, NULL, 1, NOW(), NOW()),
(@footer_menu_ar, 'سياسة الخصوصية', '/privacy', 'fas fa-shield-alt', '_self', 2, NULL, 1, NOW(), NOW()),
(@footer_menu_ar, 'شروط الخدمة', '/terms', 'fas fa-file-contract', '_self', 3, NULL, 1, NOW(), NOW()),
(@footer_menu_ar, 'الأسئلة الشائعة', '/faq', 'fas fa-question-circle', '_self', 4, NULL, 1, NOW(), NOW()),

-- ستون دوم
(@footer_menu_ar, 'اتصل بنا', '/contact', 'fas fa-phone', '_self', 5, NULL, 1, NOW(), NOW()),
(@footer_menu_ar, 'الدعم الفني', '/support', 'fas fa-life-ring', '_self', 6, NULL, 1, NOW(), NOW()),
(@footer_menu_ar, 'التعليقات', '/feedback', 'fas fa-comment', '_self', 7, NULL, 1, NOW(), NOW()),
(@footer_menu_ar, 'الإبلاغ عن مشكلة', '/report', 'fas fa-exclamation-triangle', '_self', 8, NULL, 1, NOW(), NOW());

-- 13. آیتم‌های منوی کاربری - عربی
SELECT '=== آیتم‌های منوی کاربری عربی ===' as ar_user_items;

SET @user_menu_ar = (SELECT id FROM menus WHERE slug = 'user-account-menu' AND language = 'ar');

INSERT INTO menu_items (menu_id, title, url, icon, target, sort_order, parent_id, is_active, created_at, updated_at) VALUES
(@user_menu_ar, 'لوحة التحكم', '/user/dashboard', 'fas fa-tachometer-alt', '_self', 1, NULL, 1, NOW(), NOW()),
(@user_menu_ar, 'ملفي الشخصي', '/user/profile', 'fas fa-user-edit', '_self', 2, NULL, 1, NOW(), NOW()),
(@user_menu_ar, 'مواقعي', '/user/locations', 'fas fa-map-marker-alt', '_self', 3, NULL, 1, NOW(), NOW()),
(@user_menu_ar, 'المفضلة', '/user/favorites', 'fas fa-heart', '_self', 4, NULL, 1, NOW(), NOW()),
(@user_menu_ar, 'الرسائل', '/user/messages', 'fas fa-envelope', '_self', 5, NULL, 1, NOW(), NOW()),
(@user_menu_ar, 'الإعدادات', '/user/settings', 'fas fa-cog', '_self', 6, NULL, 1, NOW(), NOW()),
(@user_menu_ar, 'تسجيل الخروج', '/logout', 'fas fa-sign-out-alt', '_self', 7, NULL, 1, NOW(), NOW());

-- 14. آیتم‌های منوی موبایل - عربی
SELECT '=== آیتم‌های منوی موبایل عربی ===' as ar_mobile_items;

SET @mobile_menu_ar = (SELECT id FROM menus WHERE slug = 'mobile-menu' AND language = 'ar');

INSERT INTO menu_items (menu_id, title, url, icon, target, sort_order, parent_id, is_active, created_at, updated_at) VALUES
(@mobile_menu_ar, 'الرئيسية', '/', 'fas fa-home', '_self', 1, NULL, 1, NOW(), NOW()),
(@mobile_menu_ar, 'تصفح المواقع', '/locations', 'fas fa-search', '_self', 2, NULL, 1, NOW(), NOW()),
(@mobile_menu_ar, 'الفئات', '/categories', 'fas fa-th-large', '_self', 3, NULL, 1, NOW(), NOW()),
(@mobile_menu_ar, 'إضافة موقع', '/user/locations/create', 'fas fa-plus', '_self', 4, NULL, 1, NOW(), NOW()),
(@mobile_menu_ar, 'حسابي', '/user/dashboard', 'fas fa-user', '_self', 5, NULL, 1, NOW(), NOW()),
(@mobile_menu_ar, 'اتصل بنا', '/contact', 'fas fa-phone', '_self', 6, NULL, 1, NOW(), NOW());

-- 15. آیتم‌های لینک‌های سریع - عربی
SELECT '=== لینک‌های سریع عربی ===' as ar_quick_items;

SET @quick_menu_ar = (SELECT id FROM menus WHERE slug = 'quick-links' AND language = 'ar');

INSERT INTO menu_items (menu_id, title, url, icon, target, sort_order, parent_id, is_active, created_at, updated_at) VALUES
(@quick_menu_ar, 'المدن الشعبية', '/cities/popular', 'fas fa-city', '_self', 1, NULL, 1, NOW(), NOW()),
(@quick_menu_ar, 'المعالم السياحية', '/categories/tourist-attractions', 'fas fa-camera', '_self', 2, NULL, 1, NOW(), NOW()),
(@quick_menu_ar, 'المطاعم', '/categories/restaurants', 'fas fa-utensils', '_self', 3, NULL, 1, NOW(), NOW()),
(@quick_menu_ar, 'الفنادق', '/categories/hotels', 'fas fa-bed', '_self', 4, NULL, 1, NOW(), NOW()),
(@quick_menu_ar, 'التسوق', '/categories/shopping', 'fas fa-shopping-bag', '_self', 5, NULL, 1, NOW(), NOW());

-- 16. بررسی نتایج نهایی
SELECT '=== نتایج نهایی ===' as final_results;

-- آمار کلی منوها
SELECT 'آمار منوها:' as type;
SELECT
    language,
    COUNT(*) as menu_count
FROM menus
WHERE language IN ('en', 'ar')
GROUP BY language
ORDER BY language;

-- آمار آیتم‌های منو
SELECT 'آمار آیتم‌های منو:' as type;
SELECT
    m.language,
    COUNT(mi.id) as items_count
FROM menus m
LEFT JOIN menu_items mi ON m.id = mi.menu_id
WHERE m.language IN ('en', 'ar')
GROUP BY m.language
ORDER BY m.language;

-- منوهای انگلیسی
SELECT 'منوهای انگلیسی:' as type;
SELECT name, slug, position
FROM menus
WHERE language = 'en' AND is_active = 1
ORDER BY name;

-- منوهای عربی
SELECT 'منوهای عربی:' as type;
SELECT name, slug, position
FROM menus
WHERE language = 'ar' AND is_active = 1
ORDER BY name;

-- آیتم‌های منوی اصلی انگلیسی
SELECT 'آیتم‌های منوی اصلی انگلیسی:' as type;
SELECT mi.title, mi.url, mi.sort_order
FROM menu_items mi
JOIN menus m ON mi.menu_id = m.id
WHERE m.slug = 'main-navigation' AND m.language = 'en' AND mi.parent_id IS NULL
ORDER BY mi.sort_order;

-- آیتم‌های منوی اصلی عربی
SELECT 'آیتم‌های منوی اصلی عربی:' as type;
SELECT mi.title, mi.url, mi.sort_order
FROM menu_items mi
JOIN menus m ON mi.menu_id = m.id
WHERE m.slug = 'main-navigation' AND m.language = 'ar' AND mi.parent_id IS NULL
ORDER BY mi.sort_order;

-- 17. تأیید نهایی
SELECT '=== تأیید نهایی ===' as confirmation;

SELECT
    CASE
        WHEN (SELECT COUNT(*) FROM menus WHERE language = 'en') = 5
        AND (SELECT COUNT(*) FROM menus WHERE language = 'ar') = 5
        AND (SELECT COUNT(mi.id) FROM menu_items mi JOIN menus m ON mi.menu_id = m.id WHERE m.language = 'en') >= 30
        AND (SELECT COUNT(mi.id) FROM menu_items mi JOIN menus m ON mi.menu_id = m.id WHERE m.language = 'ar') >= 30
        THEN '✅ منوهای چندزبانه با موفقیت ایجاد شدند!'
        ELSE '❌ خطا در ایجاد منوها - لطفاً مجدداً بررسی کنید'
    END as final_status;

-- 18. راهنمای بعدی
SELECT '=== راهنمای بعدی ===' as next_steps;

SELECT 'مراحل بعدی:
1. پاک کردن کش: php artisan cache:clear
2. بررسی منوها در پنل مدیریت
3. تست نمایش منوها در سایت
4. تنظیم منوها در قالب‌ها
5. تست تغییر زبان و نمایش منوهای مربوطه
6. بررسی عملکرد زیرمنوها
7. تست responsive در موبایل' as instructions;

-- 19. جدول مقایسه ترجمه‌ها
SELECT '=== جدول مقایسه ترجمه‌ها ===' as translations;

SELECT 'مقایسه ترجمه‌های کلیدی:' as comparison;

SELECT
    'Home / الرئيسية' as home_translation,
    'Locations / المواقع' as locations_translation,
    'Categories / الفئات' as categories_translation,
    'About Us / من نحن' as about_translation,
    'Contact / اتصل بنا' as contact_translation,
    'Dashboard / لوحة التحكم' as dashboard_translation,
    'My Profile / ملفي الشخصي' as profile_translation,
    'Settings / الإعدادات' as settings_translation,
    'Logout / تسجيل الخروج' as logout_translation;

SELECT '✅ آماده‌سازی منوهای چندزبانه کامل شد!' as final_message;
