<?php

use App\Http\Controllers\AdvertisementController;
use App\Http\Controllers\ApiController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\Api\DateController;
use App\Models\Advertisement;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

// مسیرهای API عمومی
Route::get('/test', [ApiController::class, 'test']);
Route::get('/locations', [ApiController::class, 'getLocations']);
Route::get('/locations-simple', [ApiController::class, 'getSimpleLocations']);
Route::get('/categories', [ApiController::class, 'getCategories']);
Route::get('/provinces', [ApiController::class, 'getProvinces']);
Route::get('/provinces/{provinceId}/cities', [ApiController::class, 'getCitiesByProvince']);
Route::get('/geographic-data', [ApiController::class, 'getGeographicData']);
Route::get('/debug', [ApiController::class, 'debug']);
Route::get('/search', [HomeController::class, 'search']);
Route::get('/search-suggestions', [HomeController::class, 'searchSuggestions']);

// Get text advertisements
Route::get('/advertisements/text', [AdvertisementController::class, 'getTextAds']);

// NEW Simple route for text advertisements
Route::get('/text-ads', function () {
    try {
        $ads = Advertisement::where('position', 'text_ticker')
            ->where('is_active', true)
            ->select('id', 'title as content', 'target_url', 'speed', 'direction', 'animation_type', 'text_color')
            ->orderBy('display_order')
            ->limit(10)
            ->get();

        // If no ads found, provide default fallback
        if ($ads->isEmpty()) {
            $ads = [
                [
                    'id' => 1,
                    'content' => 'به اَلو ایران خوش آمدید! مرجع جامع معرفی مکان‌های گردشگری و تفریحی ایران',
                    'target_url' => null,
                    'speed' => 20,
                    'direction' => 'rtl',
                    'animation_type' => 'none',
                    'text_color' => '#FFC107',
                ],
            ];
        }

        return response()->json(['success' => true, 'ads' => $ads]);
    } catch (\Exception $e) {
        return response()->json([
            'success' => false,
            'error' => $e->getMessage(),
            'ads' => [
                [
                    'id' => 1,
                    'content' => 'به اَلو ایران خوش آمدید! مرجع جامع معرفی مکان‌های گردشگری و تفریحی ایران',
                    'target_url' => null,
                    'speed' => 20,
                    'direction' => 'rtl',
                    'animation_type' => 'none',
                    'text_color' => '#FFC107',
                ],
            ],
        ]);
    }
});

// API for dynamic filters
Route::get('/provinces-by-country/{country}', [HomeController::class, 'getProvincesByCountry']);
Route::get('/cities-by-province/{province}', [HomeController::class, 'getCitiesByProvince']);
Route::get('/filter-counts', [HomeController::class, 'getFilterCounts']);
Route::post('/filter-counts', [HomeController::class, 'getFilterCounts']);

// API for enhanced geographic hierarchy
Route::get('/provinces/{province}/counties', [ApiController::class, 'getCountiesByProvince']);
Route::get('/counties/{county}/cities', [ApiController::class, 'getCitiesByCounty']);
Route::get('/counties/{county}/districts', [ApiController::class, 'getDistrictsByCounty']);
Route::get('/districts/{district}/villages', [ApiController::class, 'getVillagesByDistrict']);
Route::get('/cities/{city}/zones', [ApiController::class, 'getZonesByCity']);

// Enhanced map API endpoints
Route::get('/map/statistics', [ApiController::class, 'getMapStatistics']);
Route::get('/map/featured-locations', [ApiController::class, 'getFeaturedLocations']);
Route::get('/map/nearby', [ApiController::class, 'getNearbyLocations']);
Route::post('/map/bulk-filter', [ApiController::class, 'bulkFilterLocations']);

// API for boundaries
Route::get('/boundaries/{regionType}/{regionId}', [ApiController::class, 'getBoundaryData']);
Route::get('/countries/{id}/boundaries', [ApiController::class, 'getCountryBoundaries']);

// Date and localization API routes
Route::post('/convert-date', [DateController::class, 'convertDate']);
Route::post('/format-for-chart', [DateController::class, 'formatForChart']);
Route::get('/month-names', [DateController::class, 'getMonthNames']);
Route::get('/day-names', [DateController::class, 'getDayNames']);
Route::post('/convert-numbers', [DateController::class, 'convertNumbers']);

// لاگ کردن تمام درخواست‌های API برای اشکال‌زدایی
Route::any('{any}', function (Request $request) {
    \Illuminate\Support\Facades\Log::info('Unhandled API route accessed', [
        'path' => $request->path(),
        'method' => $request->method(),
        'query' => $request->query(),
    ]);

    return response()->json(['error' => 'Route not found'], 404);
})->where('any', '.*');
