@extends('layouts.user')

@section('title', 'تغییر رمز عبور')

@section('styles')
<style>
    /* Modern Change Password Styles */
    .change-password-container {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        min-height: calc(100vh - 140px);
        padding: 2rem 0;
        position: relative;
        overflow: hidden;
    }

    .change-password-container::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><defs><pattern id="grain" width="100" height="100" patternUnits="userSpaceOnUse"><circle cx="25" cy="25" r="1" fill="white" opacity="0.1"/><circle cx="75" cy="75" r="1" fill="white" opacity="0.1"/><circle cx="50" cy="10" r="0.5" fill="white" opacity="0.1"/></pattern></defs><rect width="100" height="100" fill="url(%23grain)"/></svg>');
        opacity: 0.3;
    }

    .password-change-card {
        background: rgba(255, 255, 255, 0.95);
        backdrop-filter: blur(20px);
        border-radius: 24px;
        box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1);
        border: 1px solid rgba(255, 255, 255, 0.2);
        overflow: hidden;
        position: relative;
        z-index: 2;
        animation: slideInUp 0.6s ease-out;
    }

    @keyframes slideInUp {
        from {
            opacity: 0;
            transform: translateY(30px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    .card-header-modern {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        padding: 2rem;
        text-align: center;
        position: relative;
        overflow: hidden;
    }

    .card-header-modern::before {
        content: '';
        position: absolute;
        top: -50%;
        left: -50%;
        width: 200%;
        height: 200%;
        background: radial-gradient(circle, rgba(255,255,255,0.1) 0%, transparent 70%);
        animation: shimmer 3s ease-in-out infinite;
    }

    @keyframes shimmer {
        0%, 100% { transform: rotate(0deg); }
        50% { transform: rotate(180deg); }
    }

    .header-icon {
        width: 80px;
        height: 80px;
        background: rgba(255, 255, 255, 0.2);
        border-radius: 20px;
        display: flex;
        align-items: center;
        justify-content: center;
        margin: 0 auto 1rem;
        font-size: 2rem;
        position: relative;
        z-index: 2;
    }

    .header-title {
        font-size: 1.75rem;
        font-weight: 700;
        margin-bottom: 0.5rem;
        position: relative;
        z-index: 2;
    }

    .header-subtitle {
        font-size: 1rem;
        opacity: 0.9;
        position: relative;
        z-index: 2;
    }

    .card-body-modern {
        padding: 2.5rem;
    }

    /* Security Info Section */
    .security-info {
        background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);
        border-radius: 16px;
        padding: 1.5rem;
        margin-bottom: 2rem;
        border: 1px solid #e2e8f0;
    }

    .security-info-title {
        font-size: 1.1rem;
        font-weight: 600;
        color: #2d3748;
        margin-bottom: 1rem;
        display: flex;
        align-items: center;
        gap: 0.5rem;
    }

    .security-stats {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
        gap: 1rem;
    }

    .security-stat {
        background: white;
        padding: 1rem;
        border-radius: 12px;
        border: 1px solid #e2e8f0;
        text-align: center;
        transition: all 0.3s ease;
    }

    .security-stat:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
    }

    .stat-icon {
        width: 40px;
        height: 40px;
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        border-radius: 10px;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        margin: 0 auto 0.5rem;
        font-size: 1.1rem;
    }

    .stat-value {
        font-size: 1rem;
        font-weight: 600;
        color: #2d3748;
        margin-bottom: 0.25rem;
    }

    .stat-label {
        font-size: 0.875rem;
        color: #718096;
    }

    /* Form Styles */
    .form-group-modern {
        margin-bottom: 1.5rem;
        position: relative;
    }

    .form-label-modern {
        font-size: 0.875rem;
        font-weight: 600;
        color: #2d3748;
        margin-bottom: 0.5rem;
        display: flex;
        align-items: center;
        gap: 0.5rem;
    }

    .required-star {
        color: #e53e3e;
        font-size: 0.75rem;
    }

    .input-wrapper-modern {
        position: relative;
        display: flex;
        align-items: center;
    }

    .input-icon {
        position: absolute;
        right: 1rem;
        color: #718096;
        font-size: 1rem;
        z-index: 3;
        transition: all 0.3s ease;
    }

    .form-control-modern {
        width: 100%;
        padding: 1rem 3rem 1rem 1rem;
        border: 2px solid #e2e8f0;
        border-radius: 12px;
        font-size: 1rem;
        background: white;
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        font-family: 'IRANSans', sans-serif;
    }

    .form-control-modern:focus {
        outline: none;
        border-color: #667eea;
        box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
        transform: translateY(-1px);
    }

    .form-control-modern:focus + .input-icon {
        color: #667eea;
        transform: scale(1.1);
    }

    .password-toggle {
        position: absolute;
        left: 1rem;
        background: none;
        border: none;
        color: #718096;
        cursor: pointer;
        font-size: 1rem;
        z-index: 3;
        transition: all 0.3s ease;
    }

    .password-toggle:hover {
        color: #667eea;
        transform: scale(1.1);
    }

    /* Password Strength Indicator */
    .password-strength {
        margin-top: 0.75rem;
    }

    .strength-bar {
        height: 6px;
        background: #e2e8f0;
        border-radius: 3px;
        overflow: hidden;
        margin-bottom: 0.5rem;
    }

    .strength-fill {
        height: 100%;
        border-radius: 3px;
        transition: all 0.3s ease;
        background: linear-gradient(90deg, #e53e3e 0%, #dd6b20 25%, #d69e2e 50%, #38a169 75%, #38a169 100%);
        width: 0%;
    }

    .strength-text {
        font-size: 0.875rem;
        font-weight: 500;
        text-align: center;
        transition: all 0.3s ease;
    }

    .password-requirements {
        margin-top: 1rem;
        padding: 1rem;
        background: #f7fafc;
        border-radius: 8px;
        border: 1px solid #e2e8f0;
    }

    .requirement {
        display: flex;
        align-items: center;
        gap: 0.5rem;
        font-size: 0.875rem;
        color: #718096;
        margin-bottom: 0.5rem;
        transition: all 0.3s ease;
    }

    .requirement:last-child {
        margin-bottom: 0;
    }

    .requirement.valid {
        color: #38a169;
    }

    .requirement i {
        width: 16px;
        text-align: center;
    }

    /* Password Match Indicator */
    .password-match {
        margin-top: 0.5rem;
        font-size: 0.875rem;
        font-weight: 500;
        display: flex;
        align-items: center;
        gap: 0.5rem;
        transition: all 0.3s ease;
    }

    .password-match.match {
        color: #38a169;
    }

    .password-match.no-match {
        color: #e53e3e;
    }

    /* Alert Styles */
    .alert-modern {
        background: linear-gradient(135deg, #fed7d7 0%, #feb2b2 100%);
        border: 1px solid #fc8181;
        border-radius: 12px;
        padding: 1rem 1.5rem;
        margin-bottom: 2rem;
        display: flex;
        align-items: center;
        gap: 1rem;
        animation: slideInLeft 0.5s ease-out;
    }

    @keyframes slideInLeft {
        from {
            opacity: 0;
            transform: translateX(-20px);
        }
        to {
            opacity: 1;
            transform: translateX(0);
        }
    }

    .alert-icon {
        width: 40px;
        height: 40px;
        background: #e53e3e;
        color: white;
        border-radius: 10px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 1.1rem;
        flex-shrink: 0;
    }

    .alert-content {
        flex: 1;
    }

    .alert-title {
        font-weight: 600;
        color: #742a2a;
        margin-bottom: 0.25rem;
    }

    .alert-text {
        color: #742a2a;
        margin: 0;
    }

    /* Button Styles */
    .btn-group-modern {
        display: flex;
        gap: 1rem;
        justify-content: space-between;
        margin-top: 2rem;
    }

    .btn-modern {
        padding: 1rem 2rem;
        border-radius: 12px;
        font-size: 1rem;
        font-weight: 600;
        border: none;
        cursor: pointer;
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        display: flex;
        align-items: center;
        gap: 0.5rem;
        text-decoration: none;
        position: relative;
        overflow: hidden;
    }

    .btn-modern::before {
        content: '';
        position: absolute;
        top: 0;
        left: -100%;
        width: 100%;
        height: 100%;
        background: linear-gradient(90deg, transparent, rgba(255,255,255,0.2), transparent);
        transition: left 0.5s ease;
    }

    .btn-modern:hover::before {
        left: 100%;
    }

    .btn-secondary-modern {
        background: linear-gradient(135deg, #718096 0%, #4a5568 100%);
        color: white;
    }

    .btn-secondary-modern:hover {
        transform: translateY(-2px);
        box-shadow: 0 8px 25px rgba(113, 128, 150, 0.3);
        color: white;
    }

    .btn-primary-modern {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
    }

    .btn-primary-modern:hover {
        transform: translateY(-2px);
        box-shadow: 0 8px 25px rgba(102, 126, 234, 0.3);
        color: white;
    }

    .btn-primary-modern:disabled {
        opacity: 0.6;
        cursor: not-allowed;
        transform: none;
        box-shadow: none;
    }

    .btn-loading {
        position: relative;
    }

    .btn-loading::after {
        content: '';
        position: absolute;
        width: 16px;
        height: 16px;
        margin: auto;
        border: 2px solid transparent;
        border-top-color: #ffffff;
        border-radius: 50%;
        animation: spin 1s linear infinite;
        top: 0;
        left: 0;
        bottom: 0;
        right: 0;
    }

    @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }

    /* Error Styles */
    .error-message {
        color: #e53e3e;
        font-size: 0.875rem;
        margin-top: 0.5rem;
        display: flex;
        align-items: center;
        gap: 0.5rem;
        animation: shake 0.5s ease-in-out;
    }

    @keyframes shake {
        0%, 100% { transform: translateX(0); }
        25% { transform: translateX(-5px); }
        75% { transform: translateX(5px); }
    }

    /* Responsive Design */
    @media (max-width: 768px) {
        .change-password-container {
            padding: 1rem 0;
        }

        .password-change-card {
            margin: 0 1rem;
            border-radius: 16px;
        }

        .card-header-modern,
        .card-body-modern {
            padding: 1.5rem;
        }

        .header-icon {
            width: 60px;
            height: 60px;
            font-size: 1.5rem;
        }

        .header-title {
            font-size: 1.5rem;
        }

        .security-stats {
            grid-template-columns: 1fr;
        }

        .btn-group-modern {
            flex-direction: column;
        }

        .btn-modern {
            justify-content: center;
        }
    }

    /* Dark mode support */
    @media (prefers-color-scheme: dark) {
        .password-change-card {
            background: rgba(26, 32, 44, 0.95);
            color: #e2e8f0;
        }

        .security-info {
            background: linear-gradient(135deg, #2d3748 0%, #4a5568 100%);
            border-color: #4a5568;
        }

        .security-stat {
            background: #2d3748;
            border-color: #4a5568;
            color: #e2e8f0;
        }

        .form-control-modern {
            background: #2d3748;
            border-color: #4a5568;
            color: #e2e8f0;
        }

        .password-requirements {
            background: #2d3748;
            border-color: #4a5568;
        }
    }
</style>
@endsection

@section('content')
<div class="change-password-container">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-8 col-xl-6">
                <div class="password-change-card">
                    <!-- Card Header -->
                    <div class="card-header-modern">
                        <div class="header-icon">
                            <i class="fas fa-shield-alt"></i>
                        </div>
                        <h1 class="header-title">تغییر رمز عبور</h1>
                        <p class="header-subtitle">امنیت حساب کاربری خود را تقویت کنید</p>
                    </div>

                    <!-- Card Body -->
                    <div class="card-body-modern">
                        <!-- Security Information -->
                        <div class="security-info">
                            <h3 class="security-info-title">
                                <i class="fas fa-info-circle"></i>
                                اطلاعات امنیتی حساب
                            </h3>
                            <div class="security-stats">
                                <div class="security-stat">
                                    <div class="stat-icon">
                                        <i class="fas fa-clock"></i>
                                    </div>
                                    <div class="stat-value">
                                        @if(Auth::user()->password_updated_at)
                                            @dateRelative(Auth::user()->password_updated_at)
                                        @else
                                            هرگز
                                        @endif
                                    </div>
                                    <div class="stat-label">آخرین تغییر رمز</div>
                                </div>
                                <div class="security-stat">
                                    <div class="stat-icon">
                                        <i class="fas fa-sign-in-alt"></i>
                                    </div>
                                    <div class="stat-value">
                                        @if(Auth::user()->last_login)
                                            @dateRelative(Auth::user()->last_login)
                                        @else
                                            هرگز
                                        @endif
                                    </div>
                                    <div class="stat-label">آخرین ورود</div>
                                </div>
                                <div class="security-stat">
                                    <div class="stat-icon">
                                        <i class="fas fa-globe"></i>
                                    </div>
                                    <div class="stat-value">
                                        {{ Auth::user()->last_login_ip ?? 'نامشخص' }}
                                    </div>
                                    <div class="stat-label">آخرین IP</div>
                                </div>
                                <div class="security-stat">
                                    <div class="stat-icon">
                                        <i class="fas fa-calendar-alt"></i>
                                    </div>
                                    <div class="stat-value">
                                        @dateRelative(Auth::user()->created_at)
                                    </div>
                                    <div class="stat-label">عضویت از</div>
                                </div>
                            </div>
                        </div>

                        <!-- Change Password Form -->
                        <form method="POST" action="{{ route('user.password.change') }}" id="changePasswordForm">
                            @csrf

                            <!-- Current Password -->
                            <div class="form-group-modern">
                                <label for="current_password" class="form-label-modern">
                                    <i class="fas fa-lock"></i>
                                    رمز عبور فعلی
                                    <span class="required-star">*</span>
                                </label>
                                <div class="input-wrapper-modern">
                                    <input type="password"
                                           name="current_password"
                                           id="current_password"
                                           class="form-control-modern @error('current_password') is-invalid @enderror"
                                           required
                                           autocomplete="current-password"
                                           placeholder="رمز عبور فعلی خود را وارد کنید">
                                    <i class="fas fa-lock input-icon"></i>
                                    <button type="button" class="password-toggle" data-target="current_password">
                                        <i class="fas fa-eye"></i>
                                    </button>
                                </div>
                                @error('current_password')
                                    <div class="error-message">
                                        <i class="fas fa-exclamation-circle"></i>
                                        {{ $message }}
                                    </div>
                                @enderror
                            </div>

                            <!-- New Password -->
                            <div class="form-group-modern">
                                <label for="password" class="form-label-modern">
                                    <i class="fas fa-key"></i>
                                    رمز عبور جدید
                                    <span class="required-star">*</span>
                                </label>
                                <div class="input-wrapper-modern">
                                    <input type="password"
                                           name="password"
                                           id="password"
                                           class="form-control-modern @error('password') is-invalid @enderror"
                                           required
                                           autocomplete="new-password"
                                           placeholder="رمز عبور جدید خود را وارد کنید"
                                           minlength="8">
                                    <i class="fas fa-key input-icon"></i>
                                    <button type="button" class="password-toggle" data-target="password">
                                        <i class="fas fa-eye"></i>
                                    </button>
                                </div>

                                <!-- Password Strength Indicator -->
                                <div class="password-strength">
                                    <div class="strength-bar">
                                        <div class="strength-fill" id="strength-fill"></div>
                                    </div>
                                    <div class="strength-text" id="strength-text">قدرت رمز عبور</div>
                                </div>

                                <!-- Password Requirements -->
                                <div class="password-requirements">
                                    <div class="requirement" id="req-length">
                                        <i class="fas fa-times"></i>
                                        حداقل ۸ کاراکتر
                                    </div>
                                    <div class="requirement" id="req-uppercase">
                                        <i class="fas fa-times"></i>
                                        حداقل یک حرف بزرگ انگلیسی
                                    </div>
                                    <div class="requirement" id="req-lowercase">
                                        <i class="fas fa-times"></i>
                                        حداقل یک حرف کوچک انگلیسی
                                    </div>
                                    <div class="requirement" id="req-number">
                                        <i class="fas fa-times"></i>
                                        حداقل یک عدد
                                    </div>
                                    <div class="requirement" id="req-special">
                                        <i class="fas fa-times"></i>
                                        حداقل یک کاراکتر خاص (!@#$%^&*)
                                    </div>
                                </div>

                                @error('password')
                                    <div class="error-message">
                                        <i class="fas fa-exclamation-circle"></i>
                                        {{ $message }}
                                    </div>
                                @enderror
                            </div>

                            <!-- Confirm Password -->
                            <div class="form-group-modern">
                                <label for="password_confirmation" class="form-label-modern">
                                    <i class="fas fa-check-double"></i>
                                    تکرار رمز عبور جدید
                                    <span class="required-star">*</span>
                                </label>
                                <div class="input-wrapper-modern">
                                    <input type="password"
                                           name="password_confirmation"
                                           id="password_confirmation"
                                           class="form-control-modern @error('password_confirmation') is-invalid @enderror"
                                           required
                                           autocomplete="new-password"
                                           placeholder="رمز عبور جدید را مجدداً وارد کنید">
                                    <i class="fas fa-check-double input-icon"></i>
                                    <button type="button" class="password-toggle" data-target="password_confirmation">
                                        <i class="fas fa-eye"></i>
                                    </button>
                                </div>

                                <!-- Password Match Indicator -->
                                <div class="password-match" id="password-match"></div>

                                @error('password_confirmation')
                                    <div class="error-message">
                                        <i class="fas fa-exclamation-circle"></i>
                                        {{ $message }}
                                    </div>
                                @enderror
                            </div>

                            <!-- Security Warning -->
                            <div class="alert-modern">
                                <div class="alert-icon">
                                    <i class="fas fa-shield-alt"></i>
                                </div>
                                <div class="alert-content">
                                    <div class="alert-title">نکات امنیتی مهم</div>
                                    <p class="alert-text">
                                        پس از تغییر رمز عبور، از تمام دستگاه‌های دیگر خارج خواهید شد و باید مجدداً وارد شوید.
                                        رمز عبور جدید را در مکانی امن نگهداری کنید.
                                    </p>
                                </div>
                            </div>

                            <!-- Form Actions -->
                            <div class="btn-group-modern">
                                <a href="{{ route('user.profile') }}" class="btn-modern btn-secondary-modern">
                                    <i class="fas fa-arrow-right"></i>
                                    بازگشت به پروفایل
                                </a>
                                <button type="submit" class="btn-modern btn-primary-modern" id="submitBtn" disabled>
                                    <i class="fas fa-shield-alt"></i>
                                    <span class="btn-text">تغییر رمز عبور</span>
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Modern Change Password Manager
    class ModernChangePasswordManager {
        constructor() {
            this.form = document.getElementById('changePasswordForm');
            this.currentPasswordInput = document.getElementById('current_password');
            this.passwordInput = document.getElementById('password');
            this.confirmInput = document.getElementById('password_confirmation');
            this.submitBtn = document.getElementById('submitBtn');
            this.strengthFill = document.getElementById('strength-fill');
            this.strengthText = document.getElementById('strength-text');
            this.passwordMatch = document.getElementById('password-match');

            this.requirements = {
                length: document.getElementById('req-length'),
                uppercase: document.getElementById('req-uppercase'),
                lowercase: document.getElementById('req-lowercase'),
                number: document.getElementById('req-number'),
                special: document.getElementById('req-special')
            };

            this.passwordStrength = 0;
            this.isFormValid = false;

            this.init();
        }

        init() {
            this.setupEventListeners();
            this.setupPasswordToggles();
            this.setupFormValidation();
            this.setupAnimations();
        }

        setupEventListeners() {
            // Password strength checking
            if (this.passwordInput) {
                this.passwordInput.addEventListener('input', (e) => {
                    this.checkPasswordStrength(e.target.value);
                    this.checkPasswordMatch();
                    this.updateFormValidation();
                });
            }

            // Password confirmation checking
            if (this.confirmInput) {
                this.confirmInput.addEventListener('input', () => {
                    this.checkPasswordMatch();
                    this.updateFormValidation();
                });
            }

            // Current password validation
            if (this.currentPasswordInput) {
                this.currentPasswordInput.addEventListener('input', () => {
                    this.updateFormValidation();
                });
            }

            // Form submission
            if (this.form) {
                this.form.addEventListener('submit', (e) => {
                    this.handleSubmit(e);
                });
            }

            // Input focus effects
            document.querySelectorAll('.form-control-modern').forEach(input => {
                input.addEventListener('focus', (e) => this.handleInputFocus(e));
                input.addEventListener('blur', (e) => this.handleInputBlur(e));
            });
        }

        setupPasswordToggles() {
            document.querySelectorAll('.password-toggle').forEach(toggle => {
                toggle.addEventListener('click', (e) => {
                    const targetId = e.currentTarget.getAttribute('data-target');
                    const targetInput = document.getElementById(targetId);
                    const icon = e.currentTarget.querySelector('i');

                    if (targetInput.type === 'password') {
                        targetInput.type = 'text';
                        icon.className = 'fas fa-eye-slash';
                    } else {
                        targetInput.type = 'password';
                        icon.className = 'fas fa-eye';
                    }
                });
            });
        }

        setupFormValidation() {
            // Initial validation state
            this.updateFormValidation();
        }

        setupAnimations() {
            // Add entrance animations to form elements
            const formGroups = document.querySelectorAll('.form-group-modern');
            formGroups.forEach((group, index) => {
                group.style.animationDelay = `${index * 0.1}s`;
                group.classList.add('animate-slide-in');
            });
        }

        checkPasswordStrength(password) {
            let score = 0;
            const checks = {
                length: password.length >= 8,
                uppercase: /[A-Z]/.test(password),
                lowercase: /[a-z]/.test(password),
                number: /[0-9]/.test(password),
                special: /[^A-Za-z0-9]/.test(password)
            };

            // Update requirement indicators
            Object.keys(checks).forEach(key => {
                const element = this.requirements[key];
                const icon = element.querySelector('i');

                if (checks[key]) {
                    element.classList.add('valid');
                    icon.className = 'fas fa-check';
                    score += 20;
                } else {
                    element.classList.remove('valid');
                    icon.className = 'fas fa-times';
                }
            });

            // Update strength bar
            this.updateStrengthBar(score);
            this.passwordStrength = score;
        }

        updateStrengthBar(score) {
            const percentage = Math.min(score, 100);
            this.strengthFill.style.width = `${percentage}%`;

            let strengthText = '';
            let strengthClass = '';

            if (score === 0) {
                strengthText = 'قدرت رمز عبور';
                strengthClass = '';
            } else if (score < 40) {
                strengthText = 'ضعیف';
                strengthClass = 'weak';
            } else if (score < 60) {
                strengthText = 'متوسط';
                strengthClass = 'medium';
            } else if (score < 80) {
                strengthText = 'خوب';
                strengthClass = 'good';
            } else {
                strengthText = 'عالی';
                strengthClass = 'excellent';
            }

            this.strengthText.textContent = strengthText;
            this.strengthText.className = `strength-text ${strengthClass}`;
        }

        checkPasswordMatch() {
            const password = this.passwordInput.value;
            const confirm = this.confirmInput.value;

            if (confirm === '') {
                this.passwordMatch.textContent = '';
                this.passwordMatch.className = 'password-match';
                return false;
            }

            if (password === confirm) {
                this.passwordMatch.innerHTML = '<i class="fas fa-check"></i> رمز عبور مطابقت دارد';
                this.passwordMatch.className = 'password-match match';
                return true;
            } else {
                this.passwordMatch.innerHTML = '<i class="fas fa-times"></i> رمز عبور مطابقت ندارد';
                this.passwordMatch.className = 'password-match no-match';
                return false;
            }
        }

        updateFormValidation() {
            const currentPassword = this.currentPasswordInput.value;
            const newPassword = this.passwordInput.value;
            const confirmPassword = this.confirmInput.value;

            const isValid = currentPassword.length > 0 &&
                           newPassword.length >= 8 &&
                           newPassword === confirmPassword &&
                           this.passwordStrength >= 60;

            this.isFormValid = isValid;
            this.submitBtn.disabled = !isValid;

            if (isValid) {
                this.submitBtn.classList.add('valid');
                this.submitBtn.classList.remove('invalid');
            } else {
                this.submitBtn.classList.remove('valid');
                this.submitBtn.classList.add('invalid');
            }
        }

        handleInputFocus(e) {
            const wrapper = e.target.closest('.input-wrapper-modern');
            if (wrapper) {
                wrapper.style.transform = 'scale(1.02)';
                wrapper.style.transition = 'transform 0.2s ease';
            }
        }

        handleInputBlur(e) {
            const wrapper = e.target.closest('.input-wrapper-modern');
            if (wrapper) {
                wrapper.style.transform = 'scale(1)';
            }
        }

        handleSubmit(e) {
            // Add loading state
            this.submitBtn.classList.add('btn-loading');
            this.submitBtn.disabled = true;

            // Update button text
            const btnText = this.submitBtn.querySelector('.btn-text');
            if (btnText) {
                btnText.textContent = 'در حال پردازش...';
            }

            // Validate passwords match
            if (this.passwordInput.value !== this.confirmInput.value) {
                e.preventDefault();
                this.showError('رمز عبور و تکرار آن مطابقت ندارد');
                this.resetSubmitButton();
                return;
            }

            // Check password strength
            if (this.passwordStrength < 60) {
                e.preventDefault();
                this.showError('رمز عبور انتخابی به اندازه کافی قوی نیست');
                this.resetSubmitButton();
                return;
            }

            // Add success animation
            this.addSubmitAnimation();
        }

        resetSubmitButton() {
            this.submitBtn.classList.remove('btn-loading');
            this.submitBtn.disabled = false;

            const btnText = this.submitBtn.querySelector('.btn-text');
            if (btnText) {
                btnText.textContent = 'تغییر رمز عبور';
            }
        }

        showError(message) {
            // Create error notification
            const notification = document.createElement('div');
            notification.className = 'notification error';
            notification.innerHTML = `
                <i class="fas fa-exclamation-circle"></i>
                <div>
                    <strong>خطا!</strong>
                    <p>${message}</p>
                </div>
                <button onclick="this.parentElement.remove()">
                    <i class="fas fa-times"></i>
                </button>
            `;

            // Add to page
            document.body.appendChild(notification);

            // Auto remove after 5 seconds
            setTimeout(() => {
                if (notification.parentElement) {
                    notification.style.animation = 'slideOutLeft 0.3s ease forwards';
                    setTimeout(() => {
                        notification.remove();
                    }, 300);
                }
            }, 5000);
        }

        addSubmitAnimation() {
            // Add ripple effect to submit button
            const ripple = document.createElement('span');
            ripple.className = 'ripple';
            this.submitBtn.appendChild(ripple);

            setTimeout(() => {
                ripple.remove();
            }, 600);
        }
    }

    // Initialize the change password manager
    const changePasswordManager = new ModernChangePasswordManager();

    // Add CSS animations
    const style = document.createElement('style');
    style.textContent = `
        @keyframes animate-slide-in {
            from {
                opacity: 0;
                transform: translateY(20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .animate-slide-in {
            animation: animate-slide-in 0.6s ease-out forwards;
        }

        .strength-text.weak { color: #e53e3e; }
        .strength-text.medium { color: #dd6b20; }
        .strength-text.good { color: #d69e2e; }
        .strength-text.excellent { color: #38a169; }

        .btn-modern.valid {
            background: linear-gradient(135deg, #38a169 0%, #48bb78 100%);
        }

        .btn-modern.invalid {
            opacity: 0.6;
        }

        .ripple {
            position: absolute;
            border-radius: 50%;
            background: rgba(255, 255, 255, 0.6);
            transform: scale(0);
            animation: ripple-animation 0.6s linear;
            pointer-events: none;
        }

        @keyframes ripple-animation {
            to {
                transform: scale(4);
                opacity: 0;
            }
        }

        .notification {
            position: fixed;
            top: 20px;
            left: 20px;
            background: white;
            border-radius: 12px;
            padding: 1rem 1.5rem;
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1);
            border-left: 4px solid #e53e3e;
            display: flex;
            align-items: center;
            gap: 1rem;
            z-index: 10000;
            animation: slideInLeft 0.3s ease;
            max-width: 400px;
        }

        .notification.error {
            border-left-color: #e53e3e;
        }

        .notification i:first-child {
            color: #e53e3e;
            font-size: 1.2rem;
        }

        .notification button {
            background: none;
            border: none;
            color: #718096;
            cursor: pointer;
            font-size: 1rem;
            margin-left: auto;
        }

        .notification button:hover {
            color: #e53e3e;
        }
    `;
    document.head.appendChild(style);
});
</script>
@endsection