@extends('layouts.app')

@section('title', 'دسته‌بندی‌های مکان‌ها')

@section('content')
<div class="container">
    <div class="row mb-4">
        <div class="col-12">
            <div class="card shadow">
                <div class="card-header">
                    <i class="fas fa-th-large me-1"></i>
                    دسته‌بندی‌های مکان‌ها
                </div>
                <div class="card-body">
                    <div class="row">
                        @foreach($categories as $category)
                            <div class="col-md-4 mb-4">
                                <div class="card h-100">
                                    <div class="card-body">
                                        <h5 class="card-title">
                                            @if($category->emoji)
                                                <span class="me-2">{{ $category->emoji }}</span>
                                            @endif
                                            {{ $category->getTranslatedName(app()->getLocale()) }}
                                        </h5>
                                        @if($category->getTranslatedDescription(app()->getLocale()))
                                            <p class="card-text text-muted">{{ $category->getTranslatedDescription(app()->getLocale()) }}</p>
                                        @endif
                                        <a href="{{ route('categories.show', $category->category_key) }}" class="btn btn-primary">
                                            مشاهده مکان‌ها
                                        </a>
                                    </div>
                                    <div class="card-footer bg-transparent">
                                        <a href="{{ url('/?category=' . $category->id) }}" class="btn btn-sm btn-primary">
                                            <i class="fas fa-search me-1"></i>
                                            مشاهده مکان‌ها
                                        </a>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection 