@props(['locationId', 'locationName' => ''])

<div class="rating-form-container">
    <div class="card">
        <div class="card-header bg-primary text-white">
            <h5 class="mb-0">{{ __('ثبت نظر و امتیاز برای') }}: {{ $locationName }}</h5>
        </div>
        <div class="card-body">
            <div id="rating-form-alert-container"></div>
            
            <form id="rating-form" method="post">
                @csrf
                <input type="hidden" name="title_id" value="{{ $locationId }}">
                
                <!-- بخش امتیازدهی کلی -->
                <div class="mb-4 text-center">
                    <label class="form-label fw-bold fs-4">{{ __('امتیاز کلی شما') }}:</label>
                    <div class="rating-stars-input">
                        <div class="d-flex flex-row-reverse justify-content-center">
                            @for ($i = 5; $i >= 1; $i--)
                                <input type="radio" id="star{{ $i }}" name="rating" value="{{ $i }}" class="visually-hidden" {{ old('rating') == $i ? 'checked' : '' }} required>
                                <label for="star{{ $i }}" class="rating-label me-1">
                                    <i class="far fa-star star-icon"></i>
                                </label>
                            @endfor
                        </div>
                    </div>
                    <div class="text-danger mt-1 rating-error" id="rating-error"></div>
                </div>
                
                <!-- اطلاعات بازدیدکننده -->
                <div class="row mb-3">
                    <div class="col-md-4">
                        <div class="mb-3">
                            <label for="name" class="form-label">{{ __('نام شما') }} <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="name" name="name" value="{{ old('name') }}" required>
                            <div class="text-danger mt-1 name-error" id="name-error"></div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="mb-3">
                            <label for="email" class="form-label">{{ __('ایمیل') }}</label>
                            <input type="email" class="form-control" id="email" name="email" value="{{ old('email') }}">
                            <div class="text-danger mt-1 email-error" id="email-error"></div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="mb-3">
                            <label for="trip_type" class="form-label">{{ __('نوع سفر') }}</label>
                            <select class="form-select" id="trip_type" name="trip_type">
                                <option value="">{{ __('انتخاب کنید') }}</option>
                                <option value="business" {{ old('trip_type') == 'business' ? 'selected' : '' }}>{{ __('تجاری') }}</option>
                                <option value="family" {{ old('trip_type') == 'family' ? 'selected' : '' }}>{{ __('خانوادگی') }}</option>
                                <option value="couple" {{ old('trip_type') == 'couple' ? 'selected' : '' }}>{{ __('زوج') }}</option>
                                <option value="solo" {{ old('trip_type') == 'solo' ? 'selected' : '' }}>{{ __('انفرادی') }}</option>
                                <option value="friends" {{ old('trip_type') == 'friends' ? 'selected' : '' }}>{{ __('با دوستان') }}</option>
                            </select>
                            <div class="text-danger mt-1 trip_type-error" id="trip_type-error"></div>
                        </div>
                    </div>
                </div>
                
                <!-- امتیازهای جزئی -->
                <div class="mb-4">
                    <div class="card">
                        <div class="card-header bg-light">
                            <h6 class="mb-0">{{ __('امتیازهای جزئی (اختیاری)') }}</h6>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="service_rating" class="form-label">{{ __('کیفیت خدمات') }}</label>
                                    <select class="form-select" id="service_rating" name="service_rating">
                                        <option value="">{{ __('انتخاب کنید') }}</option>
                                        @for ($i = 5; $i >= 1; $i--)
                                            <option value="{{ $i }}" {{ old('service_rating') == $i ? 'selected' : '' }}>{{ $i }}</option>
                                        @endfor
                                    </select>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="cleanliness_rating" class="form-label">{{ __('نظافت') }}</label>
                                    <select class="form-select" id="cleanliness_rating" name="cleanliness_rating">
                                        <option value="">{{ __('انتخاب کنید') }}</option>
                                        @for ($i = 5; $i >= 1; $i--)
                                            <option value="{{ $i }}" {{ old('cleanliness_rating') == $i ? 'selected' : '' }}>{{ $i }}</option>
                                        @endfor
                                    </select>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="location_rating" class="form-label">{{ __('موقعیت') }}</label>
                                    <select class="form-select" id="location_rating" name="location_rating">
                                        <option value="">{{ __('انتخاب کنید') }}</option>
                                        @for ($i = 5; $i >= 1; $i--)
                                            <option value="{{ $i }}" {{ old('location_rating') == $i ? 'selected' : '' }}>{{ $i }}</option>
                                        @endfor
                                    </select>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="price_rating" class="form-label">{{ __('ارزش نسبت به قیمت') }}</label>
                                    <select class="form-select" id="price_rating" name="price_rating">
                                        <option value="">{{ __('انتخاب کنید') }}</option>
                                        @for ($i = 5; $i >= 1; $i--)
                                            <option value="{{ $i }}" {{ old('price_rating') == $i ? 'selected' : '' }}>{{ $i }}</option>
                                        @endfor
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- کامنت‌ها -->
                <div class="mb-4">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="positive_comment" class="form-label">{{ __('نکات مثبت') }}</label>
                            <textarea class="form-control" id="positive_comment" name="positive_comment" rows="4" placeholder="{{ __('چه چیزهایی را دوست داشتید؟') }}">{{ old('positive_comment') }}</textarea>
                            <div class="text-danger mt-1 positive_comment-error" id="positive_comment-error"></div>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label for="negative_comment" class="form-label">{{ __('نکات منفی') }}</label>
                            <textarea class="form-control" id="negative_comment" name="negative_comment" rows="4" placeholder="{{ __('چه چیزهایی را دوست نداشتید؟') }}">{{ old('negative_comment') }}</textarea>
                            <div class="text-danger mt-1 negative_comment-error" id="negative_comment-error"></div>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label for="comment" class="form-label">{{ __('نظر کلی (اختیاری)') }}</label>
                        <textarea class="form-control" id="comment" name="comment" rows="4" placeholder="{{ __('توضیحات بیشتر...') }}">{{ old('comment') }}</textarea>
                        <div class="text-danger mt-1 comment-error" id="comment-error"></div>
                    </div>
                </div>
                
                <!-- توافق با قوانین -->
                <div class="mb-4">
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" id="terms_accepted" name="terms_accepted" value="1" required {{ old('terms_accepted') ? 'checked' : '' }}>
                        <label class="form-check-label" for="terms_accepted">
                            {{ __('با قوانین و شرایط سایت موافقم و تأیید می‌کنم که این نظر بر اساس تجربه شخصی من است.') }}
                        </label>
                    </div>
                    <div class="text-danger mt-1 terms_accepted-error" id="terms_accepted-error"></div>
                </div>
                
                <div class="text-center">
                    <button type="submit" class="btn btn-primary px-5 py-2 fs-5" id="submit-rating">{{ __('ثبت نظر') }}</button>
                    <div class="spinner-border text-primary d-none mt-3" role="status" id="rating-spinner">
                        <span class="visually-hidden">در حال ارسال...</span>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

@once
    @push('scripts')
    <script>
        $(document).ready(function() {
            // AJAX form submission for rating
            $('#rating-form').on('submit', function(e) {
                e.preventDefault();
                
                // Clear previous error messages
                $('.text-danger').text('');
                $('#rating-form-alert-container').empty();
                
                // Show loading spinner
                $('#submit-rating').prop('disabled', true);
                $('#rating-spinner').removeClass('d-none');
                
                // Submit form with AJAX
                $.ajax({
                    url: "{{ route('reviews.store') }}",
                    type: "POST",
                    data: $(this).serialize(),
                    dataType: 'json',
                    success: function(response) {
                        // Hide spinner
                        $('#rating-spinner').addClass('d-none');
                        $('#submit-rating').prop('disabled', false);
                        
                        // Show success message
                        $('#rating-form-alert-container').html(
                            '<div class="alert alert-success">' +
                            '<i class="fas fa-check-circle me-2"></i>' +
                            'نظر شما با موفقیت ثبت شد و پس از بررسی نمایش داده خواهد شد.' +
                            '</div>'
                        );
                        
                        // Reset form
                        $('#rating-form')[0].reset();
                        
                        // Reset star ratings
                        $('.rating-stars-input .star-icon').removeClass('fas').addClass('far');
                        
                        // Scroll to success message
                        $('html, body').animate({
                            scrollTop: $('#rating-form-alert-container').offset().top - 100
                        }, 500);
                    },
                    error: function(xhr) {
                        // Hide spinner
                        $('#rating-spinner').addClass('d-none');
                        $('#submit-rating').prop('disabled', false);
                        
                        if (xhr.status === 422) {
                            // Validation errors
                            var errors = xhr.responseJSON.errors;
                            $.each(errors, function(key, value) {
                                $('#' + key + '-error').text(value[0]);
                            });
                        } else {
                            // Server error
                            $('#rating-form-alert-container').html(
                                '<div class="alert alert-danger">' +
                                '<i class="fas fa-exclamation-circle me-2"></i>' +
                                'خطا در ثبت نظر. لطفا مجددا تلاش کنید.' +
                                '</div>'
                            );
                        }
                    }
                });
            });
        });
    </script>
    @endpush
@endonce 