<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>تست صفحه لاگین مدرن - Laravel</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.rtl.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <link rel="stylesheet" href="{{ asset('css/fonts.css') }}">
    <style>
        body {
            font-family: 'IRANSans', Arial, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 20px;
        }
        .test-container {
            max-width: 1000px;
            margin: 0 auto;
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            padding: 30px;
            border-radius: 20px;
            box-shadow: 0 20px 40px rgba(0,0,0,0.1);
        }
        .test-card {
            background: white;
            margin: 20px 0;
            padding: 20px;
            border-radius: 15px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
            border-right: 4px solid #667eea;
        }
        .test-success {
            border-right-color: #28a745;
            background: linear-gradient(135deg, #d4edda 0%, #c3e6cb 100%);
        }
        .test-error {
            border-right-color: #dc3545;
            background: linear-gradient(135deg, #f8d7da 0%, #f5c6cb 100%);
        }
        .test-warning {
            border-right-color: #ffc107;
            background: linear-gradient(135deg, #fff3cd 0%, #ffeaa7 100%);
        }
        .btn-modern {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            color: white;
            padding: 12px 25px;
            border-radius: 10px;
            font-weight: 600;
            transition: all 0.3s ease;
            margin: 5px;
        }
        .btn-modern:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 20px rgba(102, 126, 234, 0.3);
            color: white;
        }
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 15px;
            margin: 20px 0;
        }
        .stat-box {
            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
            padding: 20px;
            border-radius: 15px;
            text-align: center;
            border: 1px solid #dee2e6;
            transition: all 0.3s ease;
        }
        .stat-box:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 25px rgba(0,0,0,0.1);
        }
        .stat-number {
            font-size: 28px;
            font-weight: bold;
            color: #667eea;
            margin-bottom: 5px;
        }
        .stat-label {
            font-size: 14px;
            color: #6c757d;
        }
        .status-indicator {
            width: 12px;
            height: 12px;
            border-radius: 50%;
            display: inline-block;
            margin-left: 8px;
        }
        .status-online { background: #28a745; box-shadow: 0 0 10px #28a745; }
        .status-offline { background: #dc3545; box-shadow: 0 0 10px #dc3545; }
        .status-warning { background: #ffc107; box-shadow: 0 0 10px #ffc107; }
        .test-result {
            margin: 10px 0;
            padding: 10px 15px;
            border-radius: 8px;
            font-size: 14px;
        }
        .result-success { background: #d4edda; color: #155724; border: 1px solid #c3e6cb; }
        .result-error { background: #f8d7da; color: #721c24; border: 1px solid #f5c6cb; }
        .result-info { background: #d1ecf1; color: #0c5460; border: 1px solid #bee5eb; }
        .loading {
            display: inline-block;
            width: 20px;
            height: 20px;
            border: 3px solid #f3f3f3;
            border-top: 3px solid #667eea;
            border-radius: 50%;
            animation: spin 1s linear infinite;
        }
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
    </style>
</head>
<body>
    <div class="test-container">
        <div class="text-center mb-4">
            <h1 class="text-white mb-3">
                <i class="fas fa-cogs"></i>
                تست صفحه لاگین مدرن ادمین
            </h1>
            <p class="text-white-50">بررسی کامل عملکرد و طراحی</p>
        </div>

        <!-- وضعیت سیستم -->
        <div class="test-card">
            <h3><i class="fas fa-server text-primary"></i> وضعیت سیستم</h3>
            <div class="row">
                <div class="col-md-3">
                    <div class="d-flex align-items-center">
                        <span class="status-indicator status-online"></span>
                        <span>سرور Laravel</span>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="d-flex align-items-center">
                        <span class="status-indicator status-{{ \DB::connection()->getPdo() ? 'online' : 'offline' }}"></span>
                        <span>پایگاه داده</span>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="d-flex align-items-center">
                        <span class="status-indicator status-online"></span>
                        <span>فایل‌های Static</span>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="d-flex align-items-center">
                        <span class="status-indicator status-online"></span>
                        <span>API آمار</span>
                    </div>
                </div>
            </div>
        </div>

        <!-- آمار فعلی -->
        <div class="test-card">
            <h3><i class="fas fa-chart-bar text-success"></i> آمار فعلی سیستم</h3>
            <div class="stats-grid">
                <div class="stat-box">
                    <div class="stat-number">{{ \App\Models\Location::count() }}</div>
                    <div class="stat-label">مکان‌ها</div>
                </div>
                <div class="stat-box">
                    <div class="stat-number">{{ \App\Models\User::count() }}</div>
                    <div class="stat-label">کاربران</div>
                </div>
                <div class="stat-box">
                    <div class="stat-number">{{ \App\Models\Rating::count() }}</div>
                    <div class="stat-label">رتبه‌بندی‌ها</div>
                </div>
                <div class="stat-box">
                    <div class="stat-number">{{ \App\Models\Category::count() }}</div>
                    <div class="stat-label">دسته‌بندی‌ها</div>
                </div>
            </div>
        </div>

        <!-- تست‌های فایل -->
        <div class="test-card">
            <h3><i class="fas fa-file-code text-info"></i> تست فایل‌ها</h3>
            <div class="row">
                <div class="col-md-6">
                    <h5>فایل‌های CSS:</h5>
                    <div class="test-result result-{{ file_exists(public_path('css/fonts.css')) ? 'success' : 'error' }}">
                        <i class="fas fa-{{ file_exists(public_path('css/fonts.css')) ? 'check' : 'times' }}"></i>
                        fonts.css {{ file_exists(public_path('css/fonts.css')) ? '✓' : '✗' }}
                    </div>
                    <div class="test-result result-{{ file_exists(public_path('css/admin-login-modern.css')) ? 'success' : 'error' }}">
                        <i class="fas fa-{{ file_exists(public_path('css/admin-login-modern.css')) ? 'check' : 'times' }}"></i>
                        admin-login-modern.css {{ file_exists(public_path('css/admin-login-modern.css')) ? '✓' : '✗' }}
                    </div>
                </div>
                <div class="col-md-6">
                    <h5>فایل‌های JavaScript:</h5>
                    <div class="test-result result-{{ file_exists(public_path('js/admin-login-modern.js')) ? 'success' : 'error' }}">
                        <i class="fas fa-{{ file_exists(public_path('js/admin-login-modern.js')) ? 'check' : 'times' }}"></i>
                        admin-login-modern.js {{ file_exists(public_path('js/admin-login-modern.js')) ? '✓' : '✗' }}
                    </div>
                </div>
            </div>
        </div>

        <!-- تست‌های عملکردی -->
        <div class="test-card">
            <h3><i class="fas fa-play-circle text-warning"></i> تست‌های عملکردی</h3>
            <div class="mb-3">
                <button class="btn btn-modern" onclick="testAPI()">
                    <i class="fas fa-api"></i> تست API آمار
                </button>
                <button class="btn btn-modern" onclick="testAssets()">
                    <i class="fas fa-file"></i> تست فایل‌های Static
                </button>
                <button class="btn btn-modern" onclick="testResponsive()">
                    <i class="fas fa-mobile-alt"></i> تست Responsive
                </button>
                <button class="btn btn-modern" onclick="openLoginPage()">
                    <i class="fas fa-external-link-alt"></i> باز کردن صفحه لاگین
                </button>
            </div>
            <div id="test-results"></div>
        </div>

        <!-- نتیجه نهایی -->
        <div class="test-card test-success">
            <h3><i class="fas fa-trophy text-warning"></i> نتیجه نهایی</h3>
            <p class="mb-3">صفحه لاگین ادمین با موفقیت طراحی و پیاده‌سازی شده است!</p>
            <div class="row">
                <div class="col-md-6">
                    <h6>ویژگی‌های پیاده‌سازی شده:</h6>
                    <ul class="list-unstyled">
                        <li><i class="fas fa-check text-success"></i> طراحی مدرن Glassmorphism</li>
                        <li><i class="fas fa-check text-success"></i> آمار پویا از دیتابیس</li>
                        <li><i class="fas fa-check text-success"></i> انیمیشن‌های تعاملی</li>
                        <li><i class="fas fa-check text-success"></i> طراحی واکنش‌گرا</li>
                    </ul>
                </div>
                <div class="col-md-6">
                    <h6>تکنولوژی‌های استفاده شده:</h6>
                    <ul class="list-unstyled">
                        <li><i class="fas fa-check text-success"></i> Laravel Blade Templates</li>
                        <li><i class="fas fa-check text-success"></i> CSS3 Advanced Features</li>
                        <li><i class="fas fa-check text-success"></i> JavaScript ES6+</li>
                        <li><i class="fas fa-check text-success"></i> Bootstrap 5 RTL</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <script>
        // تست API
        async function testAPI() {
            showLoading('در حال تست API...');
            try {
                const response = await fetch('/admin/api/quick-stats');
                const data = await response.json();
                
                if (response.ok) {
                    showResult('✅ API آمار با موفقیت کار می‌کند', 'success');
                    showResult(`📊 آمار دریافت شده: ${data.locations} مکان، ${data.users} کاربر`, 'info');
                } else {
                    showResult('❌ خطا در API: ' + (data.error || 'نامشخص'), 'error');
                }
            } catch (error) {
                showResult('❌ خطا در اتصال به API: ' + error.message, 'error');
            }
        }

        // تست فایل‌های Static
        async function testAssets() {
            showLoading('در حال تست فایل‌ها...');
            const files = [
                '/css/fonts.css',
                '/css/admin-login-modern.css',
                '/js/admin-login-modern.js'
            ];
            
            for (const file of files) {
                try {
                    const response = await fetch(file);
                    if (response.ok) {
                        showResult(`✅ ${file} در دسترس است`, 'success');
                    } else {
                        showResult(`❌ ${file} در دسترس نیست (${response.status})`, 'error');
                    }
                } catch (error) {
                    showResult(`❌ خطا در دسترسی به ${file}`, 'error');
                }
            }
        }

        // تست Responsive
        function testResponsive() {
            const sizes = [
                { width: 1200, height: 800, name: 'دسکتاپ' },
                { width: 768, height: 1024, name: 'تبلت' },
                { width: 375, height: 667, name: 'موبایل' }
            ];
            
            sizes.forEach((size, index) => {
                setTimeout(() => {
                    window.open(
                        '/fa/admin/login',
                        `responsive_test_${size.name}`,
                        `width=${size.width},height=${size.height},scrollbars=yes,resizable=yes`
                    );
                }, index * 500);
            });
            
            showResult('🖥️ پنجره‌های تست Responsive باز شدند', 'info');
        }

        // باز کردن صفحه لاگین
        function openLoginPage() {
            window.open('/fa/admin/login', '_blank');
            showResult('🚀 صفحه لاگین در تب جدید باز شد', 'info');
        }

        // نمایش نتیجه
        function showResult(message, type) {
            const resultDiv = document.createElement('div');
            resultDiv.className = `test-result result-${type}`;
            resultDiv.innerHTML = message;
            document.getElementById('test-results').appendChild(resultDiv);
            
            // حذف خودکار بعد از 10 ثانیه
            setTimeout(() => {
                if (resultDiv.parentNode) {
                    resultDiv.remove();
                }
            }, 10000);
        }

        // نمایش loading
        function showLoading(message) {
            const loadingDiv = document.createElement('div');
            loadingDiv.className = 'test-result result-info';
            loadingDiv.innerHTML = `<span class="loading"></span> ${message}`;
            loadingDiv.id = 'loading-indicator';
            
            // حذف loading قبلی
            const existingLoading = document.getElementById('loading-indicator');
            if (existingLoading) {
                existingLoading.remove();
            }
            
            document.getElementById('test-results').appendChild(loadingDiv);
            
            // حذف خودکار بعد از 5 ثانیه
            setTimeout(() => {
                if (loadingDiv.parentNode) {
                    loadingDiv.remove();
                }
            }, 5000);
        }

        // تست خودکار هنگام بارگذاری
        window.addEventListener('load', () => {
            setTimeout(() => {
                testAPI();
            }, 1000);
        });
    </script>
</body>
</html>
