@extends('admin.layouts.app')

@section('title', 'تنظیمات پرداخت')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">تنظیمات پرداخت</h3>
                </div>
                <div class="card-body">
                    <form action="{{ route('admin.settings.store') }}" method="POST">
                        @csrf
                        
                        <!-- تنظیمات درگاه پرداخت -->
                        <h4 class="mb-3">تنظیمات درگاه پرداخت</h4>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="payment_gateway">درگاه پرداخت پیش‌فرض</label>
                                    <select class="form-control @error('payment_gateway') is-invalid @enderror" 
                                            id="payment_gateway" name="payment_gateway">
                                        <option value="zarinpal" {{ ($settings['payment_gateway'] ?? old('payment_gateway')) == 'zarinpal' ? 'selected' : '' }}>زرین‌پال</option>
                                        <option value="nextpay" {{ ($settings['payment_gateway'] ?? old('payment_gateway')) == 'nextpay' ? 'selected' : '' }}>نکست‌پی</option>
                                        <option value="idpay" {{ ($settings['payment_gateway'] ?? old('payment_gateway')) == 'idpay' ? 'selected' : '' }}>آیدی پی</option>
                                    </select>
                                    @error('payment_gateway')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="payment_currency">واحد پول</label>
                                    <select class="form-control @error('payment_currency') is-invalid @enderror" 
                                            id="payment_currency" name="payment_currency">
                                        <option value="IRR" {{ ($settings['payment_currency'] ?? old('payment_currency')) == 'IRR' ? 'selected' : '' }}>ریال</option>
                                        <option value="IRT" {{ ($settings['payment_currency'] ?? old('payment_currency')) == 'IRT' ? 'selected' : '' }}>تومان</option>
                                    </select>
                                    @error('payment_currency')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <!-- تنظیمات زرین‌پال -->
                        <h4 class="mb-3 mt-4">تنظیمات زرین‌پال</h4>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="zarinpal_merchant_id">مرچنت آیدی</label>
                                    <input type="text" class="form-control @error('zarinpal_merchant_id') is-invalid @enderror" 
                                           id="zarinpal_merchant_id" name="zarinpal_merchant_id" 
                                           value="{{ $settings['zarinpal_merchant_id'] ?? old('zarinpal_merchant_id') }}">
                                    @error('zarinpal_merchant_id')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="zarinpal_sandbox">حالت تست</label>
                                    <select class="form-control @error('zarinpal_sandbox') is-invalid @enderror" 
                                            id="zarinpal_sandbox" name="zarinpal_sandbox">
                                        <option value="1" {{ ($settings['zarinpal_sandbox'] ?? old('zarinpal_sandbox')) == '1' ? 'selected' : '' }}>فعال</option>
                                        <option value="0" {{ ($settings['zarinpal_sandbox'] ?? old('zarinpal_sandbox')) == '0' ? 'selected' : '' }}>غیرفعال</option>
                                    </select>
                                    @error('zarinpal_sandbox')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <!-- تنظیمات نکست‌پی -->
                        <h4 class="mb-3 mt-4">تنظیمات نکست‌پی</h4>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="nextpay_api_key">کلید API</label>
                                    <input type="text" class="form-control @error('nextpay_api_key') is-invalid @enderror" 
                                           id="nextpay_api_key" name="nextpay_api_key" 
                                           value="{{ $settings['nextpay_api_key'] ?? old('nextpay_api_key') }}">
                                    @error('nextpay_api_key')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="nextpay_sandbox">حالت تست</label>
                                    <select class="form-control @error('nextpay_sandbox') is-invalid @enderror" 
                                            id="nextpay_sandbox" name="nextpay_sandbox">
                                        <option value="1" {{ ($settings['nextpay_sandbox'] ?? old('nextpay_sandbox')) == '1' ? 'selected' : '' }}>فعال</option>
                                        <option value="0" {{ ($settings['nextpay_sandbox'] ?? old('nextpay_sandbox')) == '0' ? 'selected' : '' }}>غیرفعال</option>
                                    </select>
                                    @error('nextpay_sandbox')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <!-- تنظیمات آیدی پی -->
                        <h4 class="mb-3 mt-4">تنظیمات آیدی پی</h4>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="idpay_api_key">کلید API</label>
                                    <input type="text" class="form-control @error('idpay_api_key') is-invalid @enderror" 
                                           id="idpay_api_key" name="idpay_api_key" 
                                           value="{{ $settings['idpay_api_key'] ?? old('idpay_api_key') }}">
                                    @error('idpay_api_key')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="idpay_sandbox">حالت تست</label>
                                    <select class="form-control @error('idpay_sandbox') is-invalid @enderror" 
                                            id="idpay_sandbox" name="idpay_sandbox">
                                        <option value="1" {{ ($settings['idpay_sandbox'] ?? old('idpay_sandbox')) == '1' ? 'selected' : '' }}>فعال</option>
                                        <option value="0" {{ ($settings['idpay_sandbox'] ?? old('idpay_sandbox')) == '0' ? 'selected' : '' }}>غیرفعال</option>
                                    </select>
                                    @error('idpay_sandbox')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <!-- دکمه‌های عملیات -->
                        <div class="row mt-4">
                            <div class="col-12">
                                <button type="submit" class="btn btn-primary">ذخیره تنظیمات</button>
                                <a href="{{ route('admin.settings.index') }}" class="btn btn-secondary">بازگشت</a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection 