@extends('admin.layouts.app')

@section('title', 'تنظیمات امنیتی')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">تنظیمات امنیتی</h3>
                </div>
                <div class="card-body">
                    <!-- تب‌های گروه‌های تنظیمات -->
                    <ul class="nav nav-tabs" id="securityTabs" role="tablist">
                        @foreach($groups as $groupKey => $groupTitle)
                            <li class="nav-item" role="presentation">
                                <button class="nav-link {{ $loop->first ? 'active' : '' }}" 
                                        id="{{ $groupKey }}-tab" 
                                        data-bs-toggle="tab" 
                                        data-bs-target="#{{ $groupKey }}" 
                                        type="button" 
                                        role="tab" 
                                        aria-controls="{{ $groupKey }}" 
                                        aria-selected="{{ $loop->first ? 'true' : 'false' }}">
                                    {{ $groupTitle }}
                                </button>
                            </li>
                        @endforeach
                    </ul>

                    <!-- محتوای تب‌ها -->
                    <div class="tab-content mt-4" id="securityTabsContent">
                        @foreach($groups as $groupKey => $groupTitle)
                            <div class="tab-pane fade {{ $loop->first ? 'show active' : '' }}" 
                                 id="{{ $groupKey }}" 
                                 role="tabpanel" 
                                 aria-labelledby="{{ $groupKey }}-tab">
                                <form class="security-settings-form" data-group="{{ $groupKey }}">
                                    @csrf
                                    <div class="table-responsive">
                                        <table class="table table-bordered">
                                            <thead>
                                                <tr>
                                                    <th>تنظیم</th>
                                                    <th>مقدار</th>
                                                    <th>وضعیت</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($settings[$groupKey] as $setting)
                                                    <tr>
                                                        <td>
                                                            <strong>{{ $setting->description }}</strong>
                                                            <small class="d-block text-muted">{{ $setting->key }}</small>
                                                        </td>
                                                        <td>
                                                            @if($setting->options)
                                                                <select name="settings[{{ $setting->id }}][value]" 
                                                                        class="form-control">
                                                                    @foreach(json_decode($setting->options, true) as $value => $label)
                                                                        <option value="{{ $value }}" 
                                                                                {{ $setting->value == $value ? 'selected' : '' }}>
                                                                            {{ $label }}
                                                                        </option>
                                                                    @endforeach
                                                                </select>
                                                            @else
                                                                <input type="text" 
                                                                       class="form-control"
                                                                       name="settings[{{ $setting->id }}][value]"
                                                                       value="{{ $setting->value }}">
                                                            @endif
                                                        </td>
                                                        <td>
                                                            <div class="form-check form-switch">
                                                                <input type="checkbox" 
                                                                       class="form-check-input setting-status"
                                                                       id="status_{{ $setting->id }}"
                                                                       {{ $setting->is_active ? 'checked' : '' }}
                                                                       data-group="{{ $setting->group }}"
                                                                       data-key="{{ $setting->key }}">
                                                                <label class="form-check-label" 
                                                                       for="status_{{ $setting->id }}">
                                                                    {{ $setting->is_active ? 'فعال' : 'غیرفعال' }}
                                                                </label>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                    <div class="text-left mt-3">
                                        <button type="submit" class="btn btn-primary">
                                            ذخیره تنظیمات
                                        </button>
                                    </div>
                                </form>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.nav-tabs .nav-link {
    color: #4e73df;
    background-color: #f8f9fc;
    border: 1px solid #e3e6f0;
    border-bottom: none;
    margin-bottom: -1px;
    padding: 0.75rem 1.25rem;
    font-weight: 500;
}

.nav-tabs .nav-link.active {
    color: #4e73df;
    background-color: #fff;
    border-color: #e3e6f0 #e3e6f0 #fff;
}

.nav-tabs .nav-link:hover {
    border-color: #e3e6f0 #e3e6f0 #e3e6f0;
    isolation: isolate;
}

.tab-content {
    background-color: #fff;
    border: 1px solid #e3e6f0;
    border-top: none;
    padding: 1.25rem;
}

.form-check-input:checked {
    background-color: #4e73df;
    border-color: #4e73df;
}

/* Dark mode styles */
.dark-mode .nav-tabs .nav-link {
    color: #e0e0e0;
    background-color: #2d2d2d;
    border-color: #333;
}

.dark-mode .nav-tabs .nav-link.active {
    color: #4e73df;
    background-color: #1e1e1e;
    border-color: #333 #333 #1e1e1e;
}

.dark-mode .nav-tabs .nav-link:hover {
    border-color: #333 #333 #333;
}

.dark-mode .tab-content {
    background-color: #1e1e1e;
    border-color: #333;
    color: #e0e0e0;
}
</style>
@endsection

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // مدیریت فرم‌های تنظیمات
    document.querySelectorAll('.security-settings-form').forEach(form => {
        form.addEventListener('submit', async function(e) {
            e.preventDefault();
            
            try {
                const response = await fetch('{{ route("admin.security-settings.update") }}', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
                    },
                    body: JSON.stringify(Object.fromEntries(new FormData(form)))
                });
                
                const result = await response.json();
                
                if (response.ok) {
                    Swal.fire({
                        title: 'موفق',
                        text: result.message,
                        icon: 'success',
                        confirmButtonText: 'باشه'
                    });
                } else {
                    Swal.fire({
                        title: 'خطا',
                        text: 'خطا در بروزرسانی تنظیمات',
                        icon: 'error',
                        confirmButtonText: 'باشه'
                    });
                }
            } catch (error) {
                Swal.fire({
                    title: 'خطا',
                    text: 'خطا در برقراری ارتباط با سرور',
                    icon: 'error',
                    confirmButtonText: 'باشه'
                });
            }
        });
    });

    // مدیریت تغییر وضعیت تنظیمات
    document.querySelectorAll('.setting-status').forEach(checkbox => {
        checkbox.addEventListener('change', async function() {
            try {
                const response = await fetch('{{ route("admin.security-settings.toggle") }}', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
                    },
                    body: JSON.stringify({
                        group: this.dataset.group,
                        key: this.dataset.key,
                        is_active: this.checked
                    })
                });
                
                const result = await response.json();
                
                if (response.ok) {
                    Swal.fire({
                        title: 'موفق',
                        text: result.message,
                        icon: 'success',
                        confirmButtonText: 'باشه'
                    });
                    this.closest('label').textContent = this.checked ? 'فعال' : 'غیرفعال';
                } else {
                    Swal.fire({
                        title: 'خطا',
                        text: 'خطا در تغییر وضعیت',
                        icon: 'error',
                        confirmButtonText: 'باشه'
                    });
                    this.checked = !this.checked;
                }
            } catch (error) {
                Swal.fire({
                    title: 'خطا',
                    text: 'خطا در برقراری ارتباط با سرور',
                    icon: 'error',
                    confirmButtonText: 'باشه'
                });
                this.checked = !this.checked;
            }
        });
    });
});
</script>
@endpush 