@extends('admin.layouts.app')

@section('title', __('مدیریت نظرات و امتیازات'))

@section('content')
<div class="container-fluid">
    <h1 class="h3 mb-4 text-gray-800">{{ __('مدیریت نظرات و امتیازات') }}</h1>
    
    <div class="card shadow mb-4">
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
            <h6 class="m-0 font-weight-bold text-primary">{{ __('لیست نظرات') }}</h6>
            <a href="{{ route('admin.reviews.settings') }}" class="btn btn-sm btn-outline-primary">
                <i class="fas fa-cog fa-sm"></i> {{ __('تنظیمات') }}
            </a>
        </div>
        <div class="card-body">
            <!-- فیلترهای جستجو -->
            <div class="mb-4">
                <form action="{{ route('admin.reviews.index') }}" method="get" class="row g-3">
                    <div class="col-md-3">
                        <label for="status" class="form-label">{{ __('وضعیت') }}</label>
                        <select name="status" id="status" class="form-select" onchange="this.form.submit()">
                            <option value="all" {{ $status == 'all' ? 'selected' : '' }}>{{ __('همه') }}</option>
                            <option value="pending" {{ $status == 'pending' ? 'selected' : '' }}>{{ __('در انتظار تایید') }}</option>
                            <option value="approved" {{ $status == 'approved' ? 'selected' : '' }}>{{ __('تایید شده') }}</option>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label for="location_id" class="form-label">{{ __('مکان') }}</label>
                        <select name="location_id" id="location_id" class="form-select" onchange="this.form.submit()">
                            <option value="">{{ __('همه مکان‌ها') }}</option>
                            @foreach($locations as $location)
                                <option value="{{ $location->id }}" {{ $selectedLocation == $location->id ? 'selected' : '' }}>
                                    {{ $location->title }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-6">
                        <label for="search" class="form-label">{{ __('جستجو') }}</label>
                        <div class="input-group">
                            <input type="text" class="form-control" id="search" name="search" value="{{ $search }}" placeholder="{{ __('جستجو در نام، ایمیل یا متن نظرات...') }}">
                            <button class="btn btn-primary" type="submit">
                                <i class="fas fa-search fa-sm"></i>
                            </button>
                            @if($search || $status != 'pending' || $selectedLocation)
                                <a href="{{ route('admin.reviews.index') }}" class="btn btn-outline-secondary">
                                    <i class="fas fa-times fa-sm"></i>
                                </a>
                            @endif
                        </div>
                    </div>
                </form>
            </div>
            
            <!-- جدول نظرات -->
            <div class="table-responsive">
                <table class="table table-bordered table-hover">
                    <thead class="table-light">
                        <tr>
                            <th>{{ __('شناسه') }}</th>
                            <th>{{ __('مکان') }}</th>
                            <th>{{ __('کاربر') }}</th>
                            <th>{{ __('امتیاز') }}</th>
                            <th>{{ __('نظر') }}</th>
                            <th>{{ __('تاریخ') }}</th>
                            <th>{{ __('وضعیت') }}</th>
                            <th>{{ __('عملیات') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($reviews as $review)
                            <tr>
                                <td>{{ $review->id }}</td>
                                <td>
                                    <a href="{{ route('locations.show', $review->location_id) }}" target="_blank">
                                        {{ $review->location->title ?? __('نامشخص') }}
                                    </a>
                                </td>
                                <td>
                                    {{ $review->name }}
                                    @if($review->email)
                                        <small class="d-block text-muted">{{ $review->email }}</small>
                                    @endif
                                </td>
                                <td class="text-center">
                                    <div class="rating-display">
                                        @for ($i = 1; $i <= 5; $i++)
                                            @if ($i <= $review->rating)
                                                <i class="fas fa-star text-warning"></i>
                                            @else
                                                <i class="far fa-star text-warning"></i>
                                            @endif
                                        @endfor
                                        <div class="mt-1">{{ $review->rating }}/5</div>
                                    </div>
                                </td>
                                <td>
                                    @if($review->positive_comment)
                                        <small class="text-success d-block">+ {{ Str::limit($review->positive_comment, 50) }}</small>
                                    @endif
                                    @if($review->negative_comment)
                                        <small class="text-danger d-block">- {{ Str::limit($review->negative_comment, 50) }}</small>
                                    @endif
                                    @if($review->comment)
                                        <small class="d-block">{{ Str::limit($review->comment, 50) }}</small>
                                    @endif
                                </td>
                                <td>{{ $review->created_at->format('Y/m/d') }}</td>
                                <td>
                                    @if($review->is_approved)
                                        <span class="badge bg-success">{{ __('تایید شده') }}</span>
                                    @else
                                        <span class="badge bg-warning">{{ __('در انتظار') }}</span>
                                    @endif
                                </td>
                                <td>
                                    <div class="btn-group btn-group-sm">
                                        <a href="{{ route('admin.reviews.show', $review->id) }}" class="btn btn-info" title="{{ __('مشاهده') }}">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        @if(!$review->is_approved)
                                            <form action="{{ route('admin.reviews.approve', $review->id) }}" method="post" class="d-inline">
                                                @csrf
                                                <button type="submit" class="btn btn-success" title="{{ __('تایید') }}" onclick="return confirm('{{ __('آیا از تایید این نظر مطمئن هستید؟') }}')">
                                                    <i class="fas fa-check"></i>
                                                </button>
                                            </form>
                                        @else
                                            <form action="{{ route('admin.reviews.reject', $review->id) }}" method="post" class="d-inline">
                                                @csrf
                                                <button type="submit" class="btn btn-warning" title="{{ __('رد') }}" onclick="return confirm('{{ __('آیا از رد این نظر مطمئن هستید؟') }}')">
                                                    <i class="fas fa-times"></i>
                                                </button>
                                            </form>
                                        @endif
                                        <form action="{{ route('admin.reviews.destroy', $review->id) }}" method="post" class="d-inline">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-danger" title="{{ __('حذف') }}" onclick="return confirm('{{ __('آیا از حذف این نظر مطمئن هستید؟ این عمل قابل بازگشت نیست.') }}')">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="8" class="text-center py-4">
                                    {{ __('نظری یافت نشد.') }}
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            
            <!-- صفحه‌بندی -->
            <div class="d-flex justify-content-center mt-4">
                {{ $reviews->appends(request()->query())->links() }}
            </div>
            
            <!-- آمار -->
            <div class="row mt-4">
                <div class="col-md-4">
                    <div class="card border-left-primary shadow h-100 py-2">
                        <div class="card-body">
                            <div class="row no-gutters align-items-center">
                                <div class="col me-2">
                                    <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                        {{ __('کل نظرات') }}</div>
                                    <div class="h5 mb-0 font-weight-bold text-gray-800">{{ \App\Models\Rating::count() }}</div>
                                </div>
                                <div class="col-auto">
                                    <i class="fas fa-comments fa-2x text-gray-300"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-4">
                    <div class="card border-left-success shadow h-100 py-2">
                        <div class="card-body">
                            <div class="row no-gutters align-items-center">
                                <div class="col me-2">
                                    <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                        {{ __('نظرات تایید شده') }}</div>
                                    <div class="h5 mb-0 font-weight-bold text-gray-800">{{ \App\Models\Rating::where('is_approved', true)->count() }}</div>
                                </div>
                                <div class="col-auto">
                                    <i class="fas fa-check-circle fa-2x text-gray-300"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-4">
                    <div class="card border-left-warning shadow h-100 py-2">
                        <div class="card-body">
                            <div class="row no-gutters align-items-center">
                                <div class="col me-2">
                                    <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                        {{ __('در انتظار تایید') }}</div>
                                    <div class="h5 mb-0 font-weight-bold text-gray-800">{{ \App\Models\Rating::where('is_approved', false)->count() }}</div>
                                </div>
                                <div class="col-auto">
                                    <i class="fas fa-clock fa-2x text-gray-300"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection 