@extends('admin.layouts.app')

@section('title', 'جزئیات اعلان')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">جزئیات اعلان</h3>
                    <div class="card-tools">
                        <a href="{{ route('admin.notifications.index') }}" class="btn btn-default">
                            <i class="fa fa-arrow-right"></i>
                            بازگشت به لیست
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-8">
                            <div class="notification-details">
                                <h3>{{ $notification->title }}</h3>
                                <div class="notification-meta">
                                    <span class="badge badge-{{ $notification->type_color }}">
                                        {{ $notification->type_text }}
                                    </span>
                                    <span class="text-muted float-left">
                                        {{ jdate($notification->created_at)->format('Y/m/d H:i') }}
                                    </span>
                                </div>
                                <div class="notification-content mt-4">
                                    {!! nl2br(e($notification->content)) !!}
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">اطلاعات اعلان</h3>
                                </div>
                                <div class="card-body">
                                    <ul class="list-group list-group-unbordered">
                                        <li class="list-group-item">
                                            <b>وضعیت</b>
                                            @if($notification->read_at)
                                                <span class="badge badge-success float-left">خوانده شده</span>
                                            @else
                                                <span class="badge badge-warning float-left">خوانده نشده</span>
                                            @endif
                                        </li>
                                        <li class="list-group-item">
                                            <b>گیرنده</b>
                                            <span class="float-left">{{ $notification->notifiable_type }}</span>
                                        </li>
                                        @if($notification->data)
                                        <li class="list-group-item">
                                            <b>اطلاعات اضافی</b>
                                            <pre class="mt-2">{{ json_encode($notification->data, JSON_PRETTY_PRINT) }}</pre>
                                        </li>
                                        @endif
                                    </ul>
                                </div>
                                <div class="card-footer">
                                    <form action="{{ route('admin.notifications.destroy', $notification) }}" method="POST">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-danger btn-block" onclick="return confirm('آیا از حذف این اعلان اطمینان دارید؟')">
                                            <i class="fa fa-trash"></i>
                                            حذف اعلان
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection 