@extends('admin.layouts.app')

@section('title', 'مدیریت اعلان‌ها')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">لیست اعلان‌ها</h3>
                    <div class="card-tools">
                        <form action="{{ route('admin.admin.notifications.mark-all-read') }}" method="POST" class="d-inline">
                            @csrf
                            <button type="submit" class="btn btn-success">
                                <i class="fa fa-check"></i>
                                علامت‌گذاری همه به عنوان خوانده شده
                            </button>
                        </form>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>عنوان</th>
                                    <th>نوع</th>
                                    <th>تاریخ</th>
                                    <th>وضعیت</th>
                                    <th>عملیات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($notifications as $notification)
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td>{{ $notification->title }}</td>
                                    <td>
                                        <span class="badge badge-{{ $notification->type_color }}">
                                            {{ $notification->type_text }}
                                        </span>
                                    </td>
                                    <td>{{ jdate($notification->created_at)->format('Y/m/d H:i') }}</td>
                                    <td>
                                        @if($notification->read_at)
                                            <span class="badge badge-success">خوانده شده</span>
                                        @else
                                            <span class="badge badge-warning">خوانده نشده</span>
                                        @endif
                                    </td>
                                    <td>
                                        <a href="{{ route('admin.notifications.show', $notification) }}" class="btn btn-sm btn-info">
                                            <i class="fa fa-eye"></i>
                                        </a>
                                        <form action="{{ route('admin.notifications.destroy', $notification) }}" method="POST" class="d-inline">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('آیا از حذف این اعلان اطمینان دارید؟')">
                                                <i class="fa fa-trash"></i>
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="6" class="text-center">هیچ اعلانی یافت نشد.</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    {{ $notifications->links() }}
                </div>
            </div>
        </div>
    </div>
</div>
@endsection 