@extends('admin.layouts.app')

@section('title', 'نصب ماژول‌ها')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">ماژول‌های قابل نصب</h3>
                </div>
                <div class="card-body">
                    <div class="row">
                        @foreach($availableModules as $key => $module)
                            <div class="col-md-4 mb-4">
                                <div class="card h-100">
                                    <div class="card-body">
                                        <h5 class="card-title">{{ $module['name'] }}</h5>
                                        <p class="card-text">{{ $module['description'] }}</p>
                                        <p class="text-muted">نسخه: {{ $module['version'] }}</p>
                                        <button class="btn btn-primary install-module" data-module="{{ $key }}">
                                            {{ $module['is_installed'] ? 'بروزرسانی' : 'نصب' }}
                                        </button>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
    $(document).ready(function() {
        $('.install-module').click(function() {
            const module = $(this).data('module');
            const button = $(this);
            
            button.prop('disabled', true);
            button.html('<i class="fas fa-spinner fa-spin"></i> در حال نصب...');
            
            // اینجا می‌توانید درخواست AJAX برای نصب ماژول ارسال کنید
            // برای مثال:
            /*
            $.ajax({
                url: '/admin/modules/install/' + module,
                method: 'POST',
                data: {
                    _token: '{{ csrf_token() }}'
                },
                success: function(response) {
                    button.html('نصب شده');
                    button.removeClass('btn-primary').addClass('btn-success');
                },
                error: function() {
                    button.prop('disabled', false);
                    button.html('خطا در نصب');
                    button.removeClass('btn-primary').addClass('btn-danger');
                }
            });
            */
        });
    });
</script>
@endpush
@endsection 