@extends('admin.layouts.app')

@section('title', 'ویرایش منو')

@section('content')
<div class="container-fluid">
    <!-- Header -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">ویرایش منو: {{ $menu->title }}</h1>
        <a href="{{ route('admin.menu-management.index', ['lang' => $menu->language_code]) }}" class="btn btn-secondary btn-sm">
            <i class="fas fa-arrow-right"></i> بازگشت به لیست
        </a>
    </div>

    <div class="row">
        <div class="col-lg-8">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">ویرایش اطلاعات منو</h6>
                </div>
                <div class="card-body">
                    <form action="{{ route('admin.menu-management.update', $menu) }}" method="POST">
                        @csrf
                        @method('PUT')
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="title">عنوان منو <span class="text-danger">*</span></label>
                                    <input type="text" 
                                           class="form-control @error('title') is-invalid @enderror" 
                                           id="title" 
                                           name="title" 
                                           value="{{ old('title', $menu->title) }}"
                                           placeholder="مثال: صفحه اصلی"
                                           required>
                                    @error('title')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="url">آدرس لینک <span class="text-danger">*</span></label>
                                    <input type="text" 
                                           class="form-control @error('url') is-invalid @enderror" 
                                           id="url" 
                                           name="url" 
                                           value="{{ old('url', $menu->url) }}"
                                           placeholder="مثال: / یا /about یا https://example.com"
                                           required>
                                    @error('url')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="icon">آیکون FontAwesome</label>
                                    <div class="input-group">
                                        <input type="text" 
                                               class="form-control @error('icon') is-invalid @enderror" 
                                               id="icon" 
                                               name="icon" 
                                               value="{{ old('icon', $menu->icon) }}"
                                               placeholder="مثال: fas fa-home">
                                        <div class="input-group-append">
                                            <button type="button" class="btn btn-outline-secondary" onclick="showIconPicker()">
                                                <i class="fas fa-icons"></i>
                                            </button>
                                        </div>
                                    </div>
                                    <small class="form-text text-muted">
                                        آیکون FontAwesome برای نمایش در کنار عنوان منو
                                    </small>
                                    @error('icon')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                    <div id="icon-preview" class="mt-2"></div>
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="target">نحوه باز شدن لینک</label>
                                    <select class="form-control @error('target') is-invalid @enderror" 
                                            id="target" 
                                            name="target">
                                        <option value="_self" {{ old('target', $menu->target) == '_self' ? 'selected' : '' }}>
                                            همان تب (_self)
                                        </option>
                                        <option value="_blank" {{ old('target', $menu->target) == '_blank' ? 'selected' : '' }}>
                                            تب جدید (_blank)
                                        </option>
                                    </select>
                                    @error('target')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="parent_id">منوی والد</label>
                                    <select class="form-control @error('parent_id') is-invalid @enderror" 
                                            id="parent_id" 
                                            name="parent_id">
                                        <option value="">منوی اصلی (بدون والد)</option>
                                        @foreach($parentMenus as $parentMenu)
                                            <option value="{{ $parentMenu->id }}" 
                                                    {{ old('parent_id', $menu->parent_id) == $parentMenu->id ? 'selected' : '' }}>
                                                {{ $parentMenu->title }}
                                            </option>
                                        @endforeach
                                    </select>
                                    <small class="form-text text-muted">
                                        برای ایجاد زیرمنو، منوی والد را انتخاب کنید
                                    </small>
                                    @error('parent_id')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="sort_order">ترتیب نمایش</label>
                                    <input type="number" 
                                           class="form-control @error('sort_order') is-invalid @enderror" 
                                           id="sort_order" 
                                           name="sort_order" 
                                           value="{{ old('sort_order', $menu->sort_order) }}"
                                           min="0"
                                           placeholder="0">
                                    <small class="form-text text-muted">
                                        عدد کمتر = نمایش زودتر
                                    </small>
                                    @error('sort_order')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="language_code">زبان</label>
                                    <select class="form-control @error('language_code') is-invalid @enderror" 
                                            id="language_code" 
                                            name="language_code">
                                        @foreach($languages as $language)
                                            <option value="{{ $language->code }}" 
                                                    {{ old('language_code', $menu->language_code) == $language->code ? 'selected' : '' }}>
                                                {{ $language->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('language_code')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <hr>

                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <div class="form-check">
                                        <input type="checkbox" 
                                               class="form-check-input" 
                                               id="is_active" 
                                               name="is_active" 
                                               value="1"
                                               {{ old('is_active', $menu->is_active) ? 'checked' : '' }}>
                                        <label class="form-check-label" for="is_active">
                                            فعال
                                        </label>
                                    </div>
                                    <small class="form-text text-muted">
                                        منوهای غیرفعال نمایش داده نمی‌شوند
                                    </small>
                                </div>
                            </div>
                            
                            <div class="col-md-4">
                                <div class="form-group">
                                    <div class="form-check">
                                        <input type="checkbox" 
                                               class="form-check-input" 
                                               id="show_for_guests" 
                                               name="show_for_guests" 
                                               value="1"
                                               {{ old('show_for_guests', $menu->show_for_guests) ? 'checked' : '' }}>
                                        <label class="form-check-label" for="show_for_guests">
                                            نمایش برای مهمان‌ها
                                        </label>
                                    </div>
                                    <small class="form-text text-muted">
                                        کاربرانی که وارد نشده‌اند
                                    </small>
                                </div>
                            </div>
                            
                            <div class="col-md-4">
                                <div class="form-group">
                                    <div class="form-check">
                                        <input type="checkbox" 
                                               class="form-check-input" 
                                               id="show_for_users" 
                                               name="show_for_users" 
                                               value="1"
                                               {{ old('show_for_users', $menu->show_for_users) ? 'checked' : '' }}>
                                        <label class="form-check-label" for="show_for_users">
                                            نمایش برای کاربران
                                        </label>
                                    </div>
                                    <small class="form-text text-muted">
                                        کاربرانی که وارد شده‌اند
                                    </small>
                                </div>
                            </div>
                        </div>

                        <hr>

                        <div class="form-group">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> به‌روزرسانی منو
                            </button>
                            <a href="{{ route('admin.menu-management.index', ['lang' => $menu->language_code]) }}" 
                               class="btn btn-secondary">
                                <i class="fas fa-times"></i> انصراف
                            </a>
                            <button type="button" class="btn btn-danger float-left" onclick="deleteMenu()">
                                <i class="fas fa-trash"></i> حذف منو
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <div class="col-lg-4">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-info">اطلاعات منو</h6>
                </div>
                <div class="card-body">
                    <table class="table table-sm">
                        <tr>
                            <td><strong>شناسه:</strong></td>
                            <td>{{ $menu->id }}</td>
                        </tr>
                        <tr>
                            <td><strong>تاریخ ایجاد:</strong></td>
                            <td>{{ $menu->created_at->format('Y/m/d H:i') }}</td>
                        </tr>
                        <tr>
                            <td><strong>آخرین به‌روزرسانی:</strong></td>
                            <td>{{ $menu->updated_at->format('Y/m/d H:i') }}</td>
                        </tr>
                        <tr>
                            <td><strong>وضعیت:</strong></td>
                            <td>
                                <span class="badge {{ $menu->is_active ? 'badge-success' : 'badge-secondary' }}">
                                    {{ $menu->is_active ? 'فعال' : 'غیرفعال' }}
                                </span>
                            </td>
                        </tr>
                        @if($menu->parent)
                        <tr>
                            <td><strong>منوی والد:</strong></td>
                            <td>{{ $menu->parent->title }}</td>
                        </tr>
                        @endif
                        @if($menu->children->count() > 0)
                        <tr>
                            <td><strong>زیرمنوها:</strong></td>
                            <td>{{ $menu->children->count() }} مورد</td>
                        </tr>
                        @endif
                    </table>
                </div>
            </div>

            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-warning">راهنما</h6>
                </div>
                <div class="card-body">
                    <h6>نکات مهم:</h6>
                    <ul class="list-unstyled">
                        <li><i class="fas fa-info-circle text-info"></i> تغییر زبان منو تأثیری بر زیرمنوها ندارد</li>
                        <li><i class="fas fa-info-circle text-info"></i> حذف منو، تمام زیرمنوهای آن را نیز حذف می‌کند</li>
                        <li><i class="fas fa-info-circle text-info"></i> منو نمی‌تواند والد خودش باشد</li>
                        <li><i class="fas fa-info-circle text-info"></i> تغییر ترتیب نمایش فوری اعمال می‌شود</li>
                    </ul>

                    <hr>

                    <h6>آیکون‌های پرکاربرد:</h6>
                    <div class="row">
                        <div class="col-6">
                            <small>
                                <code>fas fa-home</code><br>
                                <code>fas fa-list</code><br>
                                <code>fas fa-map</code><br>
                                <code>fas fa-phone</code><br>
                                <code>fas fa-info-circle</code>
                            </small>
                        </div>
                        <div class="col-6">
                            <i class="fas fa-home"></i> خانه<br>
                            <i class="fas fa-list"></i> لیست<br>
                            <i class="fas fa-map"></i> نقشه<br>
                            <i class="fas fa-phone"></i> تماس<br>
                            <i class="fas fa-info-circle"></i> درباره
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Delete Confirmation Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">تأیید حذف</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <p>آیا از حذف منو "{{ $menu->title }}" اطمینان دارید؟</p>
                @if($menu->children->count() > 0)
                    <div class="alert alert-warning">
                        <i class="fas fa-exclamation-triangle"></i>
                        <strong>توجه:</strong> این منو دارای {{ $menu->children->count() }} زیرمنو است که همگی حذف خواهند شد.
                    </div>
                @endif
                <p class="text-muted">این عمل قابل بازگشت نیست.</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">انصراف</button>
                <button type="button" class="btn btn-danger" id="confirmDelete">حذف</button>
            </div>
        </div>
    </div>
</div>

<!-- Icon Picker Modal -->
<div class="modal fade" id="iconPickerModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">انتخاب آیکون</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <!-- Icons will be loaded here -->
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
// Icon preview
$('#icon').on('input', function() {
    const iconClass = $(this).val();
    const preview = $('#icon-preview');
    
    if (iconClass) {
        preview.html(`<i class="${iconClass} fa-2x"></i> <span class="ml-2">${iconClass}</span>`);
    } else {
        preview.html('');
    }
});

// Icon picker (simple version)
function showIconPicker() {
    const commonIcons = [
        'fas fa-home', 'fas fa-list', 'fas fa-map', 'fas fa-phone', 'fas fa-info-circle',
        'fas fa-envelope', 'fas fa-user', 'fas fa-cog', 'fas fa-search', 'fas fa-star',
        'fas fa-heart', 'fas fa-shopping-cart', 'fas fa-calendar', 'fas fa-clock',
        'fas fa-download', 'fas fa-upload', 'fas fa-edit', 'fas fa-trash', 'fas fa-plus', 'fas fa-minus'
    ];
    
    let iconHtml = '<div class="row">';
    commonIcons.forEach(icon => {
        iconHtml += `
            <div class="col-3 text-center mb-2">
                <button type="button" class="btn btn-sm btn-outline-secondary" onclick="selectIcon('${icon}')">
                    <i class="${icon}"></i>
                </button>
            </div>
        `;
    });
    iconHtml += '</div>';
    
    $('#iconPickerModal .modal-body').html(iconHtml);
    $('#iconPickerModal').modal('show');
}

function selectIcon(iconClass) {
    $('#icon').val(iconClass).trigger('input');
    $('#iconPickerModal').modal('hide');
}

function deleteMenu() {
    $('#deleteModal').modal('show');
}

$('#confirmDelete').click(function() {
    // Create a form to delete the menu
    const form = $('<form>', {
        'method': 'POST',
        'action': '{{ route("admin.menu-management.destroy", $menu) }}'
    });
    
    form.append($('<input>', {
        'type': 'hidden',
        'name': '_token',
        'value': '{{ csrf_token() }}'
    }));
    
    form.append($('<input>', {
        'type': 'hidden',
        'name': '_method',
        'value': 'DELETE'
    }));
    
    $('body').append(form);
    form.submit();
});

// Trigger icon preview on page load
$(document).ready(function() {
    $('#icon').trigger('input');
});
</script>
@endpush
