@extends('admin.layouts.app')

@section('title', 'مدیریت لاگ‌ها')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">مدیریت لاگ‌ها</h3>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif

                    @if(session('error'))
                        <div class="alert alert-danger">
                            {{ session('error') }}
                        </div>
                    @endif

                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>نام فایل</th>
                                    <th>حجم</th>
                                    <th>تاریخ ایجاد</th>
                                    <th>عملیات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($logs as $log)
                                    <tr>
                                        <td>{{ $log['filename'] }}</td>
                                        <td>{{ $log['size'] }}</td>
                                        <td>{{ $log['created_at'] }}</td>
                                        <td>
                                            <div class="btn-group">
                                                <a href="{{ route('admin.logs.show', $log['filename']) }}" 
                                                   class="btn btn-sm btn-info">
                                                    <i class="fas fa-eye"></i> مشاهده
                                                </a>
                                                <a href="{{ route('admin.logs.download', $log['filename']) }}" 
                                                   class="btn btn-sm btn-success">
                                                    <i class="fas fa-download"></i> دانلود
                                                </a>
                                                <form action="{{ route('admin.logs.destroy', $log['filename']) }}" 
                                                      method="POST" 
                                                      class="d-inline"
                                                      onsubmit="return confirm('آیا از حذف این فایل لاگ اطمینان دارید؟')">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-sm btn-danger">
                                                        <i class="fas fa-trash"></i> حذف
                                                    </button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="4" class="text-center">هیچ فایل لاگی یافت نشد.</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection 