@extends('admin.layouts.app')

@section('title', 'تنظیمات هدر و منو')

@section('content')
<div class="container-fluid">
    <!-- Header -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">تنظیمات هدر و منوی سایت</h1>
        <div class="d-flex gap-2">
            <button type="button" class="btn btn-danger btn-sm" onclick="resetAllToDefault()">
                <i class="fas fa-sync-alt"></i> تنظیم پیش‌فرض کل
            </button>
            <button type="button" class="btn btn-warning btn-sm" onclick="resetToDefault()">
                <i class="fas fa-undo"></i> بازگشت به پیش‌فرض
            </button>
        </div>
    </div>

    <!-- Language Selector -->
    <div class="card mb-4">
        <div class="card-body">
            <div class="row align-items-center">
                <div class="col-md-6">
                    <label for="language-select" class="form-label">انتخاب زبان:</label>
                    <select id="language-select" class="form-select" onchange="changeLanguage(this.value)">
                        @foreach($languages as $language)
                            <option value="{{ $language->code }}" {{ $languageCode == $language->code ? 'selected' : '' }}>
                                {{ $language->name }}
                            </option>
                        @endforeach
                    </select>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- Header Settings -->
        <div class="col-lg-6">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">تنظیمات هدر</h6>
                </div>
                <div class="card-body">
                    <form action="{{ route('admin.header-settings.update-header') }}" method="POST">
                        @csrf
                        <input type="hidden" name="language_code" value="{{ $languageCode }}">
                        
                        <div class="form-group">
                            <label for="search_placeholder">متن placeholder جستجو</label>
                            <input type="text" 
                                   class="form-control" 
                                   id="search_placeholder" 
                                   name="settings[search_placeholder]" 
                                   value="{{ $headerSettings['search_placeholder'] ?? 'جستجو...' }}"
                                   placeholder="جستجو...">
                        </div>

                        <div class="form-group">
                            <label for="header_style">استایل هدر</label>
                            <select class="form-control" id="header_style" name="settings[header_style]">
                                <option value="default" {{ ($headerSettings['header_style'] ?? 'default') == 'default' ? 'selected' : '' }}>
                                    پیش‌فرض
                                </option>
                                <option value="modern" {{ ($headerSettings['header_style'] ?? 'default') == 'modern' ? 'selected' : '' }}>
                                    مدرن
                                </option>
                                <option value="minimal" {{ ($headerSettings['header_style'] ?? 'default') == 'minimal' ? 'selected' : '' }}>
                                    مینیمال
                                </option>
                            </select>
                        </div>

                        <hr>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <div class="form-check">
                                        <input type="checkbox" 
                                               class="form-check-input" 
                                               id="show_search_box" 
                                               name="settings[show_search_box]" 
                                               value="1"
                                               {{ ($headerSettings['show_search_box'] ?? '1') == '1' ? 'checked' : '' }}>
                                        <label class="form-check-label" for="show_search_box">
                                            نمایش جعبه جستجو
                                        </label>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <div class="form-check">
                                        <input type="checkbox" 
                                               class="form-check-input" 
                                               id="show_language_switcher" 
                                               name="settings[show_language_switcher]" 
                                               value="1"
                                               {{ ($headerSettings['show_language_switcher'] ?? '1') == '1' ? 'checked' : '' }}>
                                        <label class="form-check-label" for="show_language_switcher">
                                            نمایش تغییر زبان
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <div class="form-check">
                                        <input type="checkbox" 
                                               class="form-check-input" 
                                               id="show_user_menu" 
                                               name="settings[show_user_menu]" 
                                               value="1"
                                               {{ ($headerSettings['show_user_menu'] ?? '1') == '1' ? 'checked' : '' }}>
                                        <label class="form-check-label" for="show_user_menu">
                                            نمایش منوی کاربری
                                        </label>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <div class="form-check">
                                        <input type="checkbox" 
                                               class="form-check-input" 
                                               id="sticky_header" 
                                               name="settings[sticky_header]" 
                                               value="1"
                                               {{ ($headerSettings['sticky_header'] ?? '1') == '1' ? 'checked' : '' }}>
                                        <label class="form-check-label" for="sticky_header">
                                            هدر چسبان
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="form-check">
                                <input type="checkbox" 
                                       class="form-check-input" 
                                       id="show_breadcrumb" 
                                       name="settings[show_breadcrumb]" 
                                       value="1"
                                       {{ ($headerSettings['show_breadcrumb'] ?? '1') == '1' ? 'checked' : '' }}>
                                <label class="form-check-label" for="show_breadcrumb">
                                    نمایش مسیر صفحه (Breadcrumb)
                                </label>
                            </div>
                        </div>

                        <hr>

                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save"></i> ذخیره تنظیمات هدر
                        </button>
                    </form>
                </div>
            </div>
        </div>

        <!-- Button Settings -->
        <div class="col-lg-6">
            <div class="card shadow mb-4">
                <div class="card-header py-3 d-flex justify-content-between align-items-center">
                    <h6 class="m-0 font-weight-bold text-success">تنظیمات دکمه‌ها</h6>
                    <button type="button" class="btn btn-sm btn-success" onclick="addNewButton()">
                        <i class="fas fa-plus"></i> افزودن دکمه
                    </button>
                </div>
                <div class="card-body">
                    <form action="{{ route('admin.header-settings.update-buttons') }}" method="POST" id="buttonsForm">
                        @csrf
                        <input type="hidden" name="language_code" value="{{ $languageCode }}">
                        
                        <div id="buttons-container">
                            @foreach($buttonSettings as $index => $button)
                                <div class="button-item border rounded p-3 mb-3" data-index="{{ $index }}">
                                    <div class="d-flex justify-content-between align-items-center mb-2">
                                        <h6 class="mb-0">{{ $button->button_text }}</h6>
                                        <div>
                                            <button type="button" 
                                                    class="btn btn-sm {{ $button->is_visible ? 'btn-success' : 'btn-secondary' }}"
                                                    onclick="toggleButtonVisibility({{ $button->id }}, this)">
                                                <i class="fas {{ $button->is_visible ? 'fa-eye' : 'fa-eye-slash' }}"></i>
                                            </button>
                                            <button type="button" class="btn btn-sm btn-danger" onclick="removeButton(this)">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </div>
                                    </div>
                                    
                                    <input type="hidden" name="buttons[{{ $index }}][button_key]" value="{{ $button->button_key }}">
                                    
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>متن دکمه</label>
                                                <input type="text" 
                                                       class="form-control" 
                                                       name="buttons[{{ $index }}][button_text]" 
                                                       value="{{ $button->button_text }}"
                                                       required>
                                            </div>
                                        </div>
                                        
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>آدرس لینک</label>
                                                <input type="text" 
                                                       class="form-control" 
                                                       name="buttons[{{ $index }}][button_url]" 
                                                       value="{{ $button->button_url }}"
                                                       placeholder="/profile">
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>آیکون</label>
                                                <input type="text" 
                                                       class="form-control" 
                                                       name="buttons[{{ $index }}][button_icon]" 
                                                       value="{{ $button->button_icon }}"
                                                       placeholder="fas fa-user">
                                            </div>
                                        </div>
                                        
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>ترتیب نمایش</label>
                                                <input type="number" 
                                                       class="form-control" 
                                                       name="buttons[{{ $index }}][sort_order]" 
                                                       value="{{ $button->sort_order }}"
                                                       min="0">
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-check">
                                                <input type="hidden" name="buttons[{{ $index }}][show_for_guests]" value="0">
                                                <input type="checkbox"
                                                       class="form-check-input"
                                                       name="buttons[{{ $index }}][show_for_guests]"
                                                       value="1"
                                                       {{ $button->show_for_guests ? 'checked' : '' }}>
                                                <label class="form-check-label">
                                                    نمایش برای مهمان‌ها
                                                </label>
                                            </div>
                                        </div>

                                        <div class="col-md-6">
                                            <div class="form-check">
                                                <input type="hidden" name="buttons[{{ $index }}][show_for_users]" value="0">
                                                <input type="checkbox"
                                                       class="form-check-input"
                                                       name="buttons[{{ $index }}][show_for_users]"
                                                       value="1"
                                                       {{ $button->show_for_users ? 'checked' : '' }}>
                                                <label class="form-check-label">
                                                    نمایش برای کاربران
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <input type="hidden" name="buttons[{{ $index }}][is_visible]" value="{{ $button->is_visible ? '1' : '0' }}">
                                </div>
                            @endforeach
                        </div>

                        <hr>

                        <button type="submit" class="btn btn-success">
                            <i class="fas fa-save"></i> ذخیره تنظیمات دکمه‌ها
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Add Button Modal -->
<div class="modal fade" id="addButtonModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">افزودن دکمه جدید</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form action="{{ route('admin.header-settings.add-button') }}" method="POST">
                @csrf
                <div class="modal-body">
                    <input type="hidden" name="language_code" value="{{ $languageCode }}">
                    
                    <div class="form-group">
                        <label for="new_button_key">کلید دکمه (منحصر به فرد)</label>
                        <input type="text" class="form-control" id="new_button_key" name="button_key" required>
                        <small class="form-text text-muted">مثال: my_custom_button</small>
                    </div>
                    
                    <div class="form-group">
                        <label for="new_button_text">متن دکمه</label>
                        <input type="text" class="form-control" id="new_button_text" name="button_text" required>
                    </div>
                    
                    <div class="form-group">
                        <label for="new_button_url">آدرس لینک</label>
                        <input type="text" class="form-control" id="new_button_url" name="button_url">
                    </div>
                    
                    <div class="form-group">
                        <label for="new_button_icon">آیکون</label>
                        <input type="text" class="form-control" id="new_button_icon" name="button_icon">
                    </div>
                    
                    <div class="form-group">
                        <label for="new_sort_order">ترتیب نمایش</label>
                        <input type="number" class="form-control" id="new_sort_order" name="sort_order" value="0" min="0">
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-check">
                                <input type="checkbox" class="form-check-input" id="new_show_for_guests" name="show_for_guests" value="1" checked>
                                <label class="form-check-label" for="new_show_for_guests">
                                    نمایش برای مهمان‌ها
                                </label>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="form-check">
                                <input type="checkbox" class="form-check-input" id="new_show_for_users" name="show_for_users" value="1" checked>
                                <label class="form-check-label" for="new_show_for_users">
                                    نمایش برای کاربران
                                </label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">انصراف</button>
                    <button type="submit" class="btn btn-primary">افزودن دکمه</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
function changeLanguage(langCode) {
    window.location.href = '{{ route("admin.header-settings.index") }}?lang=' + langCode;
}

function addNewButton() {
    $('#addButtonModal').modal('show');
}

function removeButton(button) {
    if (confirm('آیا از حذف این دکمه اطمینان دارید؟')) {
        $(button).closest('.button-item').remove();
        updateButtonIndices();
    }
}

function updateButtonIndices() {
    $('#buttons-container .button-item').each(function(index) {
        $(this).attr('data-index', index);
        $(this).find('input, select').each(function() {
            const name = $(this).attr('name');
            if (name) {
                const newName = name.replace(/buttons\[\d+\]/, `buttons[${index}]`);
                $(this).attr('name', newName);
            }
        });
    });
}

function toggleButtonVisibility(buttonId, element) {
    $.ajax({
        url: `/admin/header-settings/buttons/${buttonId}/toggle-visibility`,
        method: 'POST',
        data: {
            _token: '{{ csrf_token() }}'
        },
        success: function(response) {
            if (response.success) {
                const btn = $(element);
                const icon = btn.find('i');
                
                if (response.is_visible) {
                    btn.removeClass('btn-secondary').addClass('btn-success');
                    icon.removeClass('fa-eye-slash').addClass('fa-eye');
                } else {
                    btn.removeClass('btn-success').addClass('btn-secondary');
                    icon.removeClass('fa-eye').addClass('fa-eye-slash');
                }
                
                // Update hidden input
                btn.closest('.button-item').find('input[name*="[is_visible]"]').val(response.is_visible ? '1' : '0');
                
                showAlert('success', response.message);
            }
        },
        error: function() {
            showAlert('error', 'خطا در تغییر وضعیت دکمه');
        }
    });
}

function resetToDefault() {
    if (confirm('آیا از بازگشت به تنظیمات پیش‌فرض اطمینان دارید؟ تمام تغییرات فعلی از بین خواهد رفت.')) {
        window.location.href = '{{ route("admin.header-settings.reset-default") }}?lang={{ $languageCode }}';
    }
}

function resetAllToDefault() {
    if (confirm('⚠️ هشدار: این عمل تمام تنظیمات هدر، منو و دکمه‌های کاربری را به حالت پیش‌فرض برمی‌گرداند.\n\nآیا از انجام این کار اطمینان دارید؟')) {
        // Show loading
        const btn = event.target.closest('button');
        const originalText = btn.innerHTML;
        btn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> در حال بازگردانی...';
        btn.disabled = true;

        // Reset all settings
        window.location.href = '{{ route("admin.header-settings.reset-all-default") }}?lang={{ $languageCode }}';
    }
}

function showAlert(type, message) {
    const alertClass = type === 'success' ? 'alert-success' : 'alert-danger';
    const alertHtml = `
        <div class="alert ${alertClass} alert-dismissible fade show" role="alert">
            ${message}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    `;
    $('.container-fluid').prepend(alertHtml);
}
</script>
@endpush
