@extends('admin.layouts.app')

@section('title', 'مدیریت محله‌ها')

@section('content')
<div class="container-fluid">
    <div class="card">
        <div class="card-header">
            <div class="d-flex justify-content-between align-items-center">
                <h4>مدیریت محله‌ها</h4>
                <a href="{{ route('admin.geography.zones.create') }}" class="btn btn-primary">
                    <i class="fas fa-plus"></i> افزودن محله جدید
                </a>
            </div>
        </div>
        <div class="card-body">
            @if(session('success'))
                <div class="alert alert-success">
                    {{ session('success') }}
                </div>
            @endif

            @if(session('error'))
                <div class="alert alert-danger">
                    {{ session('error') }}
                </div>
            @endif

            <div class="table-responsive">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>نام</th>
                            <th>نام انگلیسی</th>
                            <th>شهر</th>
                            <th>روستا</th>
                            <th>محله والد</th>
                            <th>نوع</th>
                            <th>وضعیت</th>
                            <th>عملیات</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($zones as $zone)
                            <tr>
                                <td>{{ $zone->id }}</td>
                                <td>{{ $zone->name }}</td>
                                <td>{{ $zone->name_en ?? '-' }}</td>
                                <td>{{ $zone->city->name ?? '-' }}</td>
                                <td>{{ $zone->village->name ?? '-' }}</td>
                                <td>{{ $zone->parent->name ?? '-' }}</td>
                                <td>{{ $zone->type ?? '-' }}</td>
                                <td>
                                    @if($zone->is_active)
                                        <span class="badge badge-success">فعال</span>
                                    @else
                                        <span class="badge badge-danger">غیرفعال</span>
                                    @endif
                                </td>
                                <td>
                                    <div class="btn-group">
                                        <a href="{{ route('admin.geography.zones.show', $zone->id) }}" class="btn btn-sm btn-info">
                                            <i class="fas fa-eye"></i> نمایش
                                        </a>
                                        <a href="{{ route('admin.geography.zones.edit', $zone->id) }}" class="btn btn-sm btn-primary">
                                            <i class="fas fa-edit"></i> ویرایش
                                        </a>
                                        <button type="button" class="btn btn-sm btn-danger" data-toggle="modal" data-target="#deleteModal-{{ $zone->id }}">
                                            <i class="fas fa-trash"></i> حذف
                                        </button>
                                    </div>
                                    
                                    <!-- Delete Confirmation Modal -->
                                    <div class="modal fade" id="deleteModal-{{ $zone->id }}" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel-{{ $zone->id }}" aria-hidden="true">
                                        <div class="modal-dialog" role="document">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="deleteModalLabel-{{ $zone->id }}">تأیید حذف</h5>
                                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>
                                                <div class="modal-body">
                                                    آیا از حذف محله "{{ $zone->name }}" اطمینان دارید؟ این عمل قابل بازگشت نیست.
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">انصراف</button>
                                                    <form action="{{ route('admin.geography.zones.destroy', $zone->id) }}" method="POST">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="submit" class="btn btn-danger">حذف</button>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="9" class="text-center">هیچ محله‌ای یافت نشد</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            
            <div class="mt-4">
                {{ $zones->links() }}
            </div>
        </div>
    </div>
</div>
@endsection 