@extends('admin.layouts.app')

@section('title', 'مدیریت بخش‌ها')

@section('content')
<div class="container-fluid">
    <div class="card">
        <div class="card-header">
            <div class="d-flex justify-content-between align-items-center">
                <h4>مدیریت بخش‌ها</h4>
                <a href="{{ route('admin.geography.districts.create') }}" class="btn btn-primary">
                    <i class="fas fa-plus"></i> افزودن بخش جدید
                </a>
            </div>
        </div>
        <div class="card-body">
            @if(session('success'))
                <div class="alert alert-success">
                    {{ session('success') }}
                </div>
            @endif

            @if(session('error'))
                <div class="alert alert-danger">
                    {{ session('error') }}
                </div>
            @endif

            <div class="table-responsive">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>نام</th>
                            <th>نام انگلیسی</th>
                            <th>شهرستان</th>
                            <th>شهر مرکزی</th>
                            <th>کد</th>
                            <th>وضعیت</th>
                            <th>عملیات</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($districts as $district)
                            <tr>
                                <td>{{ $district->id }}</td>
                                <td>{{ $district->name }}</td>
                                <td>{{ $district->name_en ?? '-' }}</td>
                                <td>{{ $district->county->name ?? '-' }}</td>
                                <td>{{ $district->center_city_name ?? '-' }}</td>
                                <td>{{ $district->code ?? '-' }}</td>
                                <td>
                                    @if($district->is_active)
                                        <span class="badge badge-success">فعال</span>
                                    @else
                                        <span class="badge badge-danger">غیرفعال</span>
                                    @endif
                                </td>
                                <td>
                                    <div class="btn-group">
                                        <a href="{{ route('admin.geography.districts.show', $district->id) }}" class="btn btn-sm btn-info">
                                            <i class="fas fa-eye"></i> نمایش
                                        </a>
                                        <a href="{{ route('admin.geography.districts.edit', $district->id) }}" class="btn btn-sm btn-primary">
                                            <i class="fas fa-edit"></i> ویرایش
                                        </a>
                                        <button type="button" class="btn btn-sm btn-danger" data-toggle="modal" data-target="#deleteModal-{{ $district->id }}">
                                            <i class="fas fa-trash"></i> حذف
                                        </button>
                                    </div>
                                    
                                    <!-- Delete Confirmation Modal -->
                                    <div class="modal fade" id="deleteModal-{{ $district->id }}" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel-{{ $district->id }}" aria-hidden="true">
                                        <div class="modal-dialog" role="document">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="deleteModalLabel-{{ $district->id }}">تأیید حذف</h5>
                                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>
                                                <div class="modal-body">
                                                    آیا از حذف بخش "{{ $district->name }}" اطمینان دارید؟ این عمل قابل بازگشت نیست.
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">انصراف</button>
                                                    <form action="{{ route('admin.geography.districts.destroy', $district->id) }}" method="POST">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="submit" class="btn btn-danger">حذف</button>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="8" class="text-center">هیچ بخشی یافت نشد</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            
            <div class="mt-4">
                {{ $districts->links() }}
            </div>
        </div>
    </div>
</div>
@endsection 