@extends('admin.layouts.app')

@section('title', 'ویرایش شهرستان')

@section('content')
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">ویرایش شهرستان</h4>
                    <a href="{{ route('admin.geography.counties.index') }}" class="btn btn-sm btn-primary">
                        <i class="fa fa-arrow-left"></i>
                        بازگشت
                    </a>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif

                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul class="mb-0">
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <form action="{{ route('admin.geography.counties.update', $item->id) }}" method="POST">
                        @csrf
                        @method('PUT')
                        
                        <div class="form-group row mb-4">
                            <label for="province_id" class="col-form-label text-md-right col-12 col-md-3 col-lg-3">استان</label>
                            <div class="col-sm-12 col-md-7">
                                <select name="province_id" id="province_id" class="form-control select2 @error('province_id') is-invalid @enderror">
                                    <option value="">انتخاب کنید</option>
                                    @foreach($provinces as $id => $name)
                                        <option value="{{ $id }}" {{ old('province_id', $item->province_id) == $id ? 'selected' : '' }}>
                                            {{ $name }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('province_id')
                                    <div class="invalid-feedback">
                                        {{ $message }}
                                    </div>
                                @enderror
                            </div>
                        </div>

                        <div class="form-group row mb-4">
                            <label for="name" class="col-form-label text-md-right col-12 col-md-3 col-lg-3">نام شهرستان</label>
                            <div class="col-sm-12 col-md-7">
                                <input type="text" id="name" name="name" class="form-control @error('name') is-invalid @enderror" value="{{ old('name', $item->name) }}">
                                @error('name')
                                    <div class="invalid-feedback">
                                        {{ $message }}
                                    </div>
                                @enderror
                            </div>
                        </div>

                        <div class="form-group row mb-4">
                            <label for="name_en" class="col-form-label text-md-right col-12 col-md-3 col-lg-3">نام انگلیسی</label>
                            <div class="col-sm-12 col-md-7">
                                <input type="text" id="name_en" name="name_en" class="form-control @error('name_en') is-invalid @enderror" value="{{ old('name_en', $item->name_en) }}">
                                @error('name_en')
                                    <div class="invalid-feedback">
                                        {{ $message }}
                                    </div>
                                @enderror
                            </div>
                        </div>

                        <div class="form-group row mb-4">
                            <label for="slug" class="col-form-label text-md-right col-12 col-md-3 col-lg-3">اسلاگ</label>
                            <div class="col-sm-12 col-md-7">
                                <input type="text" id="slug" name="slug" class="form-control @error('slug') is-invalid @enderror" value="{{ old('slug', $item->slug) }}">
                                @error('slug')
                                    <div class="invalid-feedback">
                                        {{ $message }}
                                    </div>
                                @enderror
                            </div>
                        </div>

                        <div class="form-group row mb-4">
                            <label for="center_city_name" class="col-form-label text-md-right col-12 col-md-3 col-lg-3">نام شهر مرکزی</label>
                            <div class="col-sm-12 col-md-7">
                                <input type="text" id="center_city_name" name="center_city_name" class="form-control @error('center_city_name') is-invalid @enderror" value="{{ old('center_city_name', $item->center_city_name) }}">
                                @error('center_city_name')
                                    <div class="invalid-feedback">
                                        {{ $message }}
                                    </div>
                                @enderror
                            </div>
                        </div>

                        <div class="form-group row mb-4">
                            <label for="code" class="col-form-label text-md-right col-12 col-md-3 col-lg-3">کد شهرستان</label>
                            <div class="col-sm-12 col-md-7">
                                <input type="text" id="code" name="code" class="form-control @error('code') is-invalid @enderror" value="{{ old('code', $item->code) }}">
                                @error('code')
                                    <div class="invalid-feedback">
                                        {{ $message }}
                                    </div>
                                @enderror
                            </div>
                        </div>

                        <div class="form-group row mb-4">
                            <label class="col-form-label text-md-right col-12 col-md-3 col-lg-3">وضعیت</label>
                            <div class="col-sm-12 col-md-7">
                                <div class="selectgroup w-100">
                                    <label class="selectgroup-item">
                                        <input type="radio" name="is_active" value="1" class="selectgroup-input" {{ old('is_active', $item->is_active) == 1 ? 'checked' : '' }}>
                                        <span class="selectgroup-button">فعال</span>
                                    </label>
                                    <label class="selectgroup-item">
                                        <input type="radio" name="is_active" value="0" class="selectgroup-input" {{ old('is_active', $item->is_active) == 0 ? 'checked' : '' }}>
                                        <span class="selectgroup-button">غیرفعال</span>
                                    </label>
                                </div>
                            </div>
                        </div>

                        <div class="form-group row mb-4">
                            <label class="col-form-label text-md-right col-12 col-md-3 col-lg-3"></label>
                            <div class="col-sm-12 col-md-7">
                                <button type="submit" class="btn btn-primary">ذخیره تغییرات</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
    <script>
        $(document).ready(function() {
            // تولید خودکار اسلاگ از روی نام شهرستان
            $('#name').on('keyup', function() {
                var name = $(this).val();
                name = name.replace(/\s+/g, '-').toLowerCase();
                // حذف کاراکترهای غیرمجاز
                name = name.replace(/[^a-z0-9-]/g, '');
                // حذف - های اضافی
                name = name.replace(/-+/g, '-');
                $('#slug').val(name);
            });
        });
    </script>
@endsection 