@extends('admin.layouts.app')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">افزودن تنظیمات جدید</h3>
                </div>
                <div class="card-body">
                    <form action="{{ route('admin.display-settings.store') }}" method="POST">
                        @csrf
                        
                        <div class="form-group mb-3">
                            <label for="page_key">کلید صفحه <span class="text-danger">*</span></label>
                            <input type="text" name="page_key" id="page_key" class="form-control @error('page_key') is-invalid @enderror" value="{{ old('page_key') }}" required>
                            @error('page_key')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                            <small class="form-text text-muted">کلید صفحه باید یک نام یکتا و انگلیسی باشد (مثلاً: <code>homepage</code> یا <code>locations</code>). این کلید برای شناسایی تنظیمات مربوط به هر صفحه استفاده می‌شود. برای مشاهده کلیدهای صفحات، به مستندات یا آدرس URL صفحه مورد نظر مراجعه کنید.</small>
                        </div>

                        <div class="form-group mb-3">
                            <label for="section_key">کلید بخش <span class="text-danger">*</span></label>
                            <input type="text" name="section_key" id="section_key" class="form-control @error('section_key') is-invalid @enderror" value="{{ old('section_key') }}" required>
                            @error('section_key')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                            <small class="form-text text-muted">کلید بخش باید یک نام یکتا و انگلیسی باشد (مثلاً: <code>main_list</code> یا <code>sidebar</code>). این کلید برای شناسایی بخش خاصی از صفحه استفاده می‌شود. معمولاً در کد یا مستندات پروژه قابل مشاهده است.</small>
                        </div>

                        <div class="form-group">
                            <label for="desktop_items">تعداد آیتم در دسکتاپ</label>
                            <input type="number" 
                                   class="form-control @error('desktop_items') is-invalid @enderror" 
                                   id="desktop_items" 
                                   name="desktop_items" 
                                   value="{{ old('desktop_items', 9) }}"
                                   min="1">
                            @error('desktop_items')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label for="mobile_items">تعداد آیتم در موبایل</label>
                            <input type="number" 
                                   class="form-control @error('mobile_items') is-invalid @enderror" 
                                   id="mobile_items" 
                                   name="mobile_items" 
                                   value="{{ old('mobile_items', 9) }}"
                                   min="1">
                            @error('mobile_items')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label for="load_more_text">{{ __('messages.load_more') }}</label>
                            <input type="text" 
                                   class="form-control @error('load_more_text') is-invalid @enderror" 
                                   id="load_more_text" 
                                   name="load_more_text" 
                                   value="{{ old('load_more_text', __('messages.load_more')) }}">
                            @error('load_more_text')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="form-group">
                            <div class="custom-control custom-switch">
                                <input type="checkbox" 
                                       class="custom-control-input" 
                                       id="is_active" 
                                       name="is_active" 
                                       value="1" 
                                       {{ old('is_active') ? 'checked' : '' }}>
                                <label class="custom-control-label" for="is_active">فعال</label>
                            </div>
                        </div>

                        <div class="form-group">
                            <button type="submit" class="btn btn-primary">ذخیره تنظیمات</button>
                            <a href="{{ route('admin.display-settings.index') }}" class="btn btn-secondary">بازگشت</a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection 