@extends('admin.layouts.app')

@section('title', 'مدیریت دسته‌بندی‌ها')

@section('content')
<div class="container-fluid">
    <!-- Page Heading -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">مدیریت دسته‌بندی‌ها</h1>
        <a href="{{ route('admin.categories.create') }}" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm">
            <i class="fas fa-plus fa-sm text-white-50 ml-1"></i> افزودن دسته‌بندی جدید
        </a>
    </div>

    <!-- Content Row -->
    <div class="card shadow mb-4">
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
            <h6 class="m-0 font-weight-bold text-primary">لیست دسته‌بندی‌ها</h6>
            <div class="dropdown no-arrow">
                <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                    <i class="fas fa-ellipsis-v fa-sm fa-fw text-gray-400"></i>
                </a>
                <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in" aria-labelledby="dropdownMenuLink">
                    <a class="dropdown-item" href="#" id="export-csv">
                        <i class="fas fa-file-csv fa-sm fa-fw ml-1"></i> خروجی CSV
                    </a>
                    <a class="dropdown-item" href="#" id="export-excel">
                        <i class="fas fa-file-excel fa-sm fa-fw ml-1"></i> خروجی اکسل
                    </a>
                    <div class="dropdown-divider"></div>
                    <a class="dropdown-item" href="#" id="refresh-list">
                        <i class="fas fa-sync fa-sm fa-fw ml-1"></i> بروزرسانی لیست
                    </a>
                </div>
            </div>
        </div>
        <div class="card-body">
            <!-- فیلترهای جستجو -->
            <div class="mb-4">
                <form action="{{ route('admin.categories.index') }}" method="GET" class="row" id="search-form">
                    <div class="col-md-3 mb-2">
                        <div class="input-group">
                            <input type="text" class="form-control" name="search" placeholder="جستجو..." value="{{ request('search') }}">
                            <div class="input-group-append">
                                <button class="btn btn-primary" type="submit">
                                    <i class="fas fa-search fa-sm"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-3 mb-2">
                        <select class="form-control" name="parent_id" onchange="document.getElementById('search-form').submit()">
                            <option value="">همه دسته‌بندی‌ها</option>
                            <option value="only_parent" {{ request('parent_id') == 'only_parent' ? 'selected' : '' }}>فقط دسته‌های اصلی</option>
                            @foreach($parentCategories as $id => $name)
                                <option value="{{ $id }}" {{ request('parent_id') == $id ? 'selected' : '' }}>{{ $name }}</option>
                            @endforeach
                        </select>
                    </div>
                    
                    <div class="col-md-2 mb-2">
                        <select class="form-control" name="show_in_menu" onchange="document.getElementById('search-form').submit()">
                            <option value="">وضعیت نمایش در منو</option>
                            <option value="1" {{ request('show_in_menu') == '1' ? 'selected' : '' }}>نمایش در منو</option>
                            <option value="0" {{ request('show_in_menu') == '0' ? 'selected' : '' }}>عدم نمایش در منو</option>
                        </select>
                    </div>
                    
                    <div class="col-md-2 mb-2">
                        <select class="form-control" name="show_in_filters" onchange="document.getElementById('search-form').submit()">
                            <option value="">وضعیت نمایش در فیلتر</option>
                            <option value="1" {{ request('show_in_filters') == '1' ? 'selected' : '' }}>نمایش در فیلتر</option>
                            <option value="0" {{ request('show_in_filters') == '0' ? 'selected' : '' }}>عدم نمایش در فیلتر</option>
                        </select>
                    </div>
                    
                    <div class="col-md-2 mb-2">
                        <a href="{{ route('admin.categories.index') }}" class="btn btn-secondary btn-block">
                            <i class="fas fa-redo-alt"></i> حذف فیلترها
                        </a>
                    </div>
                </form>
            </div>
            
            <!-- جدول اطلاعات -->
            <div class="table-responsive">
                <table class="table table-bordered table-striped table-hover" id="categories-table" width="100%" cellspacing="0">
                    <thead class="bg-gradient-primary text-white">
                        <tr>
                            <th width="40">آیکون</th>
                            <th>نام دسته‌بندی</th>
                            <th>کلید</th>
                            <th>والد</th>
                            <th width="80">اولویت</th>
                            <th width="100">وضعیت نمایش</th>
                            <th width="150">عملیات</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($categories as $category)
                            <tr>
                                <td class="text-center">
                                    @if($category->emoji)
                                        <span class="emoji-icon">{{ $category->emoji }}</span>
                                    @elseif($category->font_icon)
                                        <i class="fa fa-{{ $category->font_icon }}" style="color: {{ $category->color ?: '#666' }}"></i>
                                    @else
                                        <i class="fa fa-folder"></i>
                                    @endif
                                </td>
                                <td>
                                    <strong>{{ $category->getTranslatedName(app()->getLocale()) }}</strong>
                                    @if($category->category_en)
                                        <br>
                                        <small class="text-muted">{{ $category->category_en }}</small>
                                    @endif
                                </td>
                                <td><code>{{ $category->category_key }}</code></td>
                                <td>
                                    @if($category->parent)
                                        {{ $category->parent->getTranslatedName(app()->getLocale()) }}
                                    @else
                                        <span class="badge badge-secondary">دسته‌بندی اصلی</span>
                                    @endif
                                </td>
                                <td class="text-center">{{ $category->sort_order }}</td>
                                <td>
                                    <div class="mb-1">
                                        @if($category->show_in_menu)
                                            <span class="badge badge-success">نمایش در منو</span>
                                        @else
                                            <span class="badge badge-danger">عدم نمایش در منو</span>
                                        @endif
                                    </div>
                                    <div>
                                        @if($category->show_in_filters)
                                            <span class="badge badge-success">نمایش در فیلتر</span>
                                        @else
                                            <span class="badge badge-danger">عدم نمایش در فیلتر</span>
                                        @endif
                                    </div>
                                </td>
                                <td class="text-center">
                                    <div class="btn-group">
                                        <a href="{{ route('admin.categories.edit', $category->id) }}" class="btn btn-sm btn-primary" title="ویرایش">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <a href="{{ route('admin.categories.show', $category->id) }}" class="btn btn-sm btn-info" title="نمایش جزئیات">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <form action="{{ route('admin.categories.destroy', $category->id) }}" method="POST" class="d-inline">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('آیا از حذف این دسته‌بندی اطمینان دارید؟')" title="حذف">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="7" class="text-center py-5">
                                    <div class="alert alert-warning mb-0">
                                        <i class="fas fa-exclamation-triangle ml-1"></i>
                                        هیچ دسته‌بندی یافت نشد!
                                    </div>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            
            <!-- پاگینیشن -->
            <div class="d-flex justify-content-center mt-4">
                {{ $categories->appends(request()->query())->links() }}
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    // اسکریپت مربوط به صادر کردن داده‌ها
    $(document).ready(function() {
        $('#export-csv').on('click', function(e) {
            e.preventDefault();
            window.location.href = '{{ route("admin.categories.index") }}' + '?export=csv&' + $('#search-form').serialize();
        });
        
        $('#export-excel').on('click', function(e) {
            e.preventDefault();
            window.location.href = '{{ route("admin.categories.index") }}' + '?export=excel&' + $('#search-form').serialize();
        });
        
        $('#refresh-list').on('click', function(e) {
            e.preventDefault();
            window.location.href = '{{ route("admin.categories.index") }}' + '?' + $('#search-form').serialize();
        });
    });
</script>
@endsection