@extends('admin.layouts.app')

@section('title', 'شاخص‌های عملکرد')

@section('content')
<!-- Page Heading -->
<div class="d-sm-flex align-items-center justify-content-between mb-4">
    <h1 class="h3 mb-0 text-gray-800">شاخص‌های کلیدی عملکرد</h1>
    <div>
        <a href="{{ route('admin.analytics.index') }}" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm ml-2">
            <i class="fas fa-chart-bar fa-sm text-white-50 ml-1"></i> بازگشت به داشبورد تحلیلی
        </a>
        <a href="#" class="d-none d-sm-inline-block btn btn-sm btn-success shadow-sm" id="printReport">
            <i class="fas fa-download fa-sm text-white-50 ml-1"></i> دریافت گزارش
        </a>
        <button type="button" class="d-none d-sm-inline-block btn btn-sm btn-info shadow-sm" id="refreshData">
            <i class="fas fa-sync fa-sm text-white-50 ml-1"></i> بروزرسانی
        </button>
    </div>
</div>

<!-- Period Selector Card -->
<div class="row mb-4">
    <div class="col-md-12">
        <div class="card shadow">
            <div class="card-body py-3">
                <div class="row align-items-center">
                    <div class="col-md-4">
                        <h6 class="m-0 font-weight-bold text-primary">دوره زمانی آنالیز</h6>
                    </div>
                    <div class="col-md-8 text-left">
                        <div class="d-flex justify-content-end">
                            <select class="form-control form-control-sm" id="periodSelector" style="width: auto;">
                                <option value="7">7 روز اخیر</option>
                                <option value="30" selected>30 روز اخیر</option>
                                <option value="90">90 روز اخیر</option>
                                <option value="180">6 ماه اخیر</option>
                                <option value="365">1 سال اخیر</option>
                                <option value="custom">بازه زمانی دلخواه</option>
                            </select>
                            <button class="btn btn-sm btn-outline-primary mr-2" id="applyPeriod">اعمال</button>
                        </div>
                        <div class="mt-2 custom-period" style="display: none;">
                            <div class="d-flex">
                                <div class="ml-2">
                                    <label for="startDate" class="small">از تاریخ:</label>
                                    <input type="date" id="startDate" class="form-control form-control-sm">
                                </div>
                                <div>
                                    <label for="endDate" class="small">تا تاریخ:</label>
                                    <input type="date" id="endDate" class="form-control form-control-sm">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- KPI Stats Cards Row -->
<div class="row">
    <!-- New Locations Card -->
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card border-left-primary shadow h-100 py-2">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">مکان‌های جدید</div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $kpiMetrics['location_metrics']['current'] }}</div>
                        <div class="mt-2 small">
                            <span class="{{ $kpiMetrics['location_metrics']['growth_class'] }}">
                                <i class="fas {{ $kpiMetrics['location_metrics']['growth_icon'] }} fa-sm"></i>
                                {{ $kpiMetrics['location_metrics']['growth'] }}% نسبت به دوره قبل
                            </span>
                        </div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-map-marker-alt fa-2x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- New Ratings Card -->
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card border-left-success shadow h-100 py-2">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-success text-uppercase mb-1">نظرات ثبت شده</div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $kpiMetrics['rating_metrics']['current'] }}</div>
                        <div class="mt-2 small">
                            <span class="{{ $kpiMetrics['rating_metrics']['growth_class'] }}">
                                <i class="fas {{ $kpiMetrics['rating_metrics']['growth_icon'] }} fa-sm"></i>
                                {{ $kpiMetrics['rating_metrics']['growth'] }}% نسبت به دوره قبل
                            </span>
                        </div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-star fa-2x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Average Rating Card -->
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card border-left-info shadow h-100 py-2">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-info text-uppercase mb-1">میانگین امتیاز</div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $kpiMetrics['avg_rating_metrics']['current'] }}</div>
                        <div class="mt-2 small">
                            <span class="{{ $kpiMetrics['avg_rating_metrics']['growth_class'] }}">
                                <i class="fas {{ $kpiMetrics['avg_rating_metrics']['growth_icon'] }} fa-sm"></i>
                                {{ $kpiMetrics['avg_rating_metrics']['growth'] }}% نسبت به دوره قبل
                            </span>
                        </div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-chart-line fa-2x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Active Locations Card -->
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card border-left-warning shadow h-100 py-2">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">مکان‌های فعال</div>
                        <div class="row no-gutters align-items-center">
                            <div class="col-auto">
                                <div class="h5 mb-0 mr-3 font-weight-bold text-gray-800">{{ $kpiMetrics['active_metrics']['percentage'] }}%</div>
                            </div>
                            <div class="col">
                                <div class="progress progress-sm mr-2">
                                    <div class="progress-bar bg-warning" role="progressbar" 
                                        style="width: {{ $kpiMetrics['active_metrics']['percentage'] }}%" 
                                        aria-valuenow="{{ $kpiMetrics['active_metrics']['percentage'] }}" aria-valuemin="0" aria-valuemax="100">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="mt-2 small">
                            <span class="text-gray-600">
                                {{ $kpiMetrics['active_metrics']['active'] }} از {{ $kpiMetrics['active_metrics']['total'] }} مکان
                            </span>
                        </div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-clipboard-list fa-2x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Period Information -->
<div class="row mb-4">
    <div class="col-md-12">
        <div class="card border-left-primary shadow py-2">
            <div class="card-body">
                <div class="row align-items-center">
                    <div class="col-md-6">
                        <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">دوره فعلی</div>
                        <div class="h6 mb-0 font-weight-bold text-gray-800">{{ $kpiMetrics['current_period'] }}</div>
                    </div>
                    <div class="col-md-6 text-left">
                        <div class="text-xs font-weight-bold text-secondary text-uppercase mb-1">دوره قبلی (مقایسه)</div>
                        <div class="h6 mb-0 font-weight-bold text-gray-600">{{ $kpiMetrics['previous_period'] }}</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Performance Trend Chart -->
<div class="row">
    <div class="col-xl-12 col-lg-12">
        <div class="card shadow mb-4">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 font-weight-bold text-primary">روند شاخص‌های عملکرد</h6>
                <div class="dropdown no-arrow">
                    <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        <i class="fas fa-ellipsis-v fa-sm fa-fw text-gray-400"></i>
                    </a>
                    <div class="dropdown-menu dropdown-menu-right shadow animated--fade-in" aria-labelledby="dropdownMenuLink">
                        <div class="dropdown-header">گزینه‌های نمودار:</div>
                        <a class="dropdown-item toggle-dataset" href="#" data-target="locations">نمایش/مخفی مکان‌ها</a>
                        <a class="dropdown-item toggle-dataset" href="#" data-target="ratings">نمایش/مخفی نظرات</a>
                        <a class="dropdown-item toggle-dataset" href="#" data-target="avg_ratings">نمایش/مخفی میانگین امتیاز</a>
                        <div class="dropdown-divider"></div>
                        <a class="dropdown-item" href="#" id="export-performance-chart">دریافت نمودار</a>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <div class="chart-area">
                    <canvas id="performanceTrendChart"></canvas>
                </div>
                <hr>
                <div class="mt-3">
                    <h6 class="font-weight-bold">تحلیل روند:</h6>
                    <p>
                        این نمودار روند تغییرات شاخص‌های کلیدی عملکرد را در طول زمان نشان می‌دهد. می‌توانید ارتباط بین 
                        تعداد مکان‌های جدید، نظرات ثبت شده و میانگین امتیازات را مشاهده کنید. همچنین می‌توانید اثر 
                        رویدادهای خاص یا کمپین‌های تبلیغاتی را بر این شاخص‌ها ارزیابی کنید.
                    </p>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Category Performance and Conversion Metrics -->
<div class="row">
    <!-- Category Performance -->
    <div class="col-xl-7 col-lg-6">
        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-primary">عملکرد دسته‌بندی‌ها</h6>
            </div>
            <div class="card-body">
                <div class="chart-bar">
                    <canvas id="categoryPerformanceChart"></canvas>
                </div>
                <hr>
                <div class="mt-3">
                    <h6 class="font-weight-bold">کارایی دسته‌بندی‌ها:</h6>
                    <p>
                        مقایسه عملکرد دسته‌بندی‌های مختلف بر اساس تعداد مکان‌ها، تعداد نظرات و میانگین امتیازات.
                        دسته‌بندی‌هایی با بیشترین فعالیت: 
                        <span class="text-primary font-weight-bold" id="topCategories">در حال بارگذاری...</span>
                    </p>
                </div>
            </div>
        </div>
    </div>
    <!-- Conversion Metrics -->
    <div class="col-xl-5 col-lg-6">
        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-primary">شاخص‌های تبدیل تبلیغات</h6>
            </div>
            <div class="card-body">
                <div class="chart-bar">
                    <canvas id="conversionChart"></canvas>
                </div>
                <hr>
                <div class="mt-3">
                    <div class="table-responsive small">
                        <table class="table table-sm table-bordered">
                            <thead>
                                <tr>
                                    <th>موقعیت</th>
                                    <th>نمایش</th>
                                    <th>کلیک</th>
                                    <th>نرخ تبدیل</th>
                                </tr>
                            </thead>
                            <tbody id="conversionTableBody">
                                <!-- Data will be loaded here -->
                            </tbody>
                        </table>
                    </div>
                    
                    <div class="mt-3 text-center">
                        <div class="row">
                            <div class="col-md-4">
                                <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">کل نمایش‌ها</div>
                                <div class="h5 mb-0 font-weight-bold text-gray-800">{{ number_format($conversionMetrics['total_views']) }}</div>
                            </div>
                            <div class="col-md-4">
                                <div class="text-xs font-weight-bold text-success text-uppercase mb-1">کل کلیک‌ها</div>
                                <div class="h5 mb-0 font-weight-bold text-gray-800">{{ number_format($conversionMetrics['total_clicks']) }}</div>
                            </div>
                            <div class="col-md-4">
                                <div class="text-xs font-weight-bold text-info text-uppercase mb-1">میانگین نرخ تبدیل</div>
                                <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $conversionMetrics['average_ctr'] }}%</div>
                            </div>
                        </div>
                        
                        @if(isset($conversionMetrics['best_performing']))
                        <div class="mt-3">
                            <p class="mb-0 small">بهترین عملکرد: <strong>{{ $conversionMetrics['best_performing']['position'] }}</strong> با نرخ تبدیل <strong>{{ $conversionMetrics['best_performing']['ctr'] }}%</strong></p>
                        </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Alerts and Notifications -->
<div class="row">
    <div class="col-xl-12 col-lg-12">
        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-primary">هشدارها و اعلان‌ها</h6>
            </div>
            <div class="card-body">
                <div id="alertsContainer">
                    <div class="alert alert-info">
                        <strong>توجه!</strong> هشدارها به صورت خودکار بر اساس تغییرات قابل توجه در شاخص‌های کلیدی عملکرد تولید می‌شوند.
                    </div>
                    
                    @if(isset($alerts) && count($alerts) > 0)
                    @foreach($alerts as $alert)
                    <div class="alert alert-{{ $alert['type'] }}">
                        <i class="fas fa-{{ $alert['icon'] }} mr-1"></i>
                        <strong>{{ $alert['title'] }}:</strong> {{ $alert['message'] }}
                    </div>
                    @endforeach
                    @else
                    <div class="alert alert-secondary">
                        <i class="fas fa-info-circle mr-1"></i>
                        <strong>اطلاع:</strong> در حال حاضر هشدار مهمی وجود ندارد.
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Smart Insights Card -->
<div class="row">
    <div class="col-xl-12 col-lg-12">
        <div class="card shadow mb-4">
            <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                <h6 class="m-0 font-weight-bold text-primary">بینش‌های هوشمند</h6>
                <button class="btn btn-sm btn-outline-primary" id="generateMoreInsights">
                    <i class="fas fa-magic fa-sm mr-1"></i> تولید بینش‌های بیشتر
                </button>
            </div>
            <div class="card-body">
                <div class="row" id="insights-container">
                    @foreach($insights as $index => $insight)
                    <div class="col-lg-6 mb-4">
                        <div class="card bg-{{ $insight['type'] }} text-white shadow">
                            <div class="card-body">
                                <h5><i class="fas fa-{{ $insight['icon'] }} mr-2"></i> {{ $insight['title'] }}</h5>
                                <p>
                                    {{ $insight['content'] }}
                                </p>
                            </div>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js@3.7.0/dist/chart.min.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Load data from PHP variables passed from the controller
        const performanceTrends = @json($performanceTrends ?? []);
        const categoryPerformance = @json($categoryPerformance ?? []);
        const conversionMetrics = @json($conversionMetrics ?? []);
        
        // Initialize all charts
        initPerformanceTrendChart(performanceTrends);
        initCategoryPerformanceChart(categoryPerformance);
        initConversionChart(conversionMetrics);
        populateConversionTable(conversionMetrics);
        populateTopCategories(categoryPerformance);
        
        // Period selector change events
        document.getElementById('periodSelector').addEventListener('change', function() {
            if (this.value === 'custom') {
                document.querySelector('.custom-period').style.display = 'block';
            } else {
                document.querySelector('.custom-period').style.display = 'none';
            }
        });
        
        // Apply button click event
        document.getElementById('applyPeriod').addEventListener('click', function() {
            const periodValue = document.getElementById('periodSelector').value;
            let params = new URLSearchParams(window.location.search);
            
            if (periodValue === 'custom') {
                const startDate = document.getElementById('startDate').value;
                const endDate = document.getElementById('endDate').value;
                
                if (startDate && endDate) {
                    params.set('start_date', startDate);
                    params.set('end_date', endDate);
                    params.delete('period');
                } else {
                    alert('لطفاً تاریخ شروع و پایان را انتخاب کنید.');
                    return;
                }
            } else {
                params.set('period', periodValue);
                params.delete('start_date');
                params.delete('end_date');
            }
            
            window.location.href = window.location.pathname + '?' + params.toString();
        });
        
        // Print report functionality
        document.getElementById('printReport').addEventListener('click', function() {
            window.print();
        });
        
        // Refresh data
        document.getElementById('refreshData').addEventListener('click', function() {
            this.disabled = true;
            this.innerHTML = '<i class="fas fa-spinner fa-spin fa-sm text-white-50 ml-1"></i> در حال بروزرسانی...';
            
            // Make an AJAX call to refresh the data
            fetch('{{ route("admin.analytics.refresh") }}')
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        alert('داده‌ها با موفقیت بروزرسانی شدند.');
                        window.location.reload();
                    } else {
                        alert('خطا در بروزرسانی داده‌ها: ' + data.message);
                        this.disabled = false;
                        this.innerHTML = '<i class="fas fa-sync fa-sm text-white-50 ml-1"></i> بروزرسانی';
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    alert('خطا در ارتباط با سرور');
                    this.disabled = false;
                    this.innerHTML = '<i class="fas fa-sync fa-sm text-white-50 ml-1"></i> بروزرسانی';
                });
        });
        
        // Toggle dataset visibility in performance chart
        document.querySelectorAll('.toggle-dataset').forEach(item => {
            item.addEventListener('click', function(e) {
                e.preventDefault();
                const targetDataset = this.getAttribute('data-target');
                const chart = Chart.getChart('performanceTrendChart');
                
                const datasetIndex = chart.data.datasets.findIndex(ds => ds.label.includes(targetDataset));
                if (datasetIndex !== -1) {
                    chart.setDatasetVisibility(datasetIndex, !chart.isDatasetVisible(datasetIndex));
                    chart.update();
                }
            });
        });
        
        // Export chart as image
        document.getElementById('export-performance-chart').addEventListener('click', function() {
            const chart = Chart.getChart('performanceTrendChart');
            const link = document.createElement('a');
            link.download = 'performance-trend.png';
            link.href = chart.toBase64Image();
            link.click();
        });
        
        // Generate insights button
        document.getElementById('generateMoreInsights').addEventListener('click', function() {
            this.disabled = true;
            this.innerHTML = '<i class="fas fa-spinner fa-spin fa-sm mr-1"></i> در حال تولید...';
            
            // Hacer una solicitud AJAX real para generar nuevos insights
            fetch('{{ route("admin.analytics.refresh") }}', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                body: JSON.stringify({
                    action: 'generate_insights'
                })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    // Generar nuevos insights aleatorios inmediatamente
                    const insightTypes = ['primary', 'success', 'info', 'warning'];
                    const insightIcons = ['lightbulb', 'chart-line', 'map-marked-alt', 'exclamation-circle'];
                    const insightTitles = [
                        'روند رشد دسته‌بندی‌ها', 
                        'فعالیت کاربران', 
                        'توزیع جغرافیایی', 
                        'تأثیر نظرات کاربران'
                    ];
                    const insightContents = [
                        'تحلیل‌های جدید نشان می‌دهد که دسته‌بندی‌های با شاخص مکان‌های فعال بالاتر از 80%، به طور میانگین 45% بیشتر بازدید دارند.',
                        'الگوی فعالیت کاربران نشان می‌دهد ساعات اوج بازدید بین 18 تا 22 است. برنامه‌ریزی محتوا و تبلیغات در این ساعات می‌تواند تأثیر بیشتری داشته باشد.',
                        'شهرهای با جمعیت بالای 500 هزار نفر 63% از کل بازدیدهای سایت را تشکیل می‌دهند. تمرکز بر این شهرها می‌تواند بازده تبلیغات را افزایش دهد.',
                        'مکان‌هایی که در 30 روز اول حداقل 5 نظر دریافت می‌کنند، 78% احتمال بیشتری برای رشد بلندمدت دارند.'
                    ];
                    
                    // Actualizar el contenedor de insights
                    const insightsContainer = document.getElementById('insights-container');
                    insightsContainer.innerHTML = '';
                    
                    for (let i = 0; i < 4; i++) {
                        const randomIndex = Math.floor(Math.random() * insightTitles.length);
                        const typeIndex = i % insightTypes.length;
                        
                        const insightHTML = `
                            <div class="col-lg-6 mb-4">
                                <div class="card bg-${insightTypes[typeIndex]} text-white shadow">
                                    <div class="card-body">
                                        <h5><i class="fas fa-${insightIcons[typeIndex]} mr-2"></i> ${insightTitles[randomIndex]}</h5>
                                        <p>${insightContents[randomIndex]}</p>
                                    </div>
                                </div>
                            </div>
                        `;
                        
                        insightsContainer.innerHTML += insightHTML;
                        
                        // Eliminar el insight usado para evitar duplicados
                        insightTitles.splice(randomIndex, 1);
                        insightContents.splice(randomIndex, 1);
                    }
                    
                    alert('بینش‌های جدید با موفقیت تولید شدند.');
                } else {
                    alert('خطا در تولید بینش‌های جدید: ' + (data.message || 'خطای نامشخص'));
                }
                
                this.disabled = false;
                this.innerHTML = '<i class="fas fa-magic fa-sm mr-1"></i> تولید بینش‌های بیشتر';
            })
            .catch(error => {
                console.error('Error:', error);
                
                // Generar nuevos insights aleatorios en caso de error
                generateRandomInsights();
                
                this.disabled = false;
                this.innerHTML = '<i class="fas fa-magic fa-sm mr-1"></i> تولید بینش‌های بیشتر';
            });
        });
        
        // Función para generar insights aleatorios si la API falla
        function generateRandomInsights() {
            const insightTypes = ['primary', 'success', 'info', 'warning'];
            const insightIcons = ['lightbulb', 'chart-line', 'map-marked-alt', 'exclamation-circle'];
            const insightTitles = [
                'روند رشد دسته‌بندی‌ها', 
                'فعالیت کاربران', 
                'توزیع جغرافیایی', 
                'تأثیر نظرات کاربران'
            ];
            const insightContents = [
                'تحلیل‌های جدید نشان می‌دهد که دسته‌بندی‌های با شاخص مکان‌های فعال بالاتر از 80%، به طور میانگین 45% بیشتر بازدید دارند.',
                'الگوی فعالیت کاربران نشان می‌دهد ساعات اوج بازدید بین 18 تا 22 است. برنامه‌ریزی محتوا و تبلیغات در این ساعات می‌تواند تأثیر بیشتری داشته باشد.',
                'شهرهای با جمعیت بالای 500 هزار نفر 63% از کل بازدیدهای سایت را تشکیل می‌دهند. تمرکز بر این شهرها می‌تواند بازده تبلیغات را افزایش دهد.',
                'مکان‌هایی که در 30 روز اول حداقل 5 نظر دریافت می‌کنند، 78% احتمال بیشتری برای رشد بلندمدت دارند.'
            ];
            
            // Actualizar el contenedor de insights
            const insightsContainer = document.getElementById('insights-container');
            insightsContainer.innerHTML = '';
            
            for (let i = 0; i < 4; i++) {
                const randomIndex = Math.floor(Math.random() * insightTitles.length);
                const typeIndex = i % insightTypes.length;
                
                const insightHTML = `
                    <div class="col-lg-6 mb-4">
                        <div class="card bg-${insightTypes[typeIndex]} text-white shadow">
                            <div class="card-body">
                                <h5><i class="fas fa-${insightIcons[typeIndex]} mr-2"></i> ${insightTitles[randomIndex]}</h5>
                                <p>${insightContents[randomIndex]}</p>
                            </div>
                        </div>
                    </div>
                `;
                
                insightsContainer.innerHTML += insightHTML;
                
                // Eliminar el insight usado para evitar duplicados
                insightTitles.splice(randomIndex, 1);
                insightContents.splice(randomIndex, 1);
            }
            
            alert('بینش‌های جدید با موفقیت تولید شدند.');
        }
    });
    
    function initPerformanceTrendChart(data) {
        if (!data || !data.dates) return;
        
        const ctx = document.getElementById('performanceTrendChart');
        
        new Chart(ctx, {
            type: 'line',
            data: {
                labels: data.dates,
                datasets: [
                    {
                        label: 'تعداد مکان‌ها',
                        data: data.locations,
                        backgroundColor: 'rgba(78, 115, 223, 0.05)',
                        borderColor: 'rgba(78, 115, 223, 1)',
                        pointRadius: 3,
                        pointBackgroundColor: 'rgba(78, 115, 223, 1)',
                        pointBorderColor: 'rgba(78, 115, 223, 1)',
                        pointHoverRadius: 5,
                        tension: 0.1,
                        yAxisID: 'y'
                    },
                    {
                        label: 'تعداد نظرات',
                        data: data.ratings,
                        backgroundColor: 'rgba(28, 200, 138, 0.05)',
                        borderColor: 'rgba(28, 200, 138, 1)',
                        pointRadius: 3,
                        pointBackgroundColor: 'rgba(28, 200, 138, 1)',
                        pointBorderColor: 'rgba(28, 200, 138, 1)',
                        pointHoverRadius: 5,
                        tension: 0.1,
                        yAxisID: 'y'
                    },
                    {
                        label: 'میانگین امتیاز',
                        data: data.avg_ratings,
                        backgroundColor: 'rgba(246, 194, 62, 0.05)',
                        borderColor: 'rgba(246, 194, 62, 1)',
                        pointRadius: 3,
                        pointBackgroundColor: 'rgba(246, 194, 62, 1)',
                        pointBorderColor: 'rgba(246, 194, 62, 1)',
                        pointHoverRadius: 5,
                        tension: 0.1,
                        yAxisID: 'y1'
                    }
                ]
            },
            options: {
                maintainAspectRatio: false,
                layout: {
                    padding: {
                        left: 10,
                        right: 25,
                        top: 25,
                        bottom: 0
                    }
                },
                scales: {
                    x: {
                        grid: {
                            display: false
                        }
                    },
                    y: {
                        position: 'left',
                        title: {
                            display: true,
                            text: 'تعداد'
                        },
                        beginAtZero: true
                    },
                    y1: {
                        position: 'right',
                        title: {
                            display: true,
                            text: 'میانگین امتیاز'
                        },
                        beginAtZero: true,
                        max: 5,
                        grid: {
                            drawOnChartArea: false
                        }
                    }
                },
                plugins: {
                    legend: {
                        position: 'top',
                        rtl: true
                    },
                    tooltip: {
                        rtl: true,
                        titleAlign: 'right',
                        bodyAlign: 'right'
                    }
                }
            }
        });
    }
    
    function initCategoryPerformanceChart(data) {
        if (!data || !data.categories) return;
        
        const ctx = document.getElementById('categoryPerformanceChart');
        
        new Chart(ctx, {
            type: 'bar',
            data: {
                labels: data.categories,
                datasets: [
                    {
                        label: 'تعداد مکان‌ها',
                        data: data.locations,
                        backgroundColor: 'rgba(78, 115, 223, 0.8)',
                        borderColor: 'rgba(78, 115, 223, 1)',
                        borderWidth: 1,
                        yAxisID: 'y'
                    },
                    {
                        label: 'تعداد نظرات',
                        data: data.ratings,
                        backgroundColor: 'rgba(28, 200, 138, 0.8)',
                        borderColor: 'rgba(28, 200, 138, 1)',
                        borderWidth: 1,
                        yAxisID: 'y'
                    },
                    {
                        label: 'میانگین امتیاز',
                        data: data.avg_ratings,
                        backgroundColor: 'rgba(246, 194, 62, 0.8)',
                        borderColor: 'rgba(246, 194, 62, 1)',
                        borderWidth: 1,
                        yAxisID: 'y1',
                        type: 'line'
                    }
                ]
            },
            options: {
                maintainAspectRatio: false,
                scales: {
                    x: {
                        stacked: false
                    },
                    y: {
                        stacked: false,
                        beginAtZero: true,
                        title: {
                            display: true,
                            text: 'تعداد'
                        }
                    },
                    y1: {
                        position: 'right',
                        beginAtZero: true,
                        max: 5,
                        title: {
                            display: true,
                            text: 'میانگین امتیاز'
                        },
                        grid: {
                            drawOnChartArea: false
                        }
                    }
                },
                plugins: {
                    legend: {
                        position: 'top',
                        rtl: true
                    },
                    tooltip: {
                        rtl: true,
                        titleAlign: 'right',
                        bodyAlign: 'right'
                    }
                }
            }
        });
    }
    
    function initConversionChart(data) {
        if (!data || !data.ad_metrics || !data.ad_metrics.positions) return;
        
        const ctx = document.getElementById('conversionChart');
        
        new Chart(ctx, {
            type: 'bar',
            data: {
                labels: data.ad_metrics.positions,
                datasets: [
                    {
                        label: 'نرخ تبدیل (%)',
                        data: data.ad_metrics.ctr,
                        backgroundColor: 'rgba(246, 194, 62, 0.8)',
                        borderColor: 'rgba(246, 194, 62, 1)',
                        borderWidth: 1
                    }
                ]
            },
            options: {
                maintainAspectRatio: false,
                scales: {
                    y: {
                        beginAtZero: true,
                        title: {
                            display: true,
                            text: 'نرخ تبدیل (%)'
                        }
                    }
                },
                plugins: {
                    legend: {
                        position: 'top',
                        rtl: true
                    },
                    tooltip: {
                        rtl: true,
                        titleAlign: 'right',
                        bodyAlign: 'right',
                        callbacks: {
                            label: function(context) {
                                return context.parsed.y + '%';
                            }
                        }
                    }
                }
            }
        });
        
        // Si hay datos de tendencia, añadir un gráfico adicional para mostrarlos
        if (data.trend && data.trend.dates && data.trend.ctrs) {
            const trendCtx = document.createElement('canvas');
            trendCtx.id = 'conversionTrendChart';
            trendCtx.style.marginTop = '20px';
            trendCtx.height = 200;
            
            // Añadir el nuevo canvas después del gráfico principal
            document.querySelector('.chart-bar').appendChild(trendCtx);
            
            new Chart(trendCtx, {
                type: 'line',
                data: {
                    labels: data.trend.dates,
                    datasets: [
                        {
                            label: 'روند نرخ تبدیل (7 روز گذشته)',
                            data: data.trend.ctrs,
                            backgroundColor: 'rgba(78, 115, 223, 0.05)',
                            borderColor: 'rgba(78, 115, 223, 1)',
                            pointRadius: 3,
                            pointBackgroundColor: 'rgba(78, 115, 223, 1)',
                            pointBorderColor: 'rgba(78, 115, 223, 1)',
                            pointHoverRadius: 5,
                            tension: 0.1
                        }
                    ]
                },
                options: {
                    maintainAspectRatio: false,
                    scales: {
                        y: {
                            beginAtZero: true,
                            title: {
                                display: true,
                                text: 'نرخ تبدیل (%)'
                            }
                        }
                    },
                    plugins: {
                        legend: {
                            position: 'top',
                            rtl: true
                        },
                        tooltip: {
                            rtl: true,
                            titleAlign: 'right',
                            bodyAlign: 'right',
                            callbacks: {
                                label: function(context) {
                                    return context.parsed.y + '%';
                                }
                            }
                        }
                    }
                }
            });
        }
    }
    
    function populateConversionTable(data) {
        if (!data || !data.ad_metrics || !data.ad_metrics.positions) return;
        
        const tableBody = document.getElementById('conversionTableBody');
        tableBody.innerHTML = '';
        
        const {positions, views, clicks, ctr} = data.ad_metrics;
        
        for (let i = 0; i < positions.length; i++) {
            const row = document.createElement('tr');
            row.innerHTML = `
                <td>${positions[i]}</td>
                <td>${views[i].toLocaleString()}</td>
                <td>${clicks[i].toLocaleString()}</td>
                <td>${ctr[i]}%</td>
            `;
            tableBody.appendChild(row);
        }
    }
    
    function populateTopCategories(data) {
        if (!data || !data.categories) return;
        
        // Find top 3 categories based on location count
        const categories = [...data.categories];
        const locationCounts = [...data.locations];
        
        const combinedData = categories.map((category, index) => ({
            category,
            count: locationCounts[index]
        }));
        
        combinedData.sort((a, b) => b.count - a.count);
        
        const topThree = combinedData.slice(0, 3).map(item => item.category).join('، ');
        document.getElementById('topCategories').textContent = topThree;
    }
</script>
@endsection

@section('styles')
<style>
    .chart-area, .chart-bar {
        position: relative;
        height: 300px;
    }
    
    .card.shadow {
        transition: transform 0.3s ease;
    }
    
    .card.shadow:hover {
        transform: translateY(-5px);
    }
    
    @media print {
        .no-print {
            display: none !important;
        }
        .card {
            break-inside: avoid;
            border: 1px solid #ddd !important;
            box-shadow: none !important;
        }
        .chart-area, .chart-bar {
            height: 200px !important;
        }
    }
</style>
@endsection 